<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile CDAR2.Observation
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Observation</sch:title>
    <sch:rule context="f:Observation">
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:statusCode) &gt;= 1">statusCode: minimum cardinality of 'statusCode' is 1</sch:assert>
      <sch:assert test="count(f:value) &gt;= 1">value: minimum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
      <sch:assert test="count(f:methodCode) &lt;= 1">methodCode: maximum cardinality of 'methodCode' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:templateId</sch:title>
    <sch:rule context="f:Observation/f:templateId">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &gt;= 1">root: minimum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &gt;= 1">extension: minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:code</sch:title>
    <sch:rule context="f:Observation/f:code">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &lt;= 1">codeSystem: maximum cardinality of 'codeSystem' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemName) &lt;= 1">codeSystemName: maximum cardinality of 'codeSystemName' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemVersion) &lt;= 1">codeSystemVersion: maximum cardinality of 'codeSystemVersion' is 1</sch:assert>
      <sch:assert test="count(f:displayName) &lt;= 1">displayName: maximum cardinality of 'displayName' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSet) &lt;= 1">sdtcValueSet: maximum cardinality of 'sdtcValueSet' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSetVersion) &lt;= 1">sdtcValueSetVersion: maximum cardinality of 'sdtcValueSetVersion' is 1</sch:assert>
      <sch:assert test="count(f:originalText) &lt;= 1">originalText: maximum cardinality of 'originalText' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:code/f:originalText</sch:title>
    <sch:rule context="f:Observation/f:code/f:originalText">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:charset) &lt;= 1">charset: maximum cardinality of 'charset' is 1</sch:assert>
      <sch:assert test="count(f:compression) &lt;= 1">compression: maximum cardinality of 'compression' is 1</sch:assert>
      <sch:assert test="count(f:integrityCheck) &lt;= 1">integrityCheck: maximum cardinality of 'integrityCheck' is 1</sch:assert>
      <sch:assert test="count(f:integrityCheckAlgorithm) &lt;= 1">integrityCheckAlgorithm: maximum cardinality of 'integrityCheckAlgorithm' is 1</sch:assert>
      <sch:assert test="count(f:language) &lt;= 1">language: maximum cardinality of 'language' is 1</sch:assert>
      <sch:assert test="count(f:mediaType) &lt;= 1">mediaType: maximum cardinality of 'mediaType' is 1</sch:assert>
      <sch:assert test="count(f:representation) &lt;= 1">representation: maximum cardinality of 'representation' is 1</sch:assert>
      <sch:assert test="count(f:data[x]) &lt;= 1">data[x]: maximum cardinality of 'data[x]' is 1</sch:assert>
      <sch:assert test="count(f:reference) &lt;= 1">reference: maximum cardinality of 'reference' is 1</sch:assert>
      <sch:assert test="count(f:thumbnail) &lt;= 1">thumbnail: maximum cardinality of 'thumbnail' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:code/f:originalText/f:reference</sch:title>
    <sch:rule context="f:Observation/f:code/f:originalText/f:reference">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:value) &lt;= 1">value: maximum cardinality of 'value' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:statusCode</sch:title>
    <sch:rule context="f:Observation/f:statusCode">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &lt;= 0">codeSystem: maximum cardinality of 'codeSystem' is 0</sch:assert>
      <sch:assert test="count(f:codeSystemName) &lt;= 0">codeSystemName: maximum cardinality of 'codeSystemName' is 0</sch:assert>
      <sch:assert test="count(f:codeSystemVersion) &lt;= 0">codeSystemVersion: maximum cardinality of 'codeSystemVersion' is 0</sch:assert>
      <sch:assert test="count(f:displayName) &lt;= 0">displayName: maximum cardinality of 'displayName' is 0</sch:assert>
      <sch:assert test="count(f:sdtcValueSet) &lt;= 1">sdtcValueSet: maximum cardinality of 'sdtcValueSet' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSetVersion) &lt;= 1">sdtcValueSetVersion: maximum cardinality of 'sdtcValueSetVersion' is 1</sch:assert>
      <sch:assert test="count(f:originalText) &lt;= 0">originalText: maximum cardinality of 'originalText' is 0</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 0">qualifier: maximum cardinality of 'qualifier' is 0</sch:assert>
      <sch:assert test="count(f:translation) &lt;= 0">translation: maximum cardinality of 'translation' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:value</sch:title>
    <sch:rule context="f:Observation/f:value">
      <sch:assert test="count(f:id) &lt;= 1">id: maximum cardinality of 'id' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>Observation.value.extension</sch:title>
    <sch:rule context="f:Observation/f:value/f:extension">
      <sch:assert test="@value|f:*|h:div">All FHIR elements must have a @value or children</sch:assert>
      <sch:assert test="exists(f:extension)!=exists(f:*[starts-with(local-name(.), &quot;value&quot;)])">Must have either extensions or value[x], not both</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:performer</sch:title>
    <sch:rule context="f:Observation/f:performer">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:functionCode) &lt;= 1">functionCode: maximum cardinality of 'functionCode' is 1</sch:assert>
      <sch:assert test="count(f:time) &lt;= 1">time: maximum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:modeCode) &lt;= 1">modeCode: maximum cardinality of 'modeCode' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &gt;= 1">assignedEntity: minimum cardinality of 'assignedEntity' is 1</sch:assert>
      <sch:assert test="count(f:assignedEntity) &lt;= 1">assignedEntity: maximum cardinality of 'assignedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:performer/f:assignedEntity</sch:title>
    <sch:rule context="f:Observation/f:performer/f:assignedEntity">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:id) &gt;= 1">id: minimum cardinality of 'id' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:assignedPerson) &lt;= 1">assignedPerson: maximum cardinality of 'assignedPerson' is 1</sch:assert>
      <sch:assert test="count(f:representedOrganization) &lt;= 1">representedOrganization: maximum cardinality of 'representedOrganization' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:performer/f:assignedEntity/f:representedOrganization</sch:title>
    <sch:rule context="f:Observation/f:performer/f:assignedEntity/f:representedOrganization">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &gt;= 1">determinerCode: minimum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:determinerCode) &lt;= 1">determinerCode: maximum cardinality of 'determinerCode' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &gt;= 1">telecom: minimum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:telecom) &lt;= 1">telecom: maximum cardinality of 'telecom' is 1</sch:assert>
      <sch:assert test="count(f:addr) &gt;= 1">addr: minimum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:addr) &lt;= 1">addr: maximum cardinality of 'addr' is 1</sch:assert>
      <sch:assert test="count(f:standardIndustryClassCode) &lt;= 1">standardIndustryClassCode: maximum cardinality of 'standardIndustryClassCode' is 1</sch:assert>
      <sch:assert test="count(f:asOrganizationPartOf) &lt;= 1">asOrganizationPartOf: maximum cardinality of 'asOrganizationPartOf' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:participant</sch:title>
    <sch:rule context="f:Observation/f:participant">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &gt;= 1">typeCode: minimum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextControlCode) &lt;= 1">contextControlCode: maximum cardinality of 'contextControlCode' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:sdtcFunctionCode) &lt;= 1">sdtcFunctionCode: maximum cardinality of 'sdtcFunctionCode' is 1</sch:assert>
      <sch:assert test="count(f:time) &lt;= 1">time: maximum cardinality of 'time' is 1</sch:assert>
      <sch:assert test="count(f:awarenessCode) &lt;= 1">awarenessCode: maximum cardinality of 'awarenessCode' is 1</sch:assert>
      <sch:assert test="count(f:participantRole) &gt;= 1">participantRole: minimum cardinality of 'participantRole' is 1</sch:assert>
      <sch:assert test="count(f:participantRole) &lt;= 1">participantRole: maximum cardinality of 'participantRole' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Observation/f:entryRelationship</sch:title>
    <sch:rule context="f:Observation/f:entryRelationship">
      <sch:assert test="count(f:inversionInd) &gt;= 1">inversionInd: minimum cardinality of 'inversionInd' is 1</sch:assert>
      <sch:assert test="count(f:observation) &lt;= 0">observation: maximum cardinality of 'observation' is 0</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &gt;= 1">encounter: minimum cardinality of 'encounter' is 1</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:inversionInd) &gt;= 1">inversionInd: minimum cardinality of 'inversionInd' is 1</sch:assert>
      <sch:assert test="count(f:observation) &lt;= 0">observation: maximum cardinality of 'observation' is 0</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &gt;= 1">act: minimum cardinality of 'act' is 1</sch:assert>
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:observation) &lt;= 0">observation: maximum cardinality of 'observation' is 0</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &gt;= 1">substanceAdministration: minimum cardinality of 'substanceAdministration' is 1</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
