<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile VitalSignsSectionEntriesOptional
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Section/f:entry</sch:title>
    <sch:rule context="f:Section/f:entry">
      <sch:assert test="count(f:observation) &lt;= 0">observation: maximum cardinality of 'observation' is 0</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &gt;= 1">organizer: minimum cardinality of 'organizer' is 1</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
