<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile CDAR2.Section
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:Section</sch:title>
    <sch:rule context="f:Section">
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:title) &gt;= 1">title: minimum cardinality of 'title' is 1</sch:assert>
      <sch:assert test="count(f:text) &gt;= 1">text: minimum cardinality of 'text' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Section/f:templateId</sch:title>
    <sch:rule context="f:Section/f:templateId">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:assigningAuthorityName) &lt;= 1">assigningAuthorityName: maximum cardinality of 'assigningAuthorityName' is 1</sch:assert>
      <sch:assert test="count(f:displayable) &lt;= 1">displayable: maximum cardinality of 'displayable' is 1</sch:assert>
      <sch:assert test="count(f:root) &gt;= 1">root: minimum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:root) &lt;= 1">root: maximum cardinality of 'root' is 1</sch:assert>
      <sch:assert test="count(f:extension) &gt;= 1">extension: minimum cardinality of 'extension' is 1</sch:assert>
      <sch:assert test="count(f:extension) &lt;= 1">extension: maximum cardinality of 'extension' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Section/f:code</sch:title>
    <sch:rule context="f:Section/f:code">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:code) &gt;= 1">code: minimum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:code) &lt;= 1">code: maximum cardinality of 'code' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &gt;= 1">codeSystem: minimum cardinality of 'codeSystem' is 1</sch:assert>
      <sch:assert test="count(f:codeSystem) &lt;= 1">codeSystem: maximum cardinality of 'codeSystem' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemName) &lt;= 1">codeSystemName: maximum cardinality of 'codeSystemName' is 1</sch:assert>
      <sch:assert test="count(f:codeSystemVersion) &lt;= 1">codeSystemVersion: maximum cardinality of 'codeSystemVersion' is 1</sch:assert>
      <sch:assert test="count(f:displayName) &lt;= 1">displayName: maximum cardinality of 'displayName' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSet) &lt;= 1">sdtcValueSet: maximum cardinality of 'sdtcValueSet' is 1</sch:assert>
      <sch:assert test="count(f:sdtcValueSetVersion) &lt;= 1">sdtcValueSetVersion: maximum cardinality of 'sdtcValueSetVersion' is 1</sch:assert>
      <sch:assert test="count(f:originalText) &lt;= 1">originalText: maximum cardinality of 'originalText' is 1</sch:assert>
      <sch:assert test="count(f:qualifier) &lt;= 0">qualifier: maximum cardinality of 'qualifier' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:Section/f:entry</sch:title>
    <sch:rule context="f:Section/f:entry">
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
      <sch:assert test="count(f:observation) &gt;= 1">observation: minimum cardinality of 'observation' is 1</sch:assert>
      <sch:assert test="count(f:regionOfInterest) &lt;= 0">regionOfInterest: maximum cardinality of 'regionOfInterest' is 0</sch:assert>
      <sch:assert test="count(f:observationMedia) &lt;= 0">observationMedia: maximum cardinality of 'observationMedia' is 0</sch:assert>
      <sch:assert test="count(f:substanceAdministration) &lt;= 0">substanceAdministration: maximum cardinality of 'substanceAdministration' is 0</sch:assert>
      <sch:assert test="count(f:supply) &lt;= 0">supply: maximum cardinality of 'supply' is 0</sch:assert>
      <sch:assert test="count(f:procedure) &lt;= 0">procedure: maximum cardinality of 'procedure' is 0</sch:assert>
      <sch:assert test="count(f:encounter) &lt;= 0">encounter: maximum cardinality of 'encounter' is 0</sch:assert>
      <sch:assert test="count(f:organizer) &lt;= 0">organizer: maximum cardinality of 'organizer' is 0</sch:assert>
      <sch:assert test="count(f:act) &lt;= 0">act: maximum cardinality of 'act' is 0</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
