<?xml version="1.0" encoding="UTF-8"?>
<sch:schema xmlns:sch="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
  <sch:ns prefix="f" uri="http://hl7.org/fhir"/>
  <sch:ns prefix="h" uri="http://www.w3.org/1999/xhtml"/>
  <!-- 
    This file contains just the constraints for the profile USRealmHeader
    It includes the base constraints for the resource as well.
    Because of the way that schematrons and containment work, 
    you may need to use this schematron fragment to build a, 
    single schematron that validates contained resources (if you have any) 
  -->
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:informant</sch:title>
    <sch:rule context="f:ClinicalDocument/f:informant">
      <sch:assert test="count(f:relatedEntity) &gt;= 1">relatedEntity: minimum cardinality of 'relatedEntity' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:component</sch:title>
    <sch:rule context="f:ClinicalDocument/f:component">
      <sch:assert test="count(f:nullFlavor) &lt;= 1">nullFlavor: maximum cardinality of 'nullFlavor' is 1</sch:assert>
      <sch:assert test="count(f:typeCode) &lt;= 1">typeCode: maximum cardinality of 'typeCode' is 1</sch:assert>
      <sch:assert test="count(f:contextConductionInd) &gt;= 1">contextConductionInd: minimum cardinality of 'contextConductionInd' is 1</sch:assert>
      <sch:assert test="count(f:contextConductionInd) &lt;= 1">contextConductionInd: maximum cardinality of 'contextConductionInd' is 1</sch:assert>
      <sch:assert test="count(f:typeId) &lt;= 1">typeId: maximum cardinality of 'typeId' is 1</sch:assert>
      <sch:assert test="count(f:nonXMLBody) &gt;= 1">nonXMLBody: minimum cardinality of 'nonXMLBody' is 1</sch:assert>
      <sch:assert test="count(f:nonXMLBody) &lt;= 1">nonXMLBody: maximum cardinality of 'nonXMLBody' is 1</sch:assert>
      <sch:assert test="count(f:structuredBody) &lt;= 1">structuredBody: maximum cardinality of 'structuredBody' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
  <sch:pattern>
    <sch:title>f:ClinicalDocument/f:component/f:nonXMLBody</sch:title>
    <sch:rule context="f:ClinicalDocument/f:component/f:nonXMLBody">
      <sch:assert test="count(f:classCode) &gt;= 1">classCode: minimum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:classCode) &lt;= 1">classCode: maximum cardinality of 'classCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &gt;= 1">moodCode: minimum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:moodCode) &lt;= 1">moodCode: maximum cardinality of 'moodCode' is 1</sch:assert>
      <sch:assert test="count(f:text) &gt;= 1">text: minimum cardinality of 'text' is 1</sch:assert>
      <sch:assert test="count(f:text) &lt;= 1">text: maximum cardinality of 'text' is 1</sch:assert>
      <sch:assert test="count(f:confidentialityCode) &lt;= 1">confidentialityCode: maximum cardinality of 'confidentialityCode' is 1</sch:assert>
      <sch:assert test="count(f:languageCode) &lt;= 1">languageCode: maximum cardinality of 'languageCode' is 1</sch:assert>
    </sch:rule>
  </sch:pattern>
</sch:schema>
