# Logical models - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Logical models**

## Logical models

This page lists the HL7 FHIR logical models used to represent Emergency medical service report.

| | | |
| :--- | :--- | :--- |
| Name | Title | Description |
| [LogEnSzzCz](StructureDefinition-SzzCz.md) | A - Shared Health Record | Logical model of the Shared Health Record according to Czech specifications. |
| [LogEnHeaderSzzCz](StructureDefinition-HeaderSzzCz.md) | A.1 - Document header | Header of the shared health record according to Czech specifications. |
| [LogEnSubjectCz](StructureDefinition-SubjectCz.md) | A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject | Shared Health Record - subject data element |
| [LogEnDigitalSignatureCz](StructureDefinition-DigitalSignatureCz.md) | A.1.7 - Digital signature | Shared Health Record - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [LogEnEmergencyRecordCz](StructureDefinition-EmergencyRecordCz.md) | A.2 - Emergency health record | Shared Health Record - Logical model of Emergency Health Record. |
| [LogEnPreventiveAndScreeningRecordCz](StructureDefinition-PreventiveAndScreeningRecordCz.md) | A.3 - Preventive and screening health record | Shared Health Record - Logical model of Preventive and screening health record |
| [LogEnGeneralPractitionerCz](StructureDefinition-GeneralPractitionerCz.md) | A.3.1 - General Practitioner | Shared Health Record - Preventive and screening examinations by a general practitioner. |
| [LogEnGynecologyCz](StructureDefinition-GynecologyCz.md) | A.3.2 - Gynecology | Shared Health Record - Preventive and screening examinations by a gynecologist. |
| [LogEnGastroenterologyCz](StructureDefinition-GastroenterologyCz.md) | A.3.3 - Gastroenterology | Shared Health Record - Screening examination by gastroenterologist. |
| [LogEnRadiologyCz](StructureDefinition-RadiologyCz.md) | A.3.4 - Radiology | Shared Health Record - Screening examination by radiologist. |
| [LogEnBiochemistryLabCz](StructureDefinition-BiochemistryLabCz.md) | A.3.5 - Biochemistry Lab | Shared Health Record - Screenings performed by the Biochemical Laboratory. |
| [LogEnPulmonologyCz](StructureDefinition-PulmonologyCz.md) | A.3.6 - Pulmonology | Shared Health Record - Screening examination by pulmonologist |
| [LogEnUrologyCz](StructureDefinition-UrologyCz.md) | A.3.7 - Urology | Shared Health Record - Screening examination by urologist. |
| [LogEnAngiologyCz](StructureDefinition-AngiologyCz.md) | A.3.8 - Angiology | Shared Health Record - Screening examination by angiologist |

