# Home - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Home**

## Home

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/ImplementationGuide/hl7.fhir.cz.szz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:HL7CzSZZImplementationGuide |

## Introduction

This implementation specification is based on the [FHIR version R4](https://hl7.org/fhir/R4/), and defines a unified framework for representing the Shared Health Record in the Czech national context. The specification defines the content and structural components of the document and ensures their compliance with the legal requirements of the Czech Republic as well as with European initiatives in the field of electronic health record interoperability.

The main objective is to create a standardized form of the Shared Health Record as part of the patient’s medical documentation, which will be used for the electronic exchange of health information between healthcare providers, the patient, and the national infrastructure.

### Scope

This guide is divided into several pages, which are listed in the menu bar at the top of each page.

* [Home](index.md): This page provides introductory information, a brief scope of use, references, dependencies, version difference analysis, and intellectual property statements.
* Introduction: 
* [Scope and Content](scope-and-content.md): This section contains introductory general information about the Shared Health Record.
* [Background](background.md): This section provides general information on the origins of the definition of the Shared Health Record.
 
* Functional: 
* [Use Cases](use-cases.md): This section contains information about use cases.
* [Workflow](workflow.md): This segment contains information about workflow.
* [Logical Models](logical-models.md): This section contains information about logical models.
 
* Implementation: 
* [Mapping to profiles](model-map.md): This section contains information on mapping the logical model to the Shared Health Record profiles.
* [Examples](examples.md): This section contains examples.
 
* About: 
* [Authors](authors.md): This section contains information about the authors.
* [Downloads](downloads.md): This section provides information about available downloads of the implementation specification.
* [Dependencies](dependencies.md): This section provides information about dependencies.
* [Copyright](copyright.md): This section provides information about copyright.
 
* [Artifacts](artifacts.md): This page provides a list of FHIR artifacts defined as part of this implementation guide.

### References

* Related specifications: 
* [EHDS Logical Information Models](http://build.fhir.org/ig/Xt-EHR/xt-ehr-common/index.html) 
* This specification has inspired many of the design patterns defined in this IG.
 
* [HL7 Czech Base and Core Implementation Guide](http://build.fhir.org/ig/HL7-cz/cz-core/index.html) 
* Where possible this specification has been aligned with choices made in CZ core.
 
 

### Dependencies












### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.fhir.cz.szz.r4)](package.r4.tgz) and [R4B (hl7.fhir.cz.szz.r4b)](package.r4b.tgz) are available.

### IP statements

This publication includes IP covered under the following statements.

* ISO maintains the copyright on the country codes, and controls its use carefully. For further details see the ISO 3166 web page: [https://www.iso.org/iso-3166-country-codes.html](https://www.iso.org/iso-3166-country-codes.html)

* [ISO 3166-1 Codes for the representation of names of countries and their subdivisions — Part 1: Country code](http://terminology.hl7.org/6.5.0/CodeSystem-ISO3166Part1.html): [AbdominaAorticAneurysmsResultCS](CodeSystem-cz-abdomina-aortic-aneurysms-result-cs.md), [AbdominaAorticAneurysmsResultVs](ValueSet-cz-abdomina-aortic-aneurysms-result-vs.md)...Show 132 more,[AllergyIntoleranceTypeSzzCs](CodeSystem-cz-allergy-intolerance-type-szz-cs.md),[AllergyIntoleranceTypeSzzVs](ValueSet-cz-allergy-intolerance-type-szz-vs.md),[AllergyReactionCategorySzzVs](ValueSet-cz-allergy-reaction-category-szz-vs.md),[BiradsDensityCS](CodeSystem-cz-birads-density-cs.md),[BiradsDensityVS](ValueSet-cz-birads-density-vs.md),[BloodPressureCodeSzzVs](ValueSet-cz-blood-pressure-code-szz-vs.md),[BloodTypeEhdsiVs](ValueSet-cz-blood-type-ehdsi-vs.md),[BloodTypeLaboratoryCodeSzzVs](ValueSet-cz-blood-type-laboratory-code-szz-vs.md),[Bundle/cz-example-bundle-emergencyrecord](Bundle-cz-example-bundle-emergencyrecord.md),[Bundle/cz-example-bundle-screeningrecord](Bundle-cz-example-bundle-screeningrecord.md),[Bundle/cz-example-bundle-screeningrecord-2](Bundle-cz-example-bundle-screeningrecord-2.md),[CZ_AdverseEvent](StructureDefinition-cz-adverse-event.md),[CZ_AllergyIntoleranceSzz](StructureDefinition-cz-allergyIntolerance-szz.md),[CZ_BodyHeight](StructureDefinition-cz-bodyheight.md),[CZ_BodyWeight](StructureDefinition-cz-bodyweight.md),[CZ_BundleSzz](StructureDefinition-cz-bundle-sharedhealthrecord.md),[CZ_ColonoscopyAbnormalFindingsCS](CodeSystem-cz-colonoscopy-abnormal-findings-cs.md),[CZ_ColonoscopyAbnormalFindingsVS](ValueSet-cz-colonoscopy-abnormal-findings-vs.md),[CZ_ColonoscopyInterpretation](CodeSystem-cz-colonoscopy-interpretation.md),[CZ_ColonoscopyInterpretationVS](ValueSet-cz-colonoscopy-interpretation-vs.md),[CZ_ColonoscopyTypeCS](CodeSystem-cz-colonoscopy-type-cs.md),[CZ_ColonoscopyTypeVS](ValueSet-cz-colonoscopy-type-vs.md),[CZ_CompositionSzz](StructureDefinition-cz-composition-sharedhealthrecord.md),[CZ_HpvVaccineCodeVs](ValueSet-cz-hpv-vaccine-code-vs.md),[CZ_ImmunizationHPV](StructureDefinition-cz-immunization-hpv.md),[CZ_ObservationAbdominaAorticAneurysms](StructureDefinition-cz-observation-abdomina-aortic-aneurysms.md),[CZ_ObservationBloodPressure](StructureDefinition-cz-observation-blood-pressure.md),[CZ_ObservationBloodType](StructureDefinition-cz-observation-blood-type.md),[CZ_ObservationColonoscopy](StructureDefinition-cz-observation-colonoscopy.md),[CZ_ObservationColorectalCancer](StructureDefinition-cz-observation-colorectal-cancer.md),[CZ_ObservationColposcopyCervicalCancer](StructureDefinition-cz-observation-colposcopy-cervical-cancer.md),[CZ_ObservationCytologyCervicalCancer](StructureDefinition-cz-observation-cytology-cervical-cancer.md),[CZ_ObservationHPVCervicalCancer](StructureDefinition-cz-observation-hpv-cervical-cancer.md),[CZ_ObservationLungCancer](StructureDefinition-cz-observation-lung-cancer.md),[CZ_ObservationMRIProstateCancer](StructureDefinition-cz-observation-mri-prostate-cancer.md),[CZ_ObservationMammography](StructureDefinition-cz-observation-mammography.md),[CZ_ObservationMammographyBiopsy](StructureDefinition-cz-observation-mammography-biopsy.md),[CZ_ObservationProstateCancer](StructureDefinition-cz-observation-prostate-cancer.md),[CZ_ObservationPulmonology](StructureDefinition-cz-observation-pulmonology.md),[CZ_ObservationUnitsHeightVs](ValueSet-cz-observationUnitsHeight-vs.md),[CZ_ObservationUnitsWeightVs](ValueSet-cz-observationUnitsWeight-vs.md),[CZ_ObservationUrology](StructureDefinition-cz-observation-urology.md),[CZ_ObservationUrologyBiopsy](StructureDefinition-cz-observation-urology-biopsy.md),[CZ_WaistCircumference](StructureDefinition-cz-waist-circumference.md),[CervicalCancerColposcopyResultCS](CodeSystem-cz-cervical-cancer-colposcopy-result-cs.md),[CervicalCancerColposcopyResultVS](ValueSet-cz-cervical-cancer-colposcopy-result-vs.md),[CervicalCancerCytologyResultCS](CodeSystem-cz-cervical-cancer-cytology-result-cs.md),[CervicalCancerCytologyResultVS](ValueSet-cz-cervical-cancer-cytology-result-vs.md),[CervicalCancerHPVResultCS](CodeSystem-cz-cervical-cancer-hpv-result-cs.md),[CervicalCancerHPVResultVS](ValueSet-cz-cervical-cancer-hpv-result-vs.md),[ClinicalSeverityOfSymptomsSzzCs](CodeSystem-cz-clinical-severity-of-symptoms-szz-cs.md),[ClinicalSeverityOfSymptomsSzzVs](ValueSet-cz-clinical-severity-of-symptoms-szz-vs.md),[ColorectalCancerResultAlternateVS](ValueSet-cz-colorectal-cancer-result-alternate-vs.md),[ColorectalCancerResultCS](CodeSystem-cz-colorectal-cancer-result-cs.md),[ColorectalCancerResultVS](ValueSet-cz-colorectal-cancer-result-vs.md),[DensityTypeCs](CodeSystem-cz-density-type-cs.md),[DocumentSectionCzSzzCs](CodeSystem-cz-document-section-szz-cs.md),[EmergencyRecord2FHIR](ConceptMap-EmergencyRecord2FHIR-cz.md),[FunctionalExaminationPulmonologyResultCS](CodeSystem-cz-functional-examination-pulmonology-result-cs.md),[FunctionalExaminationPulmonologyResultVS](ValueSet-cz-functional-examination-pulmonology-result-vs.md),[HL7CzSZZImplementationGuide](index.md),[Header2FHIR](ConceptMap-Header2FHIR-cz.md),[LogCzAngiologyCz](StructureDefinition-LogAngiologyCz.md),[LogCzBiochemistryLabCz](StructureDefinition-LogBiochemistryLabCz.md),[LogCzDigitalSignatureCz](StructureDefinition-logDigitalSignatureCz.md),[LogCzEmergencyRecordCz](StructureDefinition-LogEmergencyRecordCz.md),[LogCzGastroenterologyCz](StructureDefinition-logGastroenterologyCz.md),[LogCzGeneralPractitionerCz](StructureDefinition-logGeneralPractitionerCz.md),[LogCzGynecologyCz](StructureDefinition-logGynecologyCz.md),[LogCzHeaderSzzCz](StructureDefinition-LogHeaderSzzCz.md),[LogCzPreventiveAndScreeningRecordCz](StructureDefinition-LogPreventiveAndScreeningRecordCz.md),[LogCzPulmonologyCz](StructureDefinition-LogPulmonologyCz.md),[LogCzRadiologyCz](StructureDefinition-LogRadiologyCz.md),[LogCzSubjectCz](StructureDefinition-LogSubjectCz.md),[LogCzSzzCz](StructureDefinition-LogSzzCz.md),[LogCzUrologyCz](StructureDefinition-LogUrologyCz.md),[LogEnAngiologyCz](StructureDefinition-AngiologyCz.md),[LogEnBiochemistryLabCz](StructureDefinition-BiochemistryLabCz.md),[LogEnDigitalSignatureCz](StructureDefinition-DigitalSignatureCz.md),[LogEnEmergencyRecordCz](StructureDefinition-EmergencyRecordCz.md),[LogEnGastroenterologyCz](StructureDefinition-GastroenterologyCz.md),[LogEnGeneralPractitionerCz](StructureDefinition-GeneralPractitionerCz.md),[LogEnGynecologyCz](StructureDefinition-GynecologyCz.md),[LogEnHeaderSzzCz](StructureDefinition-HeaderSzzCz.md),[LogEnPreventiveAndScreeningRecordCz](StructureDefinition-PreventiveAndScreeningRecordCz.md),[LogEnPulmonologyCz](StructureDefinition-PulmonologyCz.md),[LogEnRadiologyCz](StructureDefinition-RadiologyCz.md),[LogEnSubjectCz](StructureDefinition-SubjectCz.md),[LogEnSzzCz](StructureDefinition-SzzCz.md),[LogEnUrologyCz](StructureDefinition-UrologyCz.md),[LungCancerInterpretationCS](CodeSystem-cz-lung-cancer-interpretation-cs.md),[LungCancerInterpretationVS](ValueSet-cz-lung-cancer-interpretation-vs.md),[MRIProstateCancerCodeVs](ValueSet-cz-mri-prostate-cancer-code-vs.md),[Patient/142534ac-0274-4a16-b6a2-d4d4f24ff67b](Patient-142534ac-0274-4a16-b6a2-d4d4f24ff67b.md),[Patient/cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec](Patient-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec.md),[Patient/fe858e7c-ba5f-4641-9878-7c6c4790634f](Patient-fe858e7c-ba5f-4641-9878-7c6c4790634f.md),[PhysicalExaminationPulmonologyResultCS](CodeSystem-cz-physical-examination-pulmonology-result-cs.md),[PhysicalExaminationPulmonologyResultVS](ValueSet-cz-physical-examination-pulmonology-result-vs.md),[ProstateCancerResultCS](CodeSystem-cz-Prostate-cancer-result-cs.md),[ProstateCancerResultVS](ValueSet-cz-Prostate-cancer-result-vs.md),[PulmonologyInterpretationCS](CodeSystem-cz-pulmonology-interpretation-cs.md),[PulmonologyInterpretationVS](ValueSet-cz-pulmonology-interpretation-vs.md),[PulmonologyResultCS](CodeSystem-cz-pulmonology-result-cs.md),[PulmonologyResultVS](ValueSet-cz-pulmonology-result-vs.md),[RegionOfProstateVS](ValueSet-cz-region-of-prostate-vs.md),[ResultBiopsyBreastCS](CodeSystem-cz-result-biopsy-breast-cs.md),[ResultBiopsyBreastVS](ValueSet-cz-result-biopsy-breast-vs.md),[ResultBiopsyProstateCS](CodeSystem-cz-result-biopsy-Prostate-cs.md),[ResultBiopsyProstateVS](ValueSet-cz-result-biopsy-Prostate-vs.md),[ResultLungCancerCS](CodeSystem-cz-result-lung-cancer-cs.md),[ResultLungCancerVs](ValueSet-cz-result-lung-cancer-vs.md),[ResultMRIProstateCancerCS](CodeSystem-cz-result-mri-prostate-cancer-cs.md),[ResultMRIProstateCancerVS](ValueSet-cz-result-mri-prostate-cancer-vs.md),[ResultMamographyCS](CodeSystem-cz-result-mammography-cs.md),[ResultMamographyVs](ValueSet-cz-result-mammography-vs.md),[ScreeningRecord2FHIR](ConceptMap-ScreeningRecord2FHIR-cz.md),[TabarDensityCS](CodeSystem-cz-tabar-density-cs.md),[TabarDensityVS](ValueSet-cz-tabar-density-vs.md),[TobaccoHistoryCS](CodeSystem-cz-tobacco-history-cs.md),[TobaccoHistoryVS](ValueSet-cz-tobacco-history-vs.md),[TypeBiopsyBreastCS](CodeSystem-cz-type-biopsy-breast-cs.md),[TypeBiopsyBreastVS](ValueSet-cz-type-biopsy-breast-vs.md),[TypeBiopsyProstateCS](CodeSystem-cz-type-biopsy-cs.md),[TypeBiopsyProstateVS](ValueSet-cz-type-biopsy-prostate-vs.md),[TypeLungCancerObservationCS](CodeSystem-cz-type-lung-cancer-observation-cs.md),[TypeLungCancerObservationVS](ValueSet-cz-type-lung-cancer-observation-vs.md),[TypeOfAdverseEventSzzCS](CodeSystem-cz-type-of-adverse-event-szz-cs.md),[TypeOfAdverseEventSzzVS](ValueSet-cz-type-of-adverse-event-szz-vs.md),[UrologyInterpretationCS](CodeSystem-cz-urology-interpretation-cs.md),[UrologyInterpretationVS](ValueSet-cz-urology-interpretation-vs.md),[UrologyResultCS](CodeSystem-cz-urology-result-cs.md)and[UrologyResultVS](ValueSet-cz-urology-result-vs.md)


* The UCUM codes, UCUM table (regardless of format), and UCUM Specification are copyright 1999-2009, Regenstrief Institute, Inc. and the Unified Codes for Units of Measures (UCUM) Organization. All rights reserved. [https://ucum.org/trac/wiki/TermsOfUse](https://ucum.org/trac/wiki/TermsOfUse)

* [Unified Code for Units of Measure (UCUM)](http://terminology.hl7.org/6.5.0/CodeSystem-v3-ucum.html): [Bundle/cz-example-bundle-screeningrecord](Bundle-cz-example-bundle-screeningrecord.md), [Bundle/cz-example-bundle-screeningrecord-2](Bundle-cz-example-bundle-screeningrecord-2.md)...Show 13 more,[CZ_BodyHeight](StructureDefinition-cz-bodyheight.md),[CZ_BodyWeight](StructureDefinition-cz-bodyweight.md),[CZ_ObservationUnitsHeightVs](ValueSet-cz-observationUnitsHeight-vs.md),[CZ_ObservationUnitsWeightVs](ValueSet-cz-observationUnitsWeight-vs.md),[Observation/02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8](Observation-02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8.md),[Observation/31e1de93-1c46-4f9e-849c-c46f8c7f1496](Observation-31e1de93-1c46-4f9e-849c-c46f8c7f1496.md),[Observation/5031be23-9628-49af-8cac-d23ea87cb8e0](Observation-5031be23-9628-49af-8cac-d23ea87cb8e0.md),[Observation/504f3628-9a5e-4a1a-83b0-418c4b8dc38b](Observation-504f3628-9a5e-4a1a-83b0-418c4b8dc38b.md),[Observation/824055fa-6107-49c8-b217-f029aa7b8872](Observation-824055fa-6107-49c8-b217-f029aa7b8872.md),[Observation/82451f85-ee50-4367-b809-0511ea469269](Observation-82451f85-ee50-4367-b809-0511ea469269.md),[Observation/8a6733be-e107-44b6-99a8-77869faea42a](Observation-8a6733be-e107-44b6-99a8-77869faea42a.md),[Observation/bc143cd8-4638-4823-87d5-6bc16ce68e85](Observation-bc143cd8-4638-4823-87d5-6bc16ce68e85.md)and[Observation/d87b5700-f89c-444b-8360-29c9f7673bf1](Observation-d87b5700-f89c-444b-8360-29c9f7673bf1.md)


* This material contains content from [LOINC](http://loinc.org). LOINC is copyright © 1995-2020, Regenstrief Institute, Inc. and the Logical Observation Identifiers Names and Codes (LOINC) Committee and is available at no cost under the [license](http://loinc.org/license). LOINC® is a registered United States trademark of Regenstrief Institute, Inc.

* [LOINC](http://terminology.hl7.org/6.5.0/CodeSystem-v3-loinc.html): [BloodPressureCodeSzzVs](ValueSet-cz-blood-pressure-code-szz-vs.md), [Bundle/cz-example-bundle-emergencyrecord](Bundle-cz-example-bundle-emergencyrecord.md)...Show 28 more,[Bundle/cz-example-bundle-screeningrecord](Bundle-cz-example-bundle-screeningrecord.md),[Bundle/cz-example-bundle-screeningrecord-2](Bundle-cz-example-bundle-screeningrecord-2.md),[CZ_BodyHeight](StructureDefinition-cz-bodyheight.md),[CZ_BodyWeight](StructureDefinition-cz-bodyweight.md),[CZ_CompositionSzz](StructureDefinition-cz-composition-sharedhealthrecord.md),[CZ_ObservationBloodPressure](StructureDefinition-cz-observation-blood-pressure.md),[CZ_ObservationColorectalCancer](StructureDefinition-cz-observation-colorectal-cancer.md),[CZ_ObservationColposcopyCervicalCancer](StructureDefinition-cz-observation-colposcopy-cervical-cancer.md),[CZ_ObservationCytologyCervicalCancer](StructureDefinition-cz-observation-cytology-cervical-cancer.md),[CZ_ObservationHPVCervicalCancer](StructureDefinition-cz-observation-hpv-cervical-cancer.md),[CZ_ObservationProstateCancer](StructureDefinition-cz-observation-prostate-cancer.md),[CZ_ObservationUrology](StructureDefinition-cz-observation-urology.md),[CZ_WaistCircumference](StructureDefinition-cz-waist-circumference.md),[Composition/91795ef9-ba97-4712-95b4-177f1d784066](Composition-91795ef9-ba97-4712-95b4-177f1d784066.md),[Composition/930ca243-d3aa-4b38-9737-3c2e48000f74](Composition-930ca243-d3aa-4b38-9737-3c2e48000f74.md),[Composition/f711d704-df5c-4599-ac80-e8636e0f9931](Composition-f711d704-df5c-4599-ac80-e8636e0f9931.md),[Observation/02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8](Observation-02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8.md),[Observation/180d74d4-fe14-408c-a3a8-07da4e3b8fcd](Observation-180d74d4-fe14-408c-a3a8-07da4e3b8fcd.md),[Observation/1d79f716-c583-4e42-a68f-bc8c9bb2781d](Observation-1d79f716-c583-4e42-a68f-bc8c9bb2781d.md),[Observation/31e1de93-1c46-4f9e-849c-c46f8c7f1496](Observation-31e1de93-1c46-4f9e-849c-c46f8c7f1496.md),[Observation/40ee0269-0027-4e7b-b061-e039c06cf988](Observation-40ee0269-0027-4e7b-b061-e039c06cf988.md),[Observation/5031be23-9628-49af-8cac-d23ea87cb8e0](Observation-5031be23-9628-49af-8cac-d23ea87cb8e0.md),[Observation/504f3628-9a5e-4a1a-83b0-418c4b8dc38b](Observation-504f3628-9a5e-4a1a-83b0-418c4b8dc38b.md),[Observation/824055fa-6107-49c8-b217-f029aa7b8872](Observation-824055fa-6107-49c8-b217-f029aa7b8872.md),[Observation/82451f85-ee50-4367-b809-0511ea469269](Observation-82451f85-ee50-4367-b809-0511ea469269.md),[Observation/8a6733be-e107-44b6-99a8-77869faea42a](Observation-8a6733be-e107-44b6-99a8-77869faea42a.md),[Observation/bc143cd8-4638-4823-87d5-6bc16ce68e85](Observation-bc143cd8-4638-4823-87d5-6bc16ce68e85.md)and[Observation/d87b5700-f89c-444b-8360-29c9f7673bf1](Observation-d87b5700-f89c-444b-8360-29c9f7673bf1.md)


* This material contains content that is copyright of SNOMED International. Implementers of these specifications must have the appropriate SNOMED CT Affiliate license - for more information contact [https://www.snomed.org/get-snomed](https://www.snomed.org/get-snomed) or [info@snomed.org](mailto:info@snomed.org).

* [SNOMED Clinical Terms&reg; (SNOMED CT&reg;)](http://hl7.org/fhir/R4/codesystem-snomedct.html): [AllergyIntolerance/4b343429-16da-4a5b-be80-17e4122f5956](AllergyIntolerance-4b343429-16da-4a5b-be80-17e4122f5956.md), [AllergyReactionCategorySzzVs](ValueSet-cz-allergy-reaction-category-szz-vs.md)...Show 35 more,[BloodTypeEhdsiVs](ValueSet-cz-blood-type-ehdsi-vs.md),[Bundle/cz-example-bundle-emergencyrecord](Bundle-cz-example-bundle-emergencyrecord.md),[Bundle/cz-example-bundle-screeningrecord](Bundle-cz-example-bundle-screeningrecord.md),[Bundle/cz-example-bundle-screeningrecord-2](Bundle-cz-example-bundle-screeningrecord-2.md),[CZ_AllergyIntoleranceSzz](StructureDefinition-cz-allergyIntolerance-szz.md),[CZ_ObservationAbdominaAorticAneurysms](StructureDefinition-cz-observation-abdomina-aortic-aneurysms.md),[CZ_ObservationBloodType](StructureDefinition-cz-observation-blood-type.md),[CZ_ObservationColonoscopy](StructureDefinition-cz-observation-colonoscopy.md),[CZ_ObservationLungCancer](StructureDefinition-cz-observation-lung-cancer.md),[CZ_ObservationMRIProstateCancer](StructureDefinition-cz-observation-mri-prostate-cancer.md),[CZ_ObservationMammography](StructureDefinition-cz-observation-mammography.md),[CZ_ObservationMammographyBiopsy](StructureDefinition-cz-observation-mammography-biopsy.md),[CZ_ObservationPulmonology](StructureDefinition-cz-observation-pulmonology.md),[CZ_ObservationUrology](StructureDefinition-cz-observation-urology.md),[CZ_ObservationUrologyBiopsy](StructureDefinition-cz-observation-urology-biopsy.md),[ColorectalCancerResultAlternateVS](ValueSet-cz-colorectal-cancer-result-alternate-vs.md),[MRIProstateCancerCodeVs](ValueSet-cz-mri-prostate-cancer-code-vs.md),[Observation/0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08](Observation-0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08.md),[Observation/31e1de93-1c46-4f9e-849c-c46f8c7f1496](Observation-31e1de93-1c46-4f9e-849c-c46f8c7f1496.md),[Observation/407b583e-4c05-47eb-b0df-6d8166c0d4f1](Observation-407b583e-4c05-47eb-b0df-6d8166c0d4f1.md),[Observation/5031be23-9628-49af-8cac-d23ea87cb8e0](Observation-5031be23-9628-49af-8cac-d23ea87cb8e0.md),[Observation/504f3628-9a5e-4a1a-83b0-418c4b8dc38b](Observation-504f3628-9a5e-4a1a-83b0-418c4b8dc38b.md),[Observation/57838f4e-238c-43e4-9088-42971d8171a6](Observation-57838f4e-238c-43e4-9088-42971d8171a6.md),[Observation/5da80cc6-b699-42dc-aeba-86e229063975](Observation-5da80cc6-b699-42dc-aeba-86e229063975.md),[Observation/76879fde-d561-4435-b119-6bb579bea0f5](Observation-76879fde-d561-4435-b119-6bb579bea0f5.md),[Observation/8a6733be-e107-44b6-99a8-77869faea42a](Observation-8a6733be-e107-44b6-99a8-77869faea42a.md),[Observation/bc143cd8-4638-4823-87d5-6bc16ce68e85](Observation-bc143cd8-4638-4823-87d5-6bc16ce68e85.md),[Observation/cd2b65ad-9926-4589-98c9-7e581e21602a](Observation-cd2b65ad-9926-4589-98c9-7e581e21602a.md),[Observation/dd8033d4-d1c9-48e8-8edd-c0dda913678d](Observation-dd8033d4-d1c9-48e8-8edd-c0dda913678d.md),[Observation/f564cd9a-422f-439b-ae17-b2c0a1311ead](Observation-f564cd9a-422f-439b-ae17-b2c0a1311ead.md),[Observation/fa768d55-f16c-457b-8bdc-1d0b1c9e24fa](Observation-fa768d55-f16c-457b-8bdc-1d0b1c9e24fa.md),[PractitionerRole/2a06ef57-f377-4031-a098-612aa44f54b2](PractitionerRole-2a06ef57-f377-4031-a098-612aa44f54b2.md),[PractitionerRole/38e5929e-afe4-40bc-ba9d-c0a80549791e](PractitionerRole-38e5929e-afe4-40bc-ba9d-c0a80549791e.md),[PractitionerRole/428025b5-e328-4542-8812-dd6a874c44f9](PractitionerRole-428025b5-e328-4542-8812-dd6a874c44f9.md)and[RegionOfProstateVS](ValueSet-cz-region-of-prostate-vs.md)


* This material derives from the HL7 Terminology (THO). THO is copyright ©1989+ Health Level Seven International and is made available under the CC0 designation. For more licensing information see: [https://terminology.hl7.org/license.html](https://terminology.hl7.org/license.html)

* [AllergyIntolerance Clinical Status Codes](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-clinical.html): [AllergyIntolerance/4b343429-16da-4a5b-be80-17e4122f5956](AllergyIntolerance-4b343429-16da-4a5b-be80-17e4122f5956.md) and [Bundle/cz-example-bundle-emergencyrecord](Bundle-cz-example-bundle-emergencyrecord.md)
* [AllergyIntolerance Verification Status](http://terminology.hl7.org/7.0.1/CodeSystem-allergyintolerance-verification.html): [AllergyIntolerance/4b343429-16da-4a5b-be80-17e4122f5956](AllergyIntolerance-4b343429-16da-4a5b-be80-17e4122f5956.md) and [Bundle/cz-example-bundle-emergencyrecord](Bundle-cz-example-bundle-emergencyrecord.md)
* [Observation Category Codes](http://terminology.hl7.org/7.0.1/CodeSystem-observation-category.html): [Bundle/cz-example-bundle-screeningrecord](Bundle-cz-example-bundle-screeningrecord.md), [Bundle/cz-example-bundle-screeningrecord-2](Bundle-cz-example-bundle-screeningrecord-2.md)...Show 20 more,[Observation/02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8](Observation-02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8.md),[Observation/0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08](Observation-0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08.md),[Observation/180d74d4-fe14-408c-a3a8-07da4e3b8fcd](Observation-180d74d4-fe14-408c-a3a8-07da4e3b8fcd.md),[Observation/1d79f716-c583-4e42-a68f-bc8c9bb2781d](Observation-1d79f716-c583-4e42-a68f-bc8c9bb2781d.md),[Observation/31e1de93-1c46-4f9e-849c-c46f8c7f1496](Observation-31e1de93-1c46-4f9e-849c-c46f8c7f1496.md),[Observation/407b583e-4c05-47eb-b0df-6d8166c0d4f1](Observation-407b583e-4c05-47eb-b0df-6d8166c0d4f1.md),[Observation/40ee0269-0027-4e7b-b061-e039c06cf988](Observation-40ee0269-0027-4e7b-b061-e039c06cf988.md),[Observation/5031be23-9628-49af-8cac-d23ea87cb8e0](Observation-5031be23-9628-49af-8cac-d23ea87cb8e0.md),[Observation/504f3628-9a5e-4a1a-83b0-418c4b8dc38b](Observation-504f3628-9a5e-4a1a-83b0-418c4b8dc38b.md),[Observation/57838f4e-238c-43e4-9088-42971d8171a6](Observation-57838f4e-238c-43e4-9088-42971d8171a6.md),[Observation/76879fde-d561-4435-b119-6bb579bea0f5](Observation-76879fde-d561-4435-b119-6bb579bea0f5.md),[Observation/824055fa-6107-49c8-b217-f029aa7b8872](Observation-824055fa-6107-49c8-b217-f029aa7b8872.md),[Observation/82451f85-ee50-4367-b809-0511ea469269](Observation-82451f85-ee50-4367-b809-0511ea469269.md),[Observation/8a6733be-e107-44b6-99a8-77869faea42a](Observation-8a6733be-e107-44b6-99a8-77869faea42a.md),[Observation/bc143cd8-4638-4823-87d5-6bc16ce68e85](Observation-bc143cd8-4638-4823-87d5-6bc16ce68e85.md),[Observation/cd2b65ad-9926-4589-98c9-7e581e21602a](Observation-cd2b65ad-9926-4589-98c9-7e581e21602a.md),[Observation/d87b5700-f89c-444b-8360-29c9f7673bf1](Observation-d87b5700-f89c-444b-8360-29c9f7673bf1.md),[Observation/dd8033d4-d1c9-48e8-8edd-c0dda913678d](Observation-dd8033d4-d1c9-48e8-8edd-c0dda913678d.md),[Observation/f564cd9a-422f-439b-ae17-b2c0a1311ead](Observation-f564cd9a-422f-439b-ae17-b2c0a1311ead.md)and[Observation/fa768d55-f16c-457b-8bdc-1d0b1c9e24fa](Observation-fa768d55-f16c-457b-8bdc-1d0b1c9e24fa.md)




## Resource Content

```json
{
  "resourceType" : "ImplementationGuide",
  "id" : "hl7.fhir.cz.szz",
  "url" : "https://hl7.cz/fhir/szz/ImplementationGuide/hl7.fhir.cz.szz",
  "version" : "0.0.1",
  "name" : "HL7CzSZZImplementationGuide",
  "title" : "HL7 Czech Shared Health Record Implementation Guide",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "HL7 Czech Shared Health Record Implementation Guide",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "packageId" : "hl7.fhir.cz.szz",
  "license" : "CC0-1.0",
  "fhirVersion" : ["4.0.1"],
  "dependsOn" : [
    {
      "id" : "hl7tx",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on HL7 Terminology"
        }
      ],
      "uri" : "http://terminology.hl7.org/ImplementationGuide/hl7.terminology",
      "packageId" : "hl7.terminology.r4",
      "version" : "7.0.1"
    },
    {
      "id" : "hl7ext",
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/implementationguide-dependency-comment",
          "valueMarkdown" : "Automatically added as a dependency - all IGs depend on the HL7 Extension Pack"
        }
      ],
      "uri" : "http://hl7.org/fhir/extensions/ImplementationGuide/hl7.fhir.uv.extensions",
      "packageId" : "hl7.fhir.uv.extensions.r4",
      "version" : "5.2.0"
    },
    {
      "id" : "hl7_fhir_uv_ips",
      "uri" : "http://hl7.org/fhir/uv/ips/ImplementationGuide/hl7.fhir.uv.ips",
      "packageId" : "hl7.fhir.uv.ips",
      "version" : "1.1.0"
    },
    {
      "id" : "hl7_fhir_cz_core",
      "uri" : "https://hl7.cz/fhir/core/ImplementationGuide/hl7.fhir.cz.core",
      "packageId" : "hl7.fhir.cz.core",
      "version" : "current"
    },
    {
      "id" : "hl7_fhir_eu_base",
      "uri" : "http://hl7.eu/fhir/base/ImplementationGuide/hl7.fhir.eu.base",
      "packageId" : "hl7.fhir.eu.base",
      "version" : "0.1.0"
    },
    {
      "id" : "hl7_fhir_eu_extensions",
      "uri" : "http://hl7.eu/fhir/extensions/ImplementationGuide/hl7.fhir.eu.extensions",
      "packageId" : "hl7.fhir.eu.extensions",
      "version" : "0.1.1"
    }
  ],
  "definition" : {
    "extension" : [
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-abdomina-aortic-aneurysms-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-abdomina-aortic-aneurysms-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-allergy-intolerance-type-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-allergy-intolerance-type-szz-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-allergy-reaction-category-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-birads-density-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-birads-density-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-colposcopy-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-cervical-cancer-colposcopy-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-cytology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-cervical-cancer-cytology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-hpv-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-cervical-cancer-hpv-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-abnormal-findings-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-abnormal-findings-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-interpretation"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-interpretation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-type-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-type-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colorectal-cancer-result-alternate-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colorectal-cancer-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colorectal-cancer-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-density-type-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-hpv-vaccine-code-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-lung-cancer-interpretation-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-lung-cancer-interpretation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-mri-prostate-cancer-code-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-blood-pressure-code-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-observationUnitsHeight-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-observationUnitsWeight-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-functional-examination-pulmonology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-functional-examination-pulmonology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-physical-examination-pulmonology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-physical-examination-pulmonology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-pulmonology-interpretation-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-pulmonology-interpretation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-pulmonology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-pulmonology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-Prostate-cancer-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-Prostate-cancer-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-clinical-severity-of-symptoms-szz-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-clinical-severity-of-symptoms-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-region-of-prostate-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-biopsy-breast-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-biopsy-breast-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-biopsy-Prostate-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-biopsy-Prostate-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-lung-cancer-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-lung-cancer-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-mammography-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-mammography-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-mri-prostate-cancer-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-mri-prostate-cancer-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-tabar-density-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-tabar-density-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-tobacco-history-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-tobacco-history-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-biopsy-breast-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-biopsy-breast-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-biopsy-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-biopsy-prostate-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-lung-cancer-observation-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-lung-cancer-observation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-of-adverse-event-szz-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-of-adverse-event-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-urology-interpretation-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-urology-interpretation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-urology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-urology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.ehdsi.eu/ValueSet/eHDSIBloodGroup"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/nclp/ValueSet/nclp-blood-group-panel"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/szz/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueString" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-internal-dependency",
        "valueCode" : "hl7.fhir.uv.tools.r4#0.9.0"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "copyrightyear"
          },
          {
            "url" : "value",
            "valueString" : "2025+"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "releaselabel"
          },
          {
            "url" : "value",
            "valueString" : "ci-build"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-abdomina-aortic-aneurysms-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-abdomina-aortic-aneurysms-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-allergy-intolerance-type-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-allergy-intolerance-type-szz-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-allergy-reaction-category-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-birads-density-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-birads-density-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-colposcopy-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-cervical-cancer-colposcopy-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-cytology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-cervical-cancer-cytology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-cervical-cancer-hpv-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-cervical-cancer-hpv-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-abnormal-findings-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-abnormal-findings-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-interpretation"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-interpretation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-type-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colonoscopy-type-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colorectal-cancer-result-alternate-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colorectal-cancer-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-colorectal-cancer-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-density-type-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-hpv-vaccine-code-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-lung-cancer-interpretation-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-lung-cancer-interpretation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-mri-prostate-cancer-code-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-blood-pressure-code-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-observationUnitsHeight-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-observationUnitsWeight-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-functional-examination-pulmonology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-functional-examination-pulmonology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-physical-examination-pulmonology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-physical-examination-pulmonology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-pulmonology-interpretation-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-pulmonology-interpretation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-pulmonology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-pulmonology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-Prostate-cancer-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-Prostate-cancer-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-clinical-severity-of-symptoms-szz-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-clinical-severity-of-symptoms-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-region-of-prostate-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-biopsy-breast-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-biopsy-breast-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-biopsy-Prostate-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-biopsy-Prostate-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-lung-cancer-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-lung-cancer-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-mammography-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-mammography-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-mri-prostate-cancer-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-mri-prostate-cancer-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-tabar-density-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-tabar-density-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-tobacco-history-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-tobacco-history-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-biopsy-breast-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-biopsy-breast-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-biopsy-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-biopsy-prostate-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-lung-cancer-observation-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-lung-cancer-observation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-of-adverse-event-szz-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-of-adverse-event-szz-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-urology-interpretation-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-urology-interpretation-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-urology-result-cs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-urology-result-vs"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "http://terminology.ehdsi.eu/ValueSet/eHDSIBloodGroup"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "special-url"
          },
          {
            "url" : "value",
            "valueString" : "https://ncez.mzcr.cz/nclp/ValueSet/nclp-blood-group-panel"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "pin-canonicals"
          },
          {
            "url" : "value",
            "valueString" : "pin-multiples"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-contact"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-jurisdiction"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-publisher"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-version"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "show-inherited-invariants"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "usage-stats-opt-out"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "autoload-resources"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "template/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-liquid"
          },
          {
            "url" : "value",
            "valueString" : "input/liquid"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-qa"
          },
          {
            "url" : "value",
            "valueString" : "temp/qa"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-temp"
          },
          {
            "url" : "value",
            "valueString" : "temp/pages"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-output"
          },
          {
            "url" : "value",
            "valueString" : "output"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-suppressed-warnings"
          },
          {
            "url" : "value",
            "valueString" : "input/ignoreWarnings.txt"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "path-history"
          },
          {
            "url" : "value",
            "valueString" : "https://hl7.cz/fhir/szz/history.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-html"
          },
          {
            "url" : "value",
            "valueString" : "template-page.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "template-md"
          },
          {
            "url" : "value",
            "valueString" : "template-page-md.html"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-context"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-copyright"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-license"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "apply-wg"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "active-tables"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "fmm-definition"
          },
          {
            "url" : "value",
            "valueString" : "http://hl7.org/fhir/versions.html#maturity"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "propagate-status"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "excludelogbinaryformat"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      },
      {
        "extension" : [
          {
            "url" : "code",
            "valueCode" : "tabbed-snapshots"
          },
          {
            "url" : "value",
            "valueString" : "true"
          }
        ],
        "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-parameter"
      }
    ],
    "grouping" : [
      {
        "id" : "czech-logical-model",
        "name" : "Czech logical model (Informative)",
        "description" : "Logical model in czech language. Informative for this version of the guide."
      }
    ],
    "resource" : [
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogSzzCz"
        },
        "name" : "A - Sdílený zdravotní záznam",
        "description" : "Logický model Sdíleného zdravotního záznamu podle české specifikace.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SzzCz"
        },
        "name" : "A - Shared Health Record",
        "description" : "Logical model of the Shared Health Record according to Czech specifications.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/HeaderSzzCz"
        },
        "name" : "A.1 - Document header",
        "description" : "Header of the shared health record according to Czech specifications.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogHeaderSzzCz"
        },
        "name" : "A.1 - Hlavička dokumentu",
        "description" : "Hlavička sdíleného zdravotního záznamu podle české specifikace.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/SubjectCz"
        },
        "name" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "description" : "Shared Health Record - subject data element",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogSubjectCz"
        },
        "name" : "A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu",
        "description" : "Sdílený zdravotní záznam - Identifikace pacienta a kontaktní informace pacienta",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/DigitalSignatureCz"
        },
        "name" : "A.1.7 - Digital signature",
        "description" : "Shared Health Record - Electronic signature or seal of a document according to Act 327/2011 §54a",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logDigitalSignatureCz"
        },
        "name" : "A.1.7 - Elektronické podpisy",
        "description" : "Sdílený zdravotní záznam - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/EmergencyRecordCz"
        },
        "name" : "A.2 - Emergency health record",
        "description" : "Shared Health Record - Logical model of Emergency Health Record.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogEmergencyRecordCz"
        },
        "name" : "A.2 - Emergentní zdravotní záznam",
        "description" : "Sdílený zdravotní záznam - Logický model pro Emergentní zdravotní záznam.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PreventiveAndScreeningRecordCz"
        },
        "name" : "A.3 - Preventive and screening health record",
        "description" : "Shared Health Record - Logical model of Preventive and screening health record",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPreventiveAndScreeningRecordCz"
        },
        "name" : "A.3 - Preventivní a screeningový zdravotní záznam",
        "description" : "Sdílený zdravotní záznam - Logický model pro Preventivní a screeningový zdravotní záznam",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GeneralPractitionerCz"
        },
        "name" : "A.3.1 - General Practitioner",
        "description" : "Shared Health Record - Preventive and screening examinations by a general practitioner.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logGeneralPractitionerCz"
        },
        "name" : "A.3.1 - Všeobecný praktický lékař",
        "description" : "Sdílený zdravotní záznam - Preventivní a screeningové vyšetření všeobecným praktickým lékařem.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GynecologyCz"
        },
        "name" : "A.3.2 - Gynecology",
        "description" : "Shared Health Record - Preventive and screening examinations by a gynecologist.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logGynecologyCz"
        },
        "name" : "A.3.2 - Gynekologie",
        "description" : "Sdílený zdravotní záznam - Preventivní a screeningové vyšetření Gynekologem.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/logGastroenterologyCz"
        },
        "name" : "A.3.3 - Gastroenterologie",
        "description" : "Sdílený zdravotní záznam - Screeningové vyšedtření gastroenterologem.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/GastroenterologyCz"
        },
        "name" : "A.3.3 - Gastroenterology",
        "description" : "Shared Health Record - Screening examination by gastroenterologist.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogRadiologyCz"
        },
        "name" : "A.3.4 - Radiologie",
        "description" : "Sdílený zdravotní záznam - Screeningové vyšetření radiologem.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/RadiologyCz"
        },
        "name" : "A.3.4 - Radiology",
        "description" : "Shared Health Record - Screening examination by radiologist.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogBiochemistryLabCz"
        },
        "name" : "A.3.5 - Biochemická laboratoř",
        "description" : "Sdílený zdravotní záznam - Screeningy provedené Biochemickou laboratoří.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/BiochemistryLabCz"
        },
        "name" : "A.3.5 - Biochemistry Lab",
        "description" : "Shared Health Record - Screenings performed by the Biochemical Laboratory.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogPulmonologyCz"
        },
        "name" : "A.3.6 - Pulmonology",
        "description" : "Sdílený zdravotní záznam - Screeningové vyšetření pneumologem.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/PulmonologyCz"
        },
        "name" : "A.3.6 - Pulmonology",
        "description" : "Shared Health Record - Screening examination by pulmonologist",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogUrologyCz"
        },
        "name" : "A.3.7 - Urolog",
        "description" : "Sdílený zdravotní záznam - Screeningové vyšetření urologem.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/UrologyCz"
        },
        "name" : "A.3.7 - Urology",
        "description" : "Shared Health Record - Screening examination by urologist.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/LogAngiologyCz"
        },
        "name" : "A.3.8 - Angiology",
        "description" : "Sdílený zdravotní záznam - Screeningové vyšetření angiologem.",
        "exampleBoolean" : false,
        "groupingId" : "czech-logical-model"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:logical"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/AngiologyCz"
        },
        "name" : "A.3.8 - Angiology",
        "description" : "Shared Health Record - Screening examination by angiologist",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-abdomina-aortic-aneurysms-result-cs"
        },
        "name" : "Abdomina Aortic Aneurysms Result Code System",
        "description" : "Abdomina Aortic Aneurysms result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-abdomina-aortic-aneurysms-result-vs"
        },
        "name" : "Abdomina Aortic Aneurysms Result Value set",
        "description" : "Abdomina Aortic Aneurysms result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-adverse-event"
        },
        "name" : "Adverse event (SZZ CZ)",
        "description" : "Czech profile for adverse event.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AdverseEvent"
          }
        ],
        "reference" : {
          "reference" : "AdverseEvent/74d87d39-d681-4df4-80a5-975b359e6210"
        },
        "name" : "AdverseEvent: Rash due to Penicillin (CZ)",
        "description" : "Example of AdverseEvent resource representing rash due to Penicillin.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-adverse-event"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-allergyIntolerance-szz"
        },
        "name" : "Allergy intolerance (SZZ CZ)",
        "description" : "Czech profile for allergy intolerance.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-allergy-reaction-category-szz-vs"
        },
        "name" : "Allergy reaction category",
        "description" : "The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction category.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-allergy-intolerance-type-szz-cs"
        },
        "name" : "Allergy reaction type (CZ supplement)",
        "description" : "The Code System is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-allergy-intolerance-type-szz-vs"
        },
        "name" : "Allergy reaction type (CZ)",
        "description" : "The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction type.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "AllergyIntolerance"
          }
        ],
        "reference" : {
          "reference" : "AllergyIntolerance/4b343429-16da-4a5b-be80-17e4122f5956"
        },
        "name" : "AllergyIntolerance: Penicillin Allergy (CZ)",
        "description" : "Example of AllergyIntolerance resource representing allergy to Penicillin.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-allergyIntolerance-szz"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-result-biopsy-breast-cs"
        },
        "name" : "Biopsy Breast Result Code System",
        "description" : "Biopsy Breast result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-result-biopsy-breast-vs"
        },
        "name" : "Biopsy Breast Result Valueset",
        "description" : "Biopsy Breast Result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-result-biopsy-Prostate-cs"
        },
        "name" : "Biopsy Prostate Result Code System",
        "description" : "Biopsy Prostate result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-result-biopsy-Prostate-vs"
        },
        "name" : "Biopsy Prostate Result Valueset",
        "description" : "Biopsy Prostate Result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-type-biopsy-prostate-vs"
        },
        "name" : "Biopsy Type Prostate Valueset",
        "description" : "Biopsy type prostate value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-birads-density-cs"
        },
        "name" : "Birads Density Result Code System",
        "description" : "Birads density result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-birads-density-vs"
        },
        "name" : "Birads Density Result Value set",
        "description" : "Birads density result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bundle-sharedhealthrecord"
        },
        "name" : "Bundle (SZZ CZ)",
        "description" : "Clinical document used to represent a Shared Health Record for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/cz-example-bundle-emergencyrecord"
        },
        "name" : "Bundle: Emergency Report (CZ)",
        "description" : "Example of Shared Health Record Bundle containing Emergency Report.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bundle-sharedhealthrecord"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/cz-example-bundle-screeningrecord-2"
        },
        "name" : "Bundle: Female Preventive and screening Report (CZ)",
        "description" : "Example of Shared Health Record Bundle containing Screening Report for female patient.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bundle-sharedhealthrecord"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Bundle"
          }
        ],
        "reference" : {
          "reference" : "Bundle/cz-example-bundle-screeningrecord"
        },
        "name" : "Bundle: Male Preventive and screening Report (CZ)",
        "description" : "Example of Shared Health Record Bundle containing Screening Report for male patient.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bundle-sharedhealthrecord"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-cervical-cancer-colposcopy-result-cs"
        },
        "name" : "Cervical Cancer Screening Colposcopy Result Code System",
        "description" : "Cervical cancer screening colposcopy result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-cervical-cancer-colposcopy-result-vs"
        },
        "name" : "Cervical Cancer Screening Colposcopy Result Value Set",
        "description" : "Cervical cancer screening colposcopy result value set includes selected codes from Cervical Cancer Screening Colscopy Result Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-cervical-cancer-cytology-result-cs"
        },
        "name" : "Cervical Cancer Screening Cytology Result Code System",
        "description" : "Cervical cancer screening cytology result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-cervical-cancer-cytology-result-vs"
        },
        "name" : "Cervical Cancer Screening Cytology Result Value Set",
        "description" : "Cervical cancer screening cytology result value set includes selected codes from Colorectal Cancer Screening Result Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-cervical-cancer-hpv-result-cs"
        },
        "name" : "Cervical Cancer Screening HPV Result Code System",
        "description" : "Cervical cancer screening HPV result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-cervical-cancer-hpv-result-vs"
        },
        "name" : "Cervical Cancer Screening HPV Result Value Set",
        "description" : "Cervical cancer screening HPV result value set includes selected codes from Colorectal Cancer Screening Result Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-clinical-severity-of-symptoms-szz-cs"
        },
        "name" : "Clinical severity of symptoms",
        "description" : "The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Clinical severity of symptoms.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-clinical-severity-of-symptoms-szz-vs"
        },
        "name" : "Clinical severity of symptoms (CZ)",
        "description" : "The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Clinical severity of symptoms.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-colorectal-cancer-result-alternate-vs"
        },
        "name" : "Colorectal Cancer Screening Result Alternate Value Set",
        "description" : "Alternate Colorectal cancer screening result value set includes selected codes from Colorectal Cancer Screening Result Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-colorectal-cancer-result-cs"
        },
        "name" : "Colorectal Cancer Screening Result Code System",
        "description" : "Colorectal cancer screening result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-colorectal-cancer-result-vs"
        },
        "name" : "Colorectal Cancer Screening Result Value Set",
        "description" : "Colorectal cancer screening result value set includes selected codes from Colorectal Cancer Screening Result Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-composition-sharedhealthrecord"
        },
        "name" : "Composition (SZZ CZ)",
        "description" : "This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/f711d704-df5c-4599-ac80-e8636e0f9931"
        },
        "name" : "Composition: Emergency Report (CZ)",
        "description" : "Composition example for Shared Health Record containing Emergency Report.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/91795ef9-ba97-4712-95b4-177f1d784066"
        },
        "name" : "Composition: Screening Report (CZ)",
        "description" : "Composition example for Shared Health Record containing Screening Report.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Composition"
          }
        ],
        "reference" : {
          "reference" : "Composition/930ca243-d3aa-4b38-9737-3c2e48000f74"
        },
        "name" : "Composition: Screening Report 2 (CZ)",
        "description" : "Composition example for Shared Health Record containing Screening Report.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-colonoscopy-abnormal-findings-cs"
        },
        "name" : "CZ Colonoscopy Abnormal Findings Code System",
        "description" : "This code system defines the codes for abnormal findings observed during a colonoscopy procedure in the context of the Shared Health Record (SZZ CZ).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-colonoscopy-abnormal-findings-vs"
        },
        "name" : "CZ Colonoscopy Abnormal Findings Value Set",
        "description" : "This value set includes selected codes from the CZ Colonoscopy Abnormal Findings Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-colonoscopy-interpretation"
        },
        "name" : "CZ Colonoscopy Interpretation Code System",
        "description" : "This code system defines the codes for interpreting colonoscopy findings in the context of the Shared Health Record (SZZ CZ).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-colonoscopy-interpretation-vs"
        },
        "name" : "CZ Colonoscopy Interpretation Value Set",
        "description" : "This value set includes selected codes from the CZ Colonoscopy Interpretation Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-colonoscopy-type-cs"
        },
        "name" : "CZ Colonoscopy Type Code System",
        "description" : "This code system defines the codes for colonoscopy types in the context of the Shared Health Record (SZZ CZ).",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-colonoscopy-type-vs"
        },
        "name" : "CZ Colonoscopy Type Valueset",
        "description" : "This valueset includes selected codes from the CZ Colonoscopy Type Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-document-section-szz-cs"
        },
        "name" : "CZ Document Section SZZ Code System",
        "description" : "This Code System defines codes for sections used in the Shared Health Record (SZZ) in Czechia.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/EmergencyRecord2FHIR-cz"
        },
        "name" : "CZ Emergency record Model to this guide Map",
        "description" : "CZ Shared Health Record Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/Header2FHIR-cz"
        },
        "name" : "CZ Header Model to this guide Map",
        "description" : "CZ Shared Health Record Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-hpv-vaccine-code-vs"
        },
        "name" : "CZ HPV Vaccine Code Value Set",
        "description" : "This value set includes codes for HPV vaccines used in the Czech Republic.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ConceptMap"
          }
        ],
        "reference" : {
          "reference" : "ConceptMap/ScreeningRecord2FHIR-cz"
        },
        "name" : "CZ Screening record Model to this guide Map",
        "description" : "CZ Shared Health Record Model to this guide mapping",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-density-type-cs"
        },
        "name" : "CZ Type of breast density Code System",
        "description" : "This Code System defines codes for type breast density in Czechia.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/76879fde-d561-4435-b119-6bb579bea0f5"
        },
        "name" : "cz-example-observation-mri-prostate-cancer",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mri-prostate-cancer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/f84d821c-ba13-412b-a340-2547a6f36b7f"
        },
        "name" : "cz-example-organization",
        "description" : "An example of the organization with logo extension",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/2ef3f712-d586-4b3e-92eb-6a5bddc58a68"
        },
        "name" : "cz-example-organization2",
        "description" : "An example of the organization with logo extension",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Organization"
          }
        ],
        "reference" : {
          "reference" : "Organization/08f3f0c5-69ac-45c6-9bec-b8ab940ec721"
        },
        "name" : "cz-example-organization3",
        "description" : "An example of the organization with logo extension",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/040eb849-a513-4d74-b3f3-d2f246a26877"
        },
        "name" : "cz-logo-example",
        "description" : "Example of logo as document reference for FN Obláčkov.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/7248f0f4-a508-4668-acd8-9782ab4e0f98"
        },
        "name" : "cz-logo-example2",
        "description" : "Example of logo as document reference for FN Obláčkov.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "DocumentReference"
          }
        ],
        "reference" : {
          "reference" : "DocumentReference/2620c461-29d4-44a7-a8d0-599d88fdb60f"
        },
        "name" : "cz-logo-example3",
        "description" : "Example of logo as document reference for FN Obláčkov.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-blood-type-ehdsi-vs"
        },
        "name" : "EHDSI blood type codes",
        "description" : "The Value Set is used for Blood Type representation in the Shared Health Record according to EHDSI specifications.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-functional-examination-pulmonology-result-cs"
        },
        "name" : "Functional Examination Pulmonology Result Code System",
        "description" : "Functional Examination Pulmonology Result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-functional-examination-pulmonology-result-vs"
        },
        "name" : "Functional Examination Pulmonology Result Value Set",
        "description" : "Functional Examination Pulmonology Result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-immunization-hpv"
        },
        "name" : "Immunization against HPV Resource Profile (SZZ CZ)",
        "description" : "This profile defines how to represent Immunization against HPV resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-blood-type-laboratory-code-szz-vs"
        },
        "name" : "Laboratory methods for blood type determination",
        "description" : "The Value Set is used for Laboratory methods for blood type determination in the Shared Health Record.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-lung-cancer-interpretation-cs"
        },
        "name" : "Lung Cancer interpretation Code System",
        "description" : "Lung Cancer interpretation code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-lung-cancer-interpretation-vs"
        },
        "name" : "Lung Cancer interpretation Value set",
        "description" : "Lung Cancer interpretation value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-result-lung-cancer-cs"
        },
        "name" : "Lung Cancer Result Code System",
        "description" : "Lung cancer result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-result-lung-cancer-vs"
        },
        "name" : "Lung Cancer Result Value Set",
        "description" : "Lung cancer result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-result-mammography-cs"
        },
        "name" : "Mammography Result Code System",
        "description" : "Mammography result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-result-mammography-vs"
        },
        "name" : "Mammography Result Value Set",
        "description" : "Mammography result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Medication"
          }
        ],
        "reference" : {
          "reference" : "Medication/d6511f3f-a311-4050-a34a-542f1ffe40bd"
        },
        "name" : "Medication: Fludeoxythymidin (CZ)",
        "description" : "Example of Medication resource representing Fludeoxythymidin medication.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "MedicationStatement"
          }
        ],
        "reference" : {
          "reference" : "MedicationStatement/ce0f692f-0461-4ed0-8df3-f8db265f755c"
        },
        "name" : "MedicationStatement: Fludeoxythymidin (CZ)",
        "description" : "Example of MedicationStatement resource representing Fludeoxythymidin medication.",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-mri-prostate-cancer-code-vs"
        },
        "name" : "Method of MRI for prostate cancer determination",
        "description" : "The Value Set is used for screening methods for prostate cancer determination in the Shared Health Record.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-blood-pressure-code-szz-vs"
        },
        "name" : "Methods for blood pressure determination",
        "description" : "The Value Set is used for methods for blood pressure determination in the Shared Health Record.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-result-mri-prostate-cancer-cs"
        },
        "name" : "MRI Prostate Cancer Result Code System",
        "description" : "MRI Prostate Cancer result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-result-mri-prostate-cancer-vs"
        },
        "name" : "MRI Prostate Cancer Result Valueset",
        "description" : "MRI Prostate Cancer Result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/5da80cc6-b699-42dc-aeba-86e229063975"
        },
        "name" : "Observation Blood Type for Patient Králík",
        "description" : "Blood type observation for Patient Králík in SZZ",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-blood-type"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-abdomina-aortic-aneurysms"
        },
        "name" : "Observation: Abdomina aortic aneurysms (SZZ CZ)",
        "description" : "This profile defines how to represent Abodmina Aortic Aneurysms Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/dd8033d4-d1c9-48e8-8edd-c0dda913678d"
        },
        "name" : "Observation: Abdomina Aortic Aneurysms Example (CZ)",
        "description" : "Example of Abdomina Aortic Aneurysms for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-abdomina-aortic-aneurysms"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-blood-pressure"
        },
        "name" : "Observation: Blood Pressure (SZZ CZ)",
        "description" : "This profile defines how to represent Blood Pressure Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/d87b5700-f89c-444b-8360-29c9f7673bf1"
        },
        "name" : "Observation: Blood Pressure Example (CZ)",
        "description" : "Example of Blood Pressure Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-blood-pressure"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-blood-type"
        },
        "name" : "Observation: Blood Type (SZZ CZ)",
        "description" : "This profile defines how to represent Blood Type Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/5031be23-9628-49af-8cac-d23ea87cb8e0"
        },
        "name" : "Observation: Body Height Example (CZ)",
        "description" : "Example of Body Height Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyheight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/504f3628-9a5e-4a1a-83b0-418c4b8dc38b"
        },
        "name" : "Observation: Body Height Example (CZ)",
        "description" : "Example of Body Height Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyheight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/8a6733be-e107-44b6-99a8-77869faea42a"
        },
        "name" : "Observation: Body Weight Example (CZ)",
        "description" : "Example of Body Weight Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyweight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/31e1de93-1c46-4f9e-849c-c46f8c7f1496"
        },
        "name" : "Observation: Body Weight Example (CZ)",
        "description" : "Example of Body Weight Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyweight"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-colposcopy-cervical-cancer"
        },
        "name" : "Observation: Cervical Cancer Colposcopy Screening (SZZ CZ)",
        "description" : "This profile defines how to represent Cervical Cancer Colposcopy Screening Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-cytology-cervical-cancer"
        },
        "name" : "Observation: Cervical Cancer Cytology Screening (SZZ CZ)",
        "description" : "This profile defines how to represent Cervical Cancer Cytology Screening Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-hpv-cervical-cancer"
        },
        "name" : "Observation: Cervical Cancer HPV Screening (SZZ CZ)",
        "description" : "This profile defines how to represent Cervical Cancer HPV Screening Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-colonoscopy"
        },
        "name" : "Observation: Colonoscopy (SZZ CZ)",
        "description" : "This profile defines how to represent Colonoscopy Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/cd2b65ad-9926-4589-98c9-7e581e21602a"
        },
        "name" : "Observation: Colonoscopy Example (CZ)",
        "description" : "Example of Colonoscopy Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colonoscopy"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-colorectal-cancer"
        },
        "name" : "Observation: Colorectal Cancer Screening (SZZ CZ)",
        "description" : "This profile defines how to represent Colorectal Cancer Screening Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8"
        },
        "name" : "Observation: Colorectal Cancer Screening Example (CZ)",
        "description" : "Example of Colorectal Cancer Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colorectal-cancer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/180d74d4-fe14-408c-a3a8-07da4e3b8fcd"
        },
        "name" : "Observation: Colposcopy cervical cancer",
        "description" : "Example of Colposcopy cervical cancer for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colposcopy-cervical-cancer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/40ee0269-0027-4e7b-b061-e039c06cf988"
        },
        "name" : "Observation: Cytology cervical cancer",
        "description" : "Example of Cytology cervical cancer for Shared Health Record",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-cytology-cervical-cancer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bodyheight"
        },
        "name" : "Observation: Height (SZZ CZ)",
        "description" : "Profile of body height for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/1d79f716-c583-4e42-a68f-bc8c9bb2781d"
        },
        "name" : "Observation: HPV cervical cancer",
        "description" : "Example of HPV cervical cancer for Shared Health Record",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-hpv-cervical-cancer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Immunization"
          }
        ],
        "reference" : {
          "reference" : "Immunization/dd06896e-959b-44ec-b791-19a68ffdc576"
        },
        "name" : "Observation: Immunization HPV Example (CZ)",
        "description" : "Example of Immunization HPV for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-immunization-hpv"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/f564cd9a-422f-439b-ae17-b2c0a1311ead"
        },
        "name" : "Observation: Lung cancer",
        "description" : "Example of Lung cancer for Shared Health Record",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-lung-cancer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-lung-cancer"
        },
        "name" : "Observation: Lung cancer (SZZ CZ)",
        "description" : "This profile defines how to represent Lung cancer Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08"
        },
        "name" : "Observation: Mammography",
        "description" : "Example of Mammography for Shared Health Record",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mammography"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-mammography"
        },
        "name" : "Observation: Mammography (SZZ CZ)",
        "description" : "This profile defines how to represent Mammography Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/fa768d55-f16c-457b-8bdc-1d0b1c9e24fa"
        },
        "name" : "Observation: Mammography biopsy",
        "description" : "Example of Mammography biopsy for Shared Health Record",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mammography-biopsy"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-mammography-biopsy"
        },
        "name" : "Observation: Mammography Biopsy(SZZ CZ)",
        "description" : "This profile defines how to represent Mammography Biopsy Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-mri-prostate-cancer"
        },
        "name" : "Observation: MRI Prostate Cancer (SZZ CZ)",
        "description" : "This profile defines how to represent MRI prostate cancer Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-prostate-cancer"
        },
        "name" : "Observation: Prostate Cancer Screening (SZZ CZ)",
        "description" : "This profile defines how to represent Prostate Cancer Screening Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/824055fa-6107-49c8-b217-f029aa7b8872"
        },
        "name" : "Observation: Prostate Cancer Screening Example (CZ)",
        "description" : "Example of Prostate Cancer Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-prostate-cancer"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/407b583e-4c05-47eb-b0df-6d8166c0d4f1"
        },
        "name" : "Observation: Pulmonology",
        "description" : "Example of Pulmonology for Shared Health Record",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-pulmonology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-pulmonology"
        },
        "name" : "Observation: Pulmonology (SZZ CZ)",
        "description" : "This profile defines how to represent Pulmonology Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-urology"
        },
        "name" : "Observation: Urology (SZZ CZ)",
        "description" : "This profile defines how to represent Urology Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/57838f4e-238c-43e4-9088-42971d8171a6"
        },
        "name" : "Observation: Urology biopsy (CZ)",
        "description" : "Urology biopsy example for Shared Health Record containing Screening Report.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology-biopsy"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-observation-urology-biopsy"
        },
        "name" : "Observation: Urology Biopsy(SZZ CZ)",
        "description" : "This profile defines how to represent Urology Biopsy Observation resource in HL7 FHIR for the scope of this guide.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/bc143cd8-4638-4823-87d5-6bc16ce68e85"
        },
        "name" : "Observation: Urology examination (CZ)",
        "description" : "Urology examination example for Shared Health Record containing Screening Report.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-waist-circumference"
        },
        "name" : "Observation: Waist circumference  (SZZ CZ)",
        "description" : "Profile of waist circumference for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Observation"
          }
        ],
        "reference" : {
          "reference" : "Observation/82451f85-ee50-4367-b809-0511ea469269"
        },
        "name" : "Observation: Waist circumference Example (CZ)",
        "description" : "Example of Waist circumference Observation for Shared Health Record.",
        "exampleCanonical" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-waist-circumference"
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "StructureDefinition:resource"
          }
        ],
        "reference" : {
          "reference" : "StructureDefinition/cz-bodyweight"
        },
        "name" : "Observation: Weight (SZZ CZ)",
        "description" : "Profile of body weight for the scope of the Czech national interoperability project.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationUnitsHeight-vs"
        },
        "name" : "ObservationsUnitHeight",
        "description" : "UCUM units for height",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-observationUnitsWeight-vs"
        },
        "name" : "ObservationsUnitWeight",
        "description" : "UCUM units for weight",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/142534ac-0274-4a16-b6a2-d4d4f24ff67b"
        },
        "name" : "Patient Králík",
        "description" : "Patient in SZZ",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/fe858e7c-ba5f-4641-9878-7c6c4790634f"
        },
        "name" : "Patient Králík",
        "description" : "Male patient in SZZ",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Patient"
          }
        ],
        "reference" : {
          "reference" : "Patient/cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec"
        },
        "name" : "Patient Mrakomorová",
        "description" : "Female patient in SZZ",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-physical-examination-pulmonology-result-cs"
        },
        "name" : "Physical Examination Pulmonology Result Code System",
        "description" : "Physical Examination Pulmonology Result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-physical-examination-pulmonology-result-vs"
        },
        "name" : "Physical Examination Pulmonology Result Value Set",
        "description" : "Physical Examination Pulmonology Result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/c3830e95-5f0a-46e8-a9e4-403f299ab2c5"
        },
        "name" : "Practitioner Testovací",
        "description" : "Author of SZZ report",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/e031c581-1616-4f9c-a0fe-3d7b5094bf1a"
        },
        "name" : "Practitioner Testovací",
        "description" : "Author of SZZ report",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "Practitioner"
          }
        ],
        "reference" : {
          "reference" : "Practitioner/575c3fb2-e037-4415-95da-283679927aba"
        },
        "name" : "Practitioner Testovací",
        "description" : "Author of SZZ report",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/428025b5-e328-4542-8812-dd6a874c44f9"
        },
        "name" : "PractitionerRole Testovací",
        "description" : "Author of SZZ report",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/38e5929e-afe4-40bc-ba9d-c0a80549791e"
        },
        "name" : "PractitionerRole Testovací",
        "description" : "Author of SZZ report",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "PractitionerRole"
          }
        ],
        "reference" : {
          "reference" : "PractitionerRole/2a06ef57-f377-4031-a098-612aa44f54b2"
        },
        "name" : "PractitionerRole Testovací",
        "description" : "Author of SZZ report",
        "exampleBoolean" : true
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-Prostate-cancer-result-cs"
        },
        "name" : "Prostate Cancer Screening Result Code System",
        "description" : "Prostate cancer screening result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-Prostate-cancer-result-vs"
        },
        "name" : "Prostate Cancer Screening Result Value Set",
        "description" : "Prostate cancer screening result value set includes selected codes from Prostate Cancer Screening Result Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-pulmonology-interpretation-cs"
        },
        "name" : "Pulmonology interpretation Code System",
        "description" : "Pulmonology interpretation code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-pulmonology-interpretation-vs"
        },
        "name" : "Pulmonology interpretation Value set",
        "description" : "Pulmonology interpretation value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-pulmonology-result-cs"
        },
        "name" : "Pulmonology Result Code System",
        "description" : "Pulmonology Result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-pulmonology-result-vs"
        },
        "name" : "Pulmonology Result Value set",
        "description" : "Pulmonology Result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-region-of-prostate-vs"
        },
        "name" : "Region of prostate for MRI for prostate cancer determination",
        "description" : "The Value Set is used for region of prostate for cancer determination in the Shared Health Record.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-tabar-density-cs"
        },
        "name" : "Tabar Density Result Code System",
        "description" : "Tabar density result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-tabar-density-vs"
        },
        "name" : "Tabar Density Result Value set",
        "description" : "Tabar density result value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-tobacco-history-cs"
        },
        "name" : "Tobacco History Code System",
        "description" : "Tobacco history code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-tobacco-history-vs"
        },
        "name" : "Tobacco History Valueset",
        "description" : "Tobacco History value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-type-of-adverse-event-szz-cs"
        },
        "name" : "Type of adverse event Code System",
        "description" : "Type of adverse event code system according to act $34a para 2 of Act No. 325/2021 Coll., on health services, as amended.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-type-of-adverse-event-szz-vs"
        },
        "name" : "Type of adverse event Value Set",
        "description" : "Type of adverse event value set includes selected codes from Type of adverse event Code System.",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-type-biopsy-breast-cs"
        },
        "name" : "Type of Breast Biopsy Code System",
        "description" : "Type of Breast Biopsy code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-type-biopsy-breast-vs"
        },
        "name" : "Type of Breast Biopsy Valueset",
        "description" : "Type of Breast Biopsy value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-type-lung-cancer-observation-cs"
        },
        "name" : "Type of lung cancer observation Code System",
        "description" : "Type of lung cancer observation code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-type-lung-cancer-observation-vs"
        },
        "name" : "Type of lung cancer observation Valueset",
        "description" : "Type of lung cancer observation value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-type-biopsy-cs"
        },
        "name" : "Type of Prostate Biopsy Code System",
        "description" : "Type of Prostate Biopsy code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-urology-interpretation-cs"
        },
        "name" : "Urology interpretation Code System",
        "description" : "Urology interpretation code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-urology-interpretation-vs"
        },
        "name" : "Urology interpretation Value set",
        "description" : "Urology interpretation value set",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "CodeSystem"
          }
        ],
        "reference" : {
          "reference" : "CodeSystem/cz-urology-result-cs"
        },
        "name" : "Urology Result Code System",
        "description" : "Urology result code system",
        "exampleBoolean" : false
      },
      {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/tools/StructureDefinition/resource-information",
            "valueString" : "ValueSet"
          }
        ],
        "reference" : {
          "reference" : "ValueSet/cz-urology-result-vs"
        },
        "name" : "Urology Result Value Set",
        "description" : "Urology result value set",
        "exampleBoolean" : false
      }
    ],
    "page" : {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
          "valueUrl" : "toc.html"
        }
      ],
      "nameUrl" : "toc.html",
      "title" : "Table of Contents",
      "generation" : "html",
      "page" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index.html"
            }
          ],
          "nameUrl" : "index.html",
          "title" : "Home",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "index-cs.html"
            }
          ],
          "nameUrl" : "index-cs.html",
          "title" : "Domovská stránka",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content.html"
            }
          ],
          "nameUrl" : "scope-and-content.html",
          "title" : "Scope and content",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scope-and-content-cs.html"
            }
          ],
          "nameUrl" : "scope-and-content-cs.html",
          "title" : "Rozsah použití a obsah",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background.html"
            }
          ],
          "nameUrl" : "background.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "background-cs.html"
            }
          ],
          "nameUrl" : "background-cs.html",
          "title" : "Background",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases.html"
            }
          ],
          "nameUrl" : "use-cases.html",
          "title" : "Use cases",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "use-cases-cs.html"
            }
          ],
          "nameUrl" : "use-cases-cs.html",
          "title" : "Případy užití",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "workflow.html"
            }
          ],
          "nameUrl" : "workflow.html",
          "title" : "Workflow",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "workflow-cs.html"
            }
          ],
          "nameUrl" : "workflow-cs.html",
          "title" : "Workflow",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples.html"
            }
          ],
          "nameUrl" : "examples.html",
          "title" : "Examples",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "examples-cs.html"
            }
          ],
          "nameUrl" : "examples-cs.html",
          "title" : "Příklady",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models.html"
            }
          ],
          "nameUrl" : "logical-models.html",
          "title" : "Logical models",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "logical-models-cs.html"
            }
          ],
          "nameUrl" : "logical-models-cs.html",
          "title" : "Datová sada - logické modely",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "model-map.html"
            }
          ],
          "nameUrl" : "model-map.html",
          "title" : "Model maps",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "model-map-cs.html"
            }
          ],
          "nameUrl" : "model-map-cs.html",
          "title" : "Mapování logického modelu",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "artifacts.html"
            }
          ],
          "nameUrl" : "artifacts.html",
          "title" : "Artifacts",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors.html"
            }
          ],
          "nameUrl" : "authors.html",
          "title" : "Authors",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "authors-cs.html"
            }
          ],
          "nameUrl" : "authors-cs.html",
          "title" : "Autoři",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright.html"
            }
          ],
          "nameUrl" : "copyright.html",
          "title" : "Copyright",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "copyright-cs.html"
            }
          ],
          "nameUrl" : "copyright-cs.html",
          "title" : "Autorská práva",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies.html"
            }
          ],
          "nameUrl" : "dependencies.html",
          "title" : "Dependencies",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "dependencies-cs.html"
            }
          ],
          "nameUrl" : "dependencies-cs.html",
          "title" : "Závislosti",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads.html"
            }
          ],
          "nameUrl" : "downloads.html",
          "title" : "Download",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "downloads-cs.html"
            }
          ],
          "nameUrl" : "downloads-cs.html",
          "title" : "Download",
          "generation" : "markdown"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Header-map.html"
            }
          ],
          "nameUrl" : "Header-map.html",
          "title" : "Header Model map",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "Header-map-cs.html"
            }
          ],
          "nameUrl" : "Header-map-cs.html",
          "title" : "Mapování logického modelu hlavičky",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "ezz-map.html"
            }
          ],
          "nameUrl" : "ezz-map.html",
          "title" : "Emergency Health Record Model map",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "ezz-map-cs.html"
            }
          ],
          "nameUrl" : "ezz-map-cs.html",
          "title" : "Mapování logického modelu emergentního zdravotního záznamu",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scr-map.html"
            }
          ],
          "nameUrl" : "scr-map.html",
          "title" : "Preventive and screening health record Model map",
          "generation" : "html"
        },
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/ig-page-name",
              "valueUrl" : "scr-map-cs.html"
            }
          ],
          "nameUrl" : "scr-map-cs.html",
          "title" : "Mapování logického modelu Preventivních a screeningových zdravotních záznamů",
          "generation" : "html"
        }
      ]
    },
    "parameter" : [
      {
        "code" : "path-resource",
        "value" : "input/capabilities"
      },
      {
        "code" : "path-resource",
        "value" : "input/examples"
      },
      {
        "code" : "path-resource",
        "value" : "input/extensions"
      },
      {
        "code" : "path-resource",
        "value" : "input/models"
      },
      {
        "code" : "path-resource",
        "value" : "input/operations"
      },
      {
        "code" : "path-resource",
        "value" : "input/profiles"
      },
      {
        "code" : "path-resource",
        "value" : "input/resources"
      },
      {
        "code" : "path-resource",
        "value" : "input/vocabulary"
      },
      {
        "code" : "path-resource",
        "value" : "input/maps"
      },
      {
        "code" : "path-resource",
        "value" : "input/testing"
      },
      {
        "code" : "path-resource",
        "value" : "input/history"
      },
      {
        "code" : "path-resource",
        "value" : "fsh-generated/resources"
      },
      {
        "code" : "path-pages",
        "value" : "template/config"
      },
      {
        "code" : "path-pages",
        "value" : "input/images"
      },
      {
        "code" : "path-tx-cache",
        "value" : "input-cache/txcache"
      }
    ]
  }
}

```
