# Background - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Background**

## Background

#### Data Responsibilities and Obligation of Data Deletion ⚖️

**The Shared Health Record (SZZ)** is a defined part of e-Health that includes the emergency health record and the results of preventive and screening examinations.

**Recording Person (Provider):** The law clearly defines who has the obligation to record data into the emergency record. For data such as blood group, allergies, adverse drug effects, etc., the recording person is every Healthcare Provider (PZS) who ascertains such data. Thus, every physician or facility that detects, for example, an allergy or a serious reaction relevant to the emergency record in a patient must add this information to the shared record. The inpatient care provider then records data on used medicinal products according to `subparagraph h)` (drugs administered over the last 12 months). The Ministry of Health (MZd) itself ensures the supplementation of data on dispensed drugs (last 12 months) from the central eRecept repository.

**Responsibility for Accuracy:** As soon as the provider records such data, they are responsible for its accuracy. The law clearly states that the person who entered the data into the emergency record bears the responsibility for ensuring it is correct and current. This obligation applies from the moment of recording – the provider must record the information without undue delay after becoming aware of the new fact.

**Obligation to Update and Delete:** The key sentence is in `Subsection 6 of §34a: "The recording person of the data according to Subsection 3, letter b) is obliged to record the data mandatorily listed in the emergency health record, and in case of discovering the data's inaccuracy, is obliged to correct or delete it."`. This means the provider has not only the right but the direct duty to keep the emergency data current. If they find that previously recorded data is no longer valid (e.g., the patient no longer suffers from the diagnosis, the allergy has been refuted, etc.), they must update or remove it. The law, therefore, explicitly imposes the obligation to actually delete the data if it is inaccurate—it is not just an authorization, but a binding requirement. This provision means the provider must delete the invalid record so that the emergency record does not contain erroneous or outdated information.

**Sanctions for Non-Compliance:** This obligation is not just formal – the amendment also introduces penalties. If a provider fails to record, correct, or delete the required data, or even records incorrect data in violation of `§34a odst. 6`, they commit an administrative offense. In other words, non-compliance with these duties can be sanctioned.

**Summary of Responsibilities:** The provider who enters the emergency data into the system is responsible for its correctness and currency. They are obliged to continuously maintain it – immediately correct it upon a change in health status and remove outdated data. The provider is therefore not only permitted but must delete an invalid record.

> Note: The patient has the right to access this shared data about themselves and the right to decide on its sharing. If the patient expresses disagreement with viewing, healthcare professionals and the statistical institute do not have access. This is reflected in our settings, see the Register of Authorizations. However, this does not change the provider's duty to record and update the data – it only limits its utilization.

#### Emergency Data within SZZ - Differences from the Patient Summary (PS) 🩺

**The Patient Summary (PS)** serves as a document for the exchange of information between systems in different countries (and potentially domestically). When a patient travels or receives care at another facility, their PS can be requested via the National Contact Point (NCP). The NCP acts as an intermediary – it ensures the request reaches the provider who maintains the PS, obtains a structured summary from them, and passes it on to the requester (the physician currently treating the patient). This is fully in line with the European standard for cross-border Patient Summary sharing.

**Content and Utilization vs. Emergency Record:** Both the Emergency Health Record (part of the SZZ) and the Patient Summary have a common goal – to provide healthcare professionals with a quick overview of key patient information. How do they differ?

* The Emergency Record is narrower. It contains only selected data necessary primarily during life-threatening situations or urgent care (blood group, allergies, severe reactions, latest dispensed and administered medications). It is truly a minimal dataset to ensure patient safety in acute situations.
* The Patient Summary is broader (though still a limited extract). It includes general anamnestic data, basic diagnoses, past illnesses, procedures, allergies, medications, family history, etc. – in short, a structured summary for the purpose of continuing treatment. The Patient Summary is not limited to urgent info – it also serves for planned care, second opinions, handover between a general practitioner and a specialist, etc.

**Centralized vs. Decentralized Approach:** From a systemic point of view, the fundamental difference is in the data location: the Emergency Record is a centralized dataset, while the Patient Summary remains as part of the documentation with individual providers. This means:

* Emergency data converges into a central database (managed by the state), from which authorized healthcare professionals across the entire Czech Republic can access it (if the patient has not opted out of sharing). Every provider thus sees the same emergency record for the patient – it is truly a shared record.
* The Patient Summary, conversely, is not stored centrally. It exists, for example, in the hospital system of the specific hospital that maintains it. It is not automatically distributed to all other physicians. It is only available when someone requests it (whether via NCP, DÚ, or eventually AAfD, etc…).

**Summary**

* **Legal Framework:** The Shared Record (emergency) is in the Act on the Electronisation of Healthcare (`325/2021 Coll. as amended`), the Patient Summary in the Act on Healthcare Services (`372/2011 Coll.`).
* **Obligation vs. Optionality:** Emergency Record – mandatory entry for all relevant providers. Patient Summary – voluntary maintenance (the provider may decide).
* **Data Location:** Emergency – central system of the state. Patient Summary – with the provider, no central repository of all PS (only registration in the NCP of who has the PS available).
* **Access and Sharing:** Emergency – automatically accessible to authorized physicians in the Czech Republic (patient opt-out possible). Patient Summary – shared only upon request (typically when treated abroad, or by a new physician) via the NCP, otherwise it is part of the documentation and a foreign physician does not view it unless officially requested.
* **Content:** Emergency – narrowly defined life-saving data. Patient Summary – broader, general basic health information (according to the regulation to the law).

