# Biopsy Type Prostate Valueset - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Biopsy Type Prostate Valueset**

## ValueSet: Biopsy Type Prostate Valueset 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/ValueSet/cz-type-biopsy-prostate-vs | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:TypeBiopsyProstateVS |

 
Biopsy type prostate value set 

 **References** 

* [Observation: Urology Biopsy(SZZ CZ)](StructureDefinition-cz-observation-urology-biopsy.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-type-biopsy-prostate-vs",
  "url" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-type-biopsy-prostate-vs",
  "version" : "0.0.1",
  "name" : "TypeBiopsyProstateVS",
  "title" : "Biopsy Type Prostate Valueset",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Biopsy type prostate value set",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-biopsy-cs"
      }
    ]
  }
}

```
