# EHDSI blood type codes - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **EHDSI blood type codes**

## ValueSet: EHDSI blood type codes 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.ehdsi.eu/ValueSet/eHDSIBloodGroup | *Version*:0.0.1 |
| Active as of 2025-03-05 | *Computable Name*:BloodTypeEhdsiVs |

 
The Value Set is used for Blood Type representation in the Shared Health Record according to EHDSI specifications. 

 **References** 

* [Observation: Blood Type (SZZ CZ)](StructureDefinition-cz-observation-blood-type.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-blood-type-ehdsi-vs",
  "language" : "cs",
  "url" : "http://terminology.ehdsi.eu/ValueSet/eHDSIBloodGroup",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "BloodTypeEhdsiVs",
  "title" : "EHDSI blood type codes",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-03-05",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "The Value Set is used for Blood Type representation in the Shared Health Record according to EHDSI specifications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "112144000",
            "display" : "Blood group A"
          },
          {
            "code" : "278152006",
            "display" : "Blood group A Rh(D) negative"
          },
          {
            "code" : "278149003",
            "display" : "Blood group A Rh(D) positive"
          },
          {
            "code" : "165743006",
            "display" : "Blood group AB"
          },
          {
            "code" : "278154007",
            "display" : "Blood group AB Rh(D) negative"
          },
          {
            "code" : "278151004",
            "display" : "Blood group AB Rh(D) positive"
          },
          {
            "code" : "112149005",
            "display" : "Blood group B"
          },
          {
            "code" : "278153001",
            "display" : "Blood group B Rh(D) negative"
          },
          {
            "code" : "278150003",
            "display" : "Blood group B Rh(D) positive"
          },
          {
            "code" : "58460004",
            "display" : "Blood group O"
          },
          {
            "code" : "278148006",
            "display" : "Blood group O Rh(D) negative"
          },
          {
            "code" : "278147001",
            "display" : "Blood group O Rh(D) positive"
          }
        ]
      }
    ]
  }
}

```
