# Allergy reaction category - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Allergy reaction category**

## ValueSet: Allergy reaction category 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/ValueSet/cz-allergy-reaction-category-szz-vs | *Version*:0.0.1 |
| Active as of 2025-03-05 | *Computable Name*:AllergyReactionCategorySzzVs |

 
The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction category. 

 **References** 

* [Allergy intolerance (SZZ CZ)](StructureDefinition-cz-allergyIntolerance-szz.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-allergy-reaction-category-szz-vs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-allergy-reaction-category-szz-vs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "AllergyReactionCategorySzzVs",
  "title" : "Allergy reaction category",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-03-05",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction category.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "concept" : [
          {
            "code" : "7231009",
            "display" : "Bullous dermatosis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Bulózní dermatóza"
              }
            ]
          },
          {
            "code" : "24079001",
            "display" : "Atopic dermatitis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Atopická dermatitida"
              }
            ]
          },
          {
            "code" : "49727002",
            "display" : "Cough",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Kašel"
              }
            ]
          },
          {
            "code" : "73442001",
            "display" : "Stevens-Johnson syndrome",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Stevensův-Johnsonův syndrom"
              }
            ]
          },
          {
            "code" : "386789004",
            "display" : "Eosinophil count raised",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Eozinofilie"
              }
            ]
          },
          {
            "code" : "4386001",
            "display" : "Bronchospasm",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Bronchospazmus"
              }
            ]
          },
          {
            "code" : "35001004",
            "display" : "Non-allergic anaphylaxis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Nealergická anafylaxe"
              }
            ]
          },
          {
            "code" : "51599000",
            "display" : "Edema of larynx",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Edém hrtanu"
              }
            ]
          },
          {
            "code" : "191306005",
            "display" : "Immunoglobulin A vasculitis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Imunoglobulin A vaskulitida"
              }
            ]
          },
          {
            "code" : "698247007",
            "display" : "Cardiac arrhythmia",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Srdeční arytmie"
              }
            ]
          },
          {
            "code" : "162290004",
            "display" : "Dry eyes",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Syndrom suchého oka"
              }
            ]
          },
          {
            "code" : "281239006",
            "display" : "Acute asthma",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Akutní astma"
              }
            ]
          },
          {
            "code" : "43116000",
            "display" : "Eczema",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Ekzém"
              }
            ]
          },
          {
            "code" : "247471006",
            "display" : "Maculopapular eruption",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Makulopapulózní exantém"
              }
            ]
          },
          {
            "code" : "247472004",
            "display" : "Wheal",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Edematózní dermatitida"
              }
            ]
          },
          {
            "code" : "267036007",
            "display" : "Dyspnea",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Dušnost"
              }
            ]
          },
          {
            "code" : "276444007",
            "display" : "Generalized pruritus",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Generalizovaný pruritus"
              }
            ]
          },
          {
            "code" : "418290006",
            "display" : "Itching",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Svědění"
              }
            ]
          },
          {
            "code" : "23924001",
            "display" : "Tight chest",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Tíseň na hrudi"
              }
            ]
          },
          {
            "code" : "62315008",
            "display" : "Diarrhea",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Průjem"
              }
            ]
          },
          {
            "code" : "22649008",
            "display" : "Photodermatitis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Fotodermatitida"
              }
            ]
          },
          {
            "code" : "79893008",
            "display" : "Vesicular eruption",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Vezikulární exantém"
              }
            ]
          },
          {
            "code" : "702809001",
            "display" : "Drug reaction with eosinophilia and systemic symptoms",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Léková reakce s eozinofilií a systémovými příznaky"
              }
            ]
          },
          {
            "code" : "40275004",
            "display" : "Contact dermatitis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Kontaktní dermatitida"
              }
            ]
          },
          {
            "code" : "70076002",
            "display" : "Rhinitis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Rhinitída"
              }
            ]
          },
          {
            "code" : "373932008",
            "display" : "Feels hot",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Pocit horka"
              }
            ]
          },
          {
            "code" : "60555002",
            "display" : "Hypersensitivity angiitis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Hypersenzitivní angiitida"
              }
            ]
          },
          {
            "code" : "271807003",
            "display" : "Eruption",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Vyrážka"
              }
            ]
          },
          {
            "code" : "271811009",
            "display" : "Face goes red",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Zarudnutí obličeje"
              }
            ]
          },
          {
            "code" : "418363000",
            "display" : "Itching of skin",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Svědění kůže"
              }
            ]
          },
          {
            "code" : "2129002",
            "display" : "Edema of pharynx",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Edém hltanu"
              }
            ]
          },
          {
            "code" : "422400008",
            "display" : "Vomiting",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Zvracení"
              }
            ]
          },
          {
            "code" : "444827008",
            "display" : "Erythema of skin",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Kožní erytém"
              }
            ]
          },
          {
            "code" : "41291007",
            "display" : "Angioedema",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Angioedém"
              }
            ]
          },
          {
            "code" : "44416002",
            "display" : "Airway constriction",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Zúžení dýchacích cest"
              }
            ]
          },
          {
            "code" : "81950002",
            "display" : "Edema of the tongue",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Edém jazyka"
              }
            ]
          },
          {
            "code" : "90128006",
            "display" : "Photosensitivity",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Fotocitlivost"
              }
            ]
          },
          {
            "code" : "247470007",
            "display" : "Morbilliform eruption",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Morbiliformní exantém"
              }
            ]
          },
          {
            "code" : "410430005",
            "display" : "Cardiorespiratory arrest",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Kardiorespirační zástava"
              }
            ]
          },
          {
            "code" : "230145002",
            "display" : "Difficulty breathing",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Respirační obtíže"
              }
            ]
          },
          {
            "code" : "247441003",
            "display" : "Erythema",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Erytém"
              }
            ]
          },
          {
            "code" : "421262002",
            "display" : "Tongue swelling",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Zduření jazyka"
              }
            ]
          },
          {
            "code" : "422587007",
            "display" : "Nausea",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Nevolnost"
              }
            ]
          },
          {
            "code" : "64144002",
            "display" : "Pruritic rash",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Svědivá vyrážka"
              }
            ]
          },
          {
            "code" : "271825005",
            "display" : "Respiratory distress",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Respirační insuficience"
              }
            ]
          },
          {
            "code" : "399992009",
            "display" : "Erythroderma",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Erytrodermie"
              }
            ]
          },
          {
            "code" : "432807008",
            "display" : "Pollen-food allergy",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Pylově-potravinová alergie"
              }
            ]
          },
          {
            "code" : "279333002",
            "display" : "Pruritus - disorder",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Pruritus kůže"
              }
            ]
          },
          {
            "code" : "91175000",
            "display" : "Seizure",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Křeč"
              }
            ]
          },
          {
            "code" : "781682005",
            "display" : "Hyperemia of eye",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Oční hyperémie"
              }
            ]
          },
          {
            "code" : "195967001",
            "display" : "Asthma",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Astma"
              }
            ]
          },
          {
            "code" : "271757001",
            "display" : "Papular eruption",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Papulózní exantém"
              }
            ]
          },
          {
            "code" : "768962006",
            "display" : "Lyell syndrome",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Lyellův syndrom"
              }
            ]
          },
          {
            "code" : "271759003",
            "display" : "Bullous eruption",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Bulózní exantém"
              }
            ]
          },
          {
            "code" : "9826008",
            "display" : "Conjunctivitis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Zánět spojivek"
              }
            ]
          },
          {
            "code" : "402407004",
            "display" : "Angioedema of tongue",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Angioedém jazyka"
              }
            ]
          },
          {
            "code" : "126485001",
            "display" : "Urticaria",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Kopřivka"
              }
            ]
          },
          {
            "code" : "195951007",
            "display" : "Acute exacerbation of chronic obstructive airways disease",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Akutní exacerbace chronické obstrukční nemoci dýchacích cest"
              }
            ]
          },
          {
            "code" : "31996006",
            "display" : "Vasculitis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Vaskulitida"
              }
            ]
          },
          {
            "code" : "76067001",
            "display" : "Sneezing",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Kýchání"
              }
            ]
          },
          {
            "code" : "271756005",
            "display" : "Macular eruption",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Makulární exantém"
              }
            ]
          },
          {
            "code" : "39579001",
            "display" : "Anaphylaxis",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Anafylaxe"
              }
            ]
          },
          {
            "code" : "74776002",
            "display" : "Itching of eye",
            "designation" : [
              {
                "language" : "cs",
                "value" : "Svědění oka"
              }
            ]
          }
        ]
      }
    ]
  }
}

```
