# A.3.2 - Gynekologie - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.2 - Gynekologie**

## Logical Model: A.3.2 - Gynekologie 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/logGynecologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzGynecologyCz |

 
Sdílený zdravotní záznam - Preventivní a screeningové vyšetření Gynekologem. 

**Usages:**

* Use this Logical Model: [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/logGynecologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logGynecologyCz.csv), [Excel](StructureDefinition-logGynecologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logGynecologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/logGynecologyCz",
  "version" : "0.0.1",
  "name" : "LogCzGynecologyCz",
  "title" : "A.3.2 - Gynekologie",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Preventivní a screeningové vyšetření Gynekologem.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/logGynecologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logGynecologyCz",
        "path" : "logGynecologyCz",
        "short" : "A.3.2 - Gynekologie",
        "definition" : "Sdílený zdravotní záznam - Preventivní a screeningové vyšetření Gynekologem."
      },
      {
        "id" : "logGynecologyCz.kolorektalniScreening",
        "path" : "logGynecologyCz.kolorektalniScreening",
        "short" : "A.3.2.1 - Výsledek vyšetření v rámci screeningu kolorektálního karcinomu",
        "definition" : "Výsledek vyšetření kvantitativního testu okultního krvácení do stolice.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.kolorektalniScreening.datumVysledku",
        "path" : "logGynecologyCz.kolorektalniScreening.datumVysledku",
        "short" : "A.3.2.1.1 - Datum výsledku kvantitativního TOKS",
        "definition" : "Datum, kdy provádíte vyhodnocení vzorku (datum vykázání provedeného TOKS zdravotní pojišťovně). Týká se testů vyhodnocených v ordinaci lékaře nebo v laboratoři.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.kolorektalniScreening.vysledekTOKS",
        "path" : "logGynecologyCz.kolorektalniScreening.vysledekTOKS",
        "short" : "A.3.2.1.2 - Výsledek kvantitativního TOKS (kód zdravotního výkonu vykazovaný zdravotní pojišťovně)",
        "definition" : "Kód zdravotního výkonu vykazovaný pojišťovně na základě výsledku screeningového kvantitativního TOKS.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.kolorektalniScreening.hladinaTOKS",
        "path" : "logGynecologyCz.kolorektalniScreening.hladinaTOKS",
        "short" : "A.3.2.1.3 - Hladina TOKS",
        "definition" : "Hodnota kvantitativního imunochemického testu (µg/g).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.cytologickeVysetreni",
        "path" : "logGynecologyCz.cytologickeVysetreni",
        "short" : "A.3.2.2 - Výsledek cytologického vyšetření v rámci screeningu karcinomu děložního hrdla",
        "definition" : "A.3.2.2 - Výsledek cytologického vyšetření v rámci screeningu karcinomu děložního hrdla",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.cytologickeVysetreni.datumVysetreni",
        "path" : "logGynecologyCz.cytologickeVysetreni.datumVysetreni",
        "short" : "A.3.2.2.1 - Datum cytologického vyšetření",
        "definition" : "Datum odběru materiálu pro cytologické vyšetření (stěr z děložního hrdla).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.cytologickeVysetreni.vysledekVysetreni",
        "path" : "logGynecologyCz.cytologickeVysetreni.vysledekVysetreni",
        "short" : "A.3.2.2.2 - Výsledek cytologického vyšetření",
        "definition" : "Výsledek cytologického vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.vysetreniHPV",
        "path" : "logGynecologyCz.vysetreniHPV",
        "short" : "A.3.2.3 - Výsledek HPV vyšetření v rámci screeningu karcinomu děložního hrdla",
        "definition" : "A.3.2.3 - Výsledek HPV vyšetření v rámci screeningu karcinomu děložního hrdla",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.vysetreniHPV.datumVysetreni",
        "path" : "logGynecologyCz.vysetreniHPV.datumVysetreni",
        "short" : "A.3.2.3.1 - Datum high risk HPV vyšetření",
        "definition" : "Datum, kdy je pacientce proveden odběr materiálu z děložního hrdla.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.vysetreniHPV.vysledekHPV",
        "path" : "logGynecologyCz.vysetreniHPV.vysledekHPV",
        "short" : "A.3.2.3.2 - Výsledek high risk HPV vyšetření",
        "definition" : "Výsledek HPV vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.expertniKolposkopie",
        "path" : "logGynecologyCz.expertniKolposkopie",
        "short" : "A.3.2.4 - Výsledek expertní kolposkopie v rámci screeningu karcinomu děložního hrdla",
        "definition" : "A.3.2.4 - Výsledek expertní kolposkopie v rámci screeningu karcinomu děložního hrdla",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.expertniKolposkopie.datumVysetreni",
        "path" : "logGynecologyCz.expertniKolposkopie.datumVysetreni",
        "short" : "A.3.2.4.1 - Datum provedení expertní kolposkopie",
        "definition" : "Datum, kdy je pacientce provedena expertní kolposkopie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.expertniKolposkopie.vysledekVysetreni",
        "path" : "logGynecologyCz.expertniKolposkopie.vysledekVysetreni",
        "short" : "A.3.2.4.2 - Výsledek expertní kolposkopie",
        "definition" : "Vyhodnocení výsledku expertní kolposkopie. Nález je v normě a není vyžadována další intervence, případně je vyžadováno opakování vyšetření po určitém intervalu, nebo je vyžadováno provedení biopsie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.preventivniProhlidka",
        "path" : "logGynecologyCz.preventivniProhlidka",
        "short" : "A.3.2.5 - Výsledek vyšetření v rámci preventivní prohlídky",
        "definition" : "A.3.2.5 - Výsledek vyšetření v rámci preventivní prohlídky",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.preventivniProhlidka.datumVysetreni",
        "path" : "logGynecologyCz.preventivniProhlidka.datumVysetreni",
        "short" : "A.3.2.5.1 - Datum výsledku provedené preventivní prohlídky",
        "definition" : "Datum provedení preventivní prohlídky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.preventivniProhlidka.vyska",
        "path" : "logGynecologyCz.preventivniProhlidka.vyska",
        "short" : "A.3.2.5.2 - Výška",
        "definition" : "Výška pacientky v cm.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.preventivniProhlidka.vaha",
        "path" : "logGynecologyCz.preventivniProhlidka.vaha",
        "short" : "A.3.2.5.3 - Váha",
        "definition" : "Váha pacientky v kg.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.preventivniProhlidka.ockovaniHPV",
        "path" : "logGynecologyCz.preventivniProhlidka.ockovaniHPV",
        "short" : "A.3.2.5.4 - Očkování HPV",
        "definition" : "Pacientka má/nemá dokončené očkovaní proti HPV.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.preventivniProhlidka.posledniAplikaceOckovaniHPV",
        "path" : "logGynecologyCz.preventivniProhlidka.posledniAplikaceOckovaniHPV",
        "short" : "A.3.2.5.5 - Očkování HPV - rok aplikace poslední dávky",
        "definition" : "Rok, kdy byla pacientce aplikována poslední dávka očkování proti HPV.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "date"
          }
        ]
      },
      {
        "id" : "logGynecologyCz.preventivniProhlidka.ockovaciLatkaHPV",
        "path" : "logGynecologyCz.preventivniProhlidka.ockovaciLatkaHPV",
        "short" : "A.3.2.5.6 - Očkování HPV - očkovací látka",
        "definition" : "Očkovací látka, která byla pacientce aplikována.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
