# A.3.1 - Všeobecný praktický lékař - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.1 - Všeobecný praktický lékař**

## Logical Model: A.3.1 - Všeobecný praktický lékař 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/logGeneralPractitionerCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzGeneralPractitionerCz |

 
Sdílený zdravotní záznam - Preventivní a screeningové vyšetření všeobecným praktickým lékařem. 

**Usages:**

* Use this Logical Model: [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/logGeneralPractitionerCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logGeneralPractitionerCz.csv), [Excel](StructureDefinition-logGeneralPractitionerCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logGeneralPractitionerCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/logGeneralPractitionerCz",
  "version" : "0.0.1",
  "name" : "LogCzGeneralPractitionerCz",
  "title" : "A.3.1 - Všeobecný praktický lékař",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Preventivní a screeningové vyšetření všeobecným praktickým lékařem.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/logGeneralPractitionerCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logGeneralPractitionerCz",
        "path" : "logGeneralPractitionerCz",
        "short" : "A.3.1 - Všeobecný praktický lékař",
        "definition" : "Sdílený zdravotní záznam - Preventivní a screeningové vyšetření všeobecným praktickým lékařem."
      },
      {
        "id" : "logGeneralPractitionerCz.kolorektalniScreening",
        "path" : "logGeneralPractitionerCz.kolorektalniScreening",
        "short" : "A.3.1.1 - Výsledek vyšetření v rámci screeningu kolorektálního karcinomu",
        "definition" : "Výsledek vyšetření kvantitativního testu okultního krvácení do stolice.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.kolorektalniScreening.datumVysledku",
        "path" : "logGeneralPractitionerCz.kolorektalniScreening.datumVysledku",
        "short" : "A.3.1.1.1 - Datum výsledku kvantitativního TOKS",
        "definition" : "Datum, kdy provádíte vyhodnocení vzorku (datum vykázání provedeného TOKS zdravotní pojišťovně). Týká se testů vyhodnocených v ordinaci lékaře nebo v laboratoři.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.kolorektalniScreening.vysledekTOKS",
        "path" : "logGeneralPractitionerCz.kolorektalniScreening.vysledekTOKS",
        "short" : "A.3.1.1.2 - Výsledek kvantitativního TOKS (kód zdravotního výkonu vykazovaný zdravotní pojišťovně)",
        "definition" : "Kód zdravotního výkonu vykazovaný pojišťovně na základě výsledku screeningového kvantitativního TOKS.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.kolorektalniScreening.hladinaTOKS",
        "path" : "logGeneralPractitionerCz.kolorektalniScreening.hladinaTOKS",
        "short" : "A.3.1.1.3 - Hladina TOKS",
        "definition" : "Hodnota kvantitativního imunochemického testu (µg/g).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.vysetreniKarcinomuProstaty",
        "path" : "logGeneralPractitionerCz.vysetreniKarcinomuProstaty",
        "short" : "A.3.1.2 - Výsledek vyšetření v rámci časného záchytu karcinomu prostaty",
        "definition" : "Kategorický výsledek stanovení PSA podle hodnoty.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.vysetreniKarcinomuProstaty.datumVysledku",
        "path" : "logGeneralPractitionerCz.vysetreniKarcinomuProstaty.datumVysledku",
        "short" : "A.3.1.2.1 - Datum výsledku PSA",
        "definition" : "Datum, kdy provádíte vyhodnocení (datum vykázání provedeného PSA  zdravotní pojišťovně).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.vysetreniKarcinomuProstaty.vysledekPSA",
        "path" : "logGeneralPractitionerCz.vysetreniKarcinomuProstaty.vysledekPSA",
        "short" : "A.3.1.2.2 - Výsledek kvantitativního PSA (kód zdravotního výkonu vykazovaný zdravotní pojišťovně)",
        "definition" : "Kód  zdravotního výkonu výkazovaný pojišťovně na základě hodnoty hladiny prostatického specifického antigenu v krvi pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.preventivniProhlidka",
        "path" : "logGeneralPractitionerCz.preventivniProhlidka",
        "short" : "A.3.1.3 - Výsledek vyšetření v rámci preventivní prohlídky",
        "definition" : "A.3.1.3 - Výsledek vyšetření v rámci preventivní prohlídky",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.preventivniProhlidka.datumVysetreni",
        "path" : "logGeneralPractitionerCz.preventivniProhlidka.datumVysetreni",
        "short" : "A.3.1.3.1 - Datum výsledku provedené preventivní prohlídky",
        "definition" : "Datum provedení preventivní prohlídky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.preventivniProhlidka.vyska",
        "path" : "logGeneralPractitionerCz.preventivniProhlidka.vyska",
        "short" : "A.3.1.3.2 - Výška",
        "definition" : "Výška pacienta v cm.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.preventivniProhlidka.vaha",
        "path" : "logGeneralPractitionerCz.preventivniProhlidka.vaha",
        "short" : "A.3.1.3.3 - Váha",
        "definition" : "Váha pacienta v kg.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.preventivniProhlidka.systolickyTlak",
        "path" : "logGeneralPractitionerCz.preventivniProhlidka.systolickyTlak",
        "short" : "A.3.1.3.4 - Tlak (systolický)",
        "definition" : "Hodnota v mm Hg.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.preventivniProhlidka.diastolickyTlak",
        "path" : "logGeneralPractitionerCz.preventivniProhlidka.diastolickyTlak",
        "short" : "A.3.1.3.5 - Tlak (diastolický)",
        "definition" : "Hodnota v mm Hg.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "logGeneralPractitionerCz.preventivniProhlidka.obvodPasu",
        "path" : "logGeneralPractitionerCz.preventivniProhlidka.obvodPasu",
        "short" : "A.3.1.3.6 - Obvod pasu",
        "definition" : "Obvod pasu v cm.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      }
    ]
  }
}

```
