# A.1.7 - Elektronické podpisy - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.7 - Elektronické podpisy**

## Logical Model: A.1.7 - Elektronické podpisy 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/logDigitalSignatureCz | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogCzDigitalSignatureCz |

 
Sdílený zdravotní záznam - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a 

**Usages:**

* Use this Logical Model: [A.1 - Hlavička dokumentu](StructureDefinition-LogHeaderSzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/logDigitalSignatureCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logDigitalSignatureCz.csv), [Excel](StructureDefinition-logDigitalSignatureCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logDigitalSignatureCz",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/logDigitalSignatureCz",
  "version" : "0.0.1",
  "name" : "LogCzDigitalSignatureCz",
  "title" : "A.1.7 - Elektronické podpisy",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/logDigitalSignatureCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logDigitalSignatureCz",
        "path" : "logDigitalSignatureCz",
        "short" : "A.1.7 - Elektronické podpisy",
        "definition" : "Sdílený zdravotní záznam - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a"
      },
      {
        "id" : "logDigitalSignatureCz.elektronickyPodpis",
        "path" : "logDigitalSignatureCz.elektronickyPodpis",
        "short" : "A.1.7.1 - Elektronický podpis",
        "definition" : "Elektronický podpis nebo pečeť dokumentu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Signature"
          }
        ]
      },
      {
        "id" : "logDigitalSignatureCz.casoveRazitko",
        "path" : "logDigitalSignatureCz.casoveRazitko",
        "short" : "A.1.7.2 - Elektronické časové razítko",
        "definition" : "Elektronické časové razítko ",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "instant"
          }
        ]
      }
    ]
  }
}

```
