# Observation: Pulmonology (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Pulmonology (SZZ CZ)**

## Resource Profile: Observation: Pulmonology (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-pulmonology | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_ObservationPulmonology |

 
This profile defines how to represent Pulmonology Observation resource in HL7 FHIR for the scope of this guide. 

**Usages:**

* Refer to this Profile: [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)
* Examples for this Profile: [Observation/407b583e-4c05-47eb-b0df-6d8166c0d4f1](Observation-407b583e-4c05-47eb-b0df-6d8166c0d4f1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-observation-pulmonology)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-observation-pulmonology.csv), [Excel](StructureDefinition-cz-observation-pulmonology.xlsx), [Schematron](StructureDefinition-cz-observation-pulmonology.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-observation-pulmonology",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-pulmonology",
  "version" : "0.0.1",
  "name" : "CZ_ObservationPulmonology",
  "title" : "Observation: Pulmonology (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Pulmonology Observation resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "sct-concept",
      "uri" : "http://snomed.info/conceptdomain",
      "name" : "SNOMED CT Concept Domain Binding"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "sct-attr",
      "uri" : "http://snomed.org/attributebinding",
      "name" : "SNOMED CT Attribute Binding"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Observation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Observation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Observation",
        "path" : "Observation"
      },
      {
        "id" : "Observation.code",
        "path" : "Observation.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "301230006",
              "display" : "Lung finding"
            }
          ]
        }
      },
      {
        "id" : "Observation.effective[x]",
        "path" : "Observation.effective[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.effective[x]:effectiveDateTime",
        "path" : "Observation.effective[x]",
        "sliceName" : "effectiveDateTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Observation.interpretation.coding",
        "path" : "Observation.interpretation.coding",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-pulmonology-interpretation-vs"
        }
      },
      {
        "id" : "Observation.component",
        "path" : "Observation.component",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Components of the biopsy during mammography observation",
        "min" : 1
      },
      {
        "id" : "Observation.component:medicalHistoryOfSmoking",
        "path" : "Observation.component",
        "sliceName" : "medicalHistoryOfSmoking",
        "short" : "Current smoking history.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:medicalHistoryOfSmoking.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "365981007",
              "display" : "Finding of tobacco smoking behavior"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:medicalHistoryOfSmoking.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:medicalHistoryOfSmoking.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-tobacco-history-vs"
        }
      },
      {
        "id" : "Observation.component:yearsSinceQuittingSmoking",
        "path" : "Observation.component",
        "sliceName" : "yearsSinceQuittingSmoking",
        "short" : "How many years ago did the patient quit smoking?",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:yearsSinceQuittingSmoking.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "160617001",
              "display" : "Stopped smoking"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:yearsSinceQuittingSmoking.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:yearsSinceQuittingSmoking.value[x]:valueInteger",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueInteger",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "Observation.component:yearsOfSmoking",
        "path" : "Observation.component",
        "sliceName" : "yearsOfSmoking",
        "short" : "How many years has the patient been smoking/smoked?",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:yearsOfSmoking.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "266918002",
              "display" : "Tobacco smoking consumption"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:yearsOfSmoking.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:yearsOfSmoking.value[x]:valueInteger",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueInteger",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "Observation.component:packYears",
        "path" : "Observation.component",
        "sliceName" : "packYears",
        "short" : "Pack-years = (number of cigarettes per day ÷ 20) × number of years smoked. One pack-year means smoking one pack per day for one year (or 2 packs per day for half a year, or half a pack per day for 2 years, etc.)",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:packYears.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "782516008",
              "display" : "Number of calculated smoking pack years"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:packYears.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:packYears.value[x]:valueInteger",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueInteger",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "Observation.component:physicalExamResult",
        "path" : "Observation.component",
        "sliceName" : "physicalExamResult",
        "short" : "Result of physical examination",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:physicalExamResult.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "5880005",
              "display" : "Physical examination"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:physicalExamResult.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:physicalExamResult.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-physical-examination-pulmonology-result-vs"
        }
      },
      {
        "id" : "Observation.component:functionalExamResult",
        "path" : "Observation.component",
        "sliceName" : "functionalExamResult",
        "short" : "Result of functional examination",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:functionalExamResult.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "12894003",
              "display" : "Functional assessment"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:functionalExamResult.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:functionalExamResult.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-functional-examination-pulmonology-result-vs"
        }
      },
      {
        "id" : "Observation.component:xray",
        "path" : "Observation.component",
        "sliceName" : "xray",
        "short" : "Result of functional examination",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Observation.component:xray.code",
        "path" : "Observation.component.code",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "399208008",
              "display" : "Plain chest X-ray"
            }
          ]
        }
      },
      {
        "id" : "Observation.component:xray.value[x]",
        "path" : "Observation.component.value[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Observation.component:xray.value[x]:valueCodeableConcept",
        "path" : "Observation.component.value[x]",
        "sliceName" : "valueCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-pulmonology-result-vs"
        }
      }
    ]
  }
}

```
