# Composition (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Composition (SZZ CZ)**

## Resource Profile: Composition (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_CompositionSzz |

 
This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. 

**Usages:**

* Use this Profile: [Bundle (SZZ CZ)](StructureDefinition-cz-bundle-sharedhealthrecord.md)
* Examples for this Profile: [Composition/91795ef9-ba97-4712-95b4-177f1d784066](Composition-91795ef9-ba97-4712-95b4-177f1d784066.md), [Composition/930ca243-d3aa-4b38-9737-3c2e48000f74](Composition-930ca243-d3aa-4b38-9737-3c2e48000f74.md) and [Composition/f711d704-df5c-4599-ac80-e8636e0f9931](Composition-f711d704-df5c-4599-ac80-e8636e0f9931.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-composition-sharedhealthrecord)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-composition-sharedhealthrecord.csv), [Excel](StructureDefinition-cz-composition-sharedhealthrecord.xlsx), [Schematron](StructureDefinition-cz-composition-sharedhealthrecord.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-composition-sharedhealthrecord",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord",
  "version" : "0.0.1",
  "name" : "CZ_CompositionSzz",
  "title" : "Composition (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Shared Health Record composition",
        "definition" : "Shared Health Record composition. \r\nA composition is a set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \r\nWhile a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained.",
        "constraint" : [
          {
            "key" : "text-or-section",
            "severity" : "error",
            "human" : "A Composition SHALL have either text, at least one section, or both.",
            "expression" : "text.exists() or section.exists()",
            "source" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord"
          }
        ]
      },
      {
        "id" : "Composition.language",
        "path" : "Composition.language",
        "min" : 1
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.extension:versionNumber",
        "path" : "Composition.extension",
        "sliceName" : "versionNumber",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Composition.version"
            ]
          }
        ]
      },
      {
        "id" : "Composition.extension:versionNumber.value[x]",
        "path" : "Composition.extension.value[x]",
        "short" : "Business version"
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "SZZ business identifier"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "SZZ status"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "34117-2",
              "display" : "History and physical note"
            }
          ]
        }
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "definition" : "Who or what the composition is about. \r\nIn general a composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).\r\nFor the hdr the subject is always the patient.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "SZZ date"
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Who and/or what authored the Shared Health Record",
        "definition" : "Identifies who is responsible for the information in the Shared Health Record.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "Shared Health Record",
        "definition" : "Official human-readable label for the composition.\r\n\r\nFor this document should be \"Shared Health Record\" or any equivalent translation"
      },
      {
        "id" : "Composition.confidentiality",
        "path" : "Composition.confidentiality",
        "min" : 1
      },
      {
        "id" : "Composition.custodian",
        "path" : "Composition.custodian",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Sections of the report",
        "min" : 1
      },
      {
        "id" : "Composition.section.author",
        "path" : "Composition.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:emergencyRecord",
        "path" : "Composition.section",
        "sliceName" : "emergencyRecord",
        "short" : "Emergency record Section",
        "definition" : "This section holds information about emergency record.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:emergencyRecord.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10001",
              "display" : "Emergency health record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:emergencyRecord.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:emergencyRecord.entry:bloodType",
        "path" : "Composition.section.entry",
        "sliceName" : "bloodType",
        "short" : "Blood Type Information",
        "definition" : "This entry holds a reference to the observation about blood type.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-blood-type"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:emergencyRecord.entry:allergiesAndAdverseReactions",
        "path" : "Composition.section.entry",
        "sliceName" : "allergiesAndAdverseReactions",
        "short" : "Allergies and Adverse Reactions Information",
        "definition" : "This entry holds a reference to the allergy or adverse reaction record.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:emergencyRecord.entry:otherEmergencyInformation",
        "path" : "Composition.section.entry",
        "sliceName" : "otherEmergencyInformation",
        "short" : "Other Emergency Information",
        "definition" : "This entry holds a reference to other emergency information.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-adverse-event"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:emergencyRecord.entry:medicationHistoryDuringHospitalization",
        "path" : "Composition.section.entry",
        "sliceName" : "medicationHistoryDuringHospitalization",
        "short" : "Medication History Information",
        "definition" : "This entry holds a reference to the medication history.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord",
        "path" : "Composition.section",
        "sliceName" : "preventingAndScreeningRecord",
        "short" : "Preventing and screening record Section",
        "definition" : "This section holds information about preventing and screening examination.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.code",
        "path" : "Composition.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10002",
              "display" : "Preventive and screening health record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section",
        "path" : "Composition.section.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section.title",
        "path" : "Composition.section.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:generalPractitioner",
        "path" : "Composition.section.section",
        "sliceName" : "generalPractitioner",
        "short" : "General Practitioner Section",
        "definition" : "This section holds information about an examination of general practitioner.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:generalPractitioner.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10003",
              "display" : "General practitioner record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:generalPractitioner.author",
        "path" : "Composition.section.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:generalPractitioner.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:generalPractitioner.entry:observationColorectalCancerScreening",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationColorectalCancerScreening",
        "short" : "Observation Colorectal Cancer Screening",
        "definition" : "This entry holds a reference to the observation about colorectal cancer screening.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colorectal-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:generalPractitioner.entry:observationProstateCancerScreening",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationProstateCancerScreening",
        "short" : "Observation Prostate Cancer Screening",
        "definition" : "This entry holds a reference to the observation about prostate cancer screening.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-prostate-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:generalPractitioner.entry:preventingExamination",
        "path" : "Composition.section.section.entry",
        "sliceName" : "preventingExamination",
        "short" : "Preventing Examination",
        "definition" : "This entry holds a reference to the preventing examination.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyheight",
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyweight",
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-waist-circumference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology",
        "path" : "Composition.section.section",
        "sliceName" : "gynecology",
        "short" : "General Practitioner Section",
        "definition" : "This section holds information about an examination of general practitioner.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10004",
              "display" : "Gynecology record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology.author",
        "path" : "Composition.section.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology.entry:observationColorectalCancerScreening",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationColorectalCancerScreening",
        "short" : "Observation Colorectal Cancer Screening",
        "definition" : "This entry holds a reference to the observation about colorectal cancer screening.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colorectal-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology.entry:observationCervicalCancerCytologyScreening",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationCervicalCancerCytologyScreening",
        "short" : "Observation Cervical Cancer Cytology Screening",
        "definition" : "This entry holds a reference to the observation about cervical cancer cytology screening.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-cytology-cervical-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology.entry:observationCervicalCancerHPVScreening",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationCervicalCancerHPVScreening",
        "short" : "Observation Cervical Cancer HPV Screening",
        "definition" : "This entry holds a reference to the observation about cervical cancer HPV screening.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-hpv-cervical-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology.entry:observationCervicalCancerColposcopy",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationCervicalCancerColposcopy",
        "short" : "Observation Cervical Cancer Colposcopy",
        "definition" : "This entry holds a reference to the observation about cervical cancer colposcopy.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colposcopy-cervical-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gynecology.entry:preventingExamination",
        "path" : "Composition.section.section.entry",
        "sliceName" : "preventingExamination",
        "short" : "Preventing Examination",
        "definition" : "This entry holds a reference to the preventing examination.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyheight",
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyweight",
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-immunization-hpv"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:biochemistryLaboratory",
        "path" : "Composition.section.section",
        "sliceName" : "biochemistryLaboratory",
        "short" : "Biochemistry Laboratory Section",
        "definition" : "This section holds information about biochemistry laboratory.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:biochemistryLaboratory.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10005",
              "display" : "Biochemistry laboratory record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:biochemistryLaboratory.author",
        "path" : "Composition.section.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:biochemistryLaboratory.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:biochemistryLaboratory.entry:observationColorectalCancerScreening",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationColorectalCancerScreening",
        "short" : "Observation Colorectal Cancer Screening",
        "definition" : "This entry holds a reference to the observation about colorectal cancer screening.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colorectal-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:biochemistryLaboratory.entry:observationProstateCancerScreening",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationProstateCancerScreening",
        "short" : "Observation Prostate Cancer Screening",
        "definition" : "This entry holds a reference to the observation about prostate cancer screening.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-prostate-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:urology",
        "path" : "Composition.section.section",
        "sliceName" : "urology",
        "short" : "Urology Section",
        "definition" : "This section holds information about urology.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:urology.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10006",
              "display" : "Urology record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:urology.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:urology.entry:observationProstateCancerScreening",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationProstateCancerScreening",
        "short" : "Observation Prostate Cancer Screening",
        "definition" : "This entry holds a reference to the prostate cancer screening.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-prostate-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:urology.entry:observationUrology",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationUrology",
        "short" : "Observation Urology",
        "definition" : "This entry holds a reference to the prostate urology observation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:urology.entry:observationUrologyBiopsy",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationUrologyBiopsy",
        "short" : "Observation Urology Biopsy",
        "definition" : "This entry holds a reference to the urology biopsy observation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology-biopsy"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:pulmonology",
        "path" : "Composition.section.section",
        "sliceName" : "pulmonology",
        "short" : "Pulmonology Section",
        "definition" : "This section holds information about pulmonology.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:pulmonology.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10007",
              "display" : "Pulmonology record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:pulmonology.author",
        "path" : "Composition.section.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:pulmonology.entry",
        "path" : "Composition.section.section.entry",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-pulmonology"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gastroenterology",
        "path" : "Composition.section.section",
        "sliceName" : "gastroenterology",
        "short" : "Gastroenterology Section",
        "definition" : "This section holds information about gastroenterology.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gastroenterology.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10008",
              "display" : "Gastroenterology record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gastroenterology.author",
        "path" : "Composition.section.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:gastroenterology.entry",
        "path" : "Composition.section.section.entry",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colonoscopy"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology",
        "path" : "Composition.section.section",
        "sliceName" : "radiology",
        "short" : "Radiology Section",
        "definition" : "This section holds information about radiology.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10009",
              "display" : "Radiology record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology.author",
        "path" : "Composition.section.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology.entry",
        "path" : "Composition.section.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "profile",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology.entry:observationMammography",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationMammography",
        "short" : "Observation Mammography",
        "definition" : "This entry holds a reference to the mammography observation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mammography"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology.entry:observationMammographyBiopsy",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationMammographyBiopsy",
        "short" : "Observation Mammography Biopsy",
        "definition" : "This entry holds a reference to the mammography biopsy observation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mammography-biopsy"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology.entry:observationLungCancer",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationLungCancer",
        "short" : "Observation CT Lung Cancer",
        "definition" : "This entry holds a reference to the ct lung cancer observation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-lung-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology.entry:observationMRIProstateCancer",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationMRIProstateCancer",
        "short" : "Observation MRI Prostate Cancer",
        "definition" : "This entry holds a reference to the mri prostate cancer observation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mri-prostate-cancer"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:radiology.entry:observationAbdominaAorticAneurysms",
        "path" : "Composition.section.section.entry",
        "sliceName" : "observationAbdominaAorticAneurysms",
        "short" : "Observation Abdomina Aortic Aneurysms",
        "definition" : "This entry holds a reference to the abdomina aortic aneurysms observation.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-abdomina-aortic-aneurysms"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:angiology",
        "path" : "Composition.section.section",
        "sliceName" : "angiology",
        "short" : "Angiology Section",
        "definition" : "This section holds information about angiology.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:angiology.code",
        "path" : "Composition.section.section.code",
        "min" : 1,
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-document-section-szz-cs",
              "code" : "10010",
              "display" : "Angiology record"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:angiology.author",
        "path" : "Composition.section.section.author",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-relatedPerson-core",
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:preventingAndScreeningRecord.section:angiology.entry",
        "path" : "Composition.section.section.entry",
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-abdomina-aortic-aneurysms"
            ]
          }
        ]
      }
    ]
  }
}

```
