# Bundle (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Bundle (SZZ CZ)**

## Resource Profile: Bundle (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-bundle-sharedhealthrecord | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_BundleSzz |

 
Clinical document used to represent a Shared Health Record for the scope of this guide. 

**Usages:**

* Examples for this Profile: [Bundle/cz-example-bundle-emergencyrecord](Bundle-cz-example-bundle-emergencyrecord.md), [Bundle/cz-example-bundle-screeningrecord-2](Bundle-cz-example-bundle-screeningrecord-2.md) and [Bundle/cz-example-bundle-screeningrecord](Bundle-cz-example-bundle-screeningrecord.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-bundle-sharedhealthrecord)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-bundle-sharedhealthrecord.csv), [Excel](StructureDefinition-cz-bundle-sharedhealthrecord.xlsx), [Schematron](StructureDefinition-cz-bundle-sharedhealthrecord.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-bundle-sharedhealthrecord",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bundle-sharedhealthrecord",
  "version" : "0.0.1",
  "name" : "CZ_BundleSzz",
  "title" : "Bundle (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Shared Health Record for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Shared Health Record bundle",
        "definition" : "Shared Health Record bundle.",
        "constraint" : [
          {
            "key" : "bdl-elp-1",
            "severity" : "error",
            "human" : "An document must have no additional Composition (including Composition subclass) resources besides the first.",
            "expression" : "entry.tail().where(resource is Composition).empty()",
            "source" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-bundle-sharedhealthrecord"
          }
        ]
      },
      {
        "id" : "Bundle.identifier",
        "path" : "Bundle.identifier",
        "short" : "Instance identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.type",
        "path" : "Bundle.type",
        "fixedCode" : "document"
      },
      {
        "id" : "Bundle.timestamp",
        "path" : "Bundle.timestamp",
        "short" : "Instance identifier",
        "min" : 1
      },
      {
        "id" : "Bundle.link",
        "path" : "Bundle.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            },
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Entry resource in the Shared Health Record bundle",
        "definition" : "An entry resource included in the Shared Health Record document bundle resource.",
        "comment" : "Must contain the SZZ Composition as the first entry (only a single Composition resource instance may be included). Additional constraints are specified in the SZZ Composition profile.",
        "min" : 3
      },
      {
        "id" : "Bundle.entry.link",
        "path" : "Bundle.entry.link",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Patient",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "min" : 1,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitioner-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitionerRole",
        "path" : "Bundle.entry",
        "sliceName" : "practitionerRole",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitionerRole.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-practitionerrole-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:organization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Organization",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation",
        "path" : "Bundle.entry",
        "sliceName" : "observation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Observation",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-blood-type",
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyweight"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:adverseEvent",
        "path" : "Bundle.entry",
        "sliceName" : "adverseEvent",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:adverseEvent.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "AdverseEvent",
            "profile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-adverse-event"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:allergiesAndIntolerances",
        "path" : "Bundle.entry",
        "sliceName" : "allergiesAndIntolerances",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:allergiesAndIntolerances.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "AllergyIntolerance",
            "profile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-allergyIntolerance-szz"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationStatements",
        "path" : "Bundle.entry",
        "sliceName" : "medicationStatements",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationStatements.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : [
              "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medications",
        "path" : "Bundle.entry",
        "sliceName" : "medications",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medications.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Medication",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-Medication"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:documentReference",
        "path" : "Bundle.entry",
        "sliceName" : "documentReference",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:documentReference.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DocumentReference",
            "profile" : ["https://hl7.cz/fhir/core/StructureDefinition/cz-logo"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:immunization",
        "path" : "Bundle.entry",
        "sliceName" : "immunization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:immunization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Immunization",
            "profile" : [
              "https://hl7.cz/fhir/szz/StructureDefinition/cz-immunization-hpv"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.signature",
        "path" : "Bundle.signature",
        "short" : "Report Digital Signature"
      },
      {
        "id" : "Bundle.signature.type",
        "path" : "Bundle.signature.type",
        "short" : "Digital Signature Purposes"
      },
      {
        "id" : "Bundle.signature.when",
        "path" : "Bundle.signature.when",
        "short" : "When was signed"
      },
      {
        "id" : "Bundle.signature.who",
        "path" : "Bundle.signature.who",
        "short" : "Who signed."
      },
      {
        "id" : "Bundle.signature.data",
        "path" : "Bundle.signature.data",
        "short" : "Signature content"
      }
    ]
  }
}

```
