# Allergy intolerance (SZZ CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Allergy intolerance (SZZ CZ)**

## Resource Profile: Allergy intolerance (SZZ CZ) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/cz-allergyIntolerance-szz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:CZ_AllergyIntoleranceSzz |

 
Czech profile for allergy intolerance. 

**Usages:**

* Use this Profile: [Bundle (SZZ CZ)](StructureDefinition-cz-bundle-sharedhealthrecord.md)
* Examples for this Profile: [AllergyIntolerance/4b343429-16da-4a5b-be80-17e4122f5956](AllergyIntolerance-4b343429-16da-4a5b-be80-17e4122f5956.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/cz-allergyIntolerance-szz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-cz-allergyIntolerance-szz.csv), [Excel](StructureDefinition-cz-allergyIntolerance-szz.xlsx), [Schematron](StructureDefinition-cz-allergyIntolerance-szz.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "cz-allergyIntolerance-szz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-allergyIntolerance-szz",
  "version" : "0.0.1",
  "name" : "CZ_AllergyIntoleranceSzz",
  "title" : "Allergy intolerance (SZZ CZ)",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Czech profile for allergy intolerance. ",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "AllergyIntolerance",
  "baseDefinition" : "https://hl7.cz/fhir/core/StructureDefinition/cz-allergyIntolerance",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "AllergyIntolerance",
        "path" : "AllergyIntolerance"
      },
      {
        "id" : "AllergyIntolerance.type",
        "path" : "AllergyIntolerance.type",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-allergy-intolerance-type-szz-vs"
        }
      },
      {
        "id" : "AllergyIntolerance.category",
        "path" : "AllergyIntolerance.category",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/allergy-intolerance-category-cz"
        }
      },
      {
        "id" : "AllergyIntolerance.criticality",
        "path" : "AllergyIntolerance.criticality",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/allergy-intolerance-criticality-cz"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.manifestation",
        "path" : "AllergyIntolerance.reaction.manifestation",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-allergy-reaction-category-szz-vs"
        }
      },
      {
        "id" : "AllergyIntolerance.reaction.severity",
        "path" : "AllergyIntolerance.reaction.severity",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-clinical-severity-of-symptoms-szz-vs"
        }
      }
    ]
  }
}

```
