# A.3.7 - Urology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.7 - Urology**

## Logical Model: A.3.7 - Urology 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/UrologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnUrologyCz |

 
Shared Health Record - Screening examination by urologist. 

**Usages:**

* Use this Logical Model: [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/UrologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-UrologyCz.csv), [Excel](StructureDefinition-UrologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "UrologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/UrologyCz",
  "version" : "0.0.1",
  "name" : "LogEnUrologyCz",
  "title" : "A.3.7 - Urology",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Screening examination by urologist.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/UrologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "UrologyCz",
        "path" : "UrologyCz",
        "short" : "A.3.7 - Urology",
        "definition" : "Shared Health Record - Screening examination by urologist."
      },
      {
        "id" : "UrologyCz.prostateCancerScreening",
        "path" : "UrologyCz.prostateCancerScreening",
        "short" : "A.3.7.1 - Result of initial PSA test as part of early detection of prostate cancer",
        "definition" : "A.3.7.1 - Result of initial PSA test as part of early detection of prostate cancer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "UrologyCz.prostateCancerScreening.resultDate",
        "path" : "UrologyCz.prostateCancerScreening.resultDate",
        "short" : "A.3.7.1.1 - Date of PSA screening result",
        "definition" : "Date on which the patient underwent PSA screening (initial PSA sampling as part of the screening episode).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "UrologyCz.prostateCancerScreening.levelPSA",
        "path" : "UrologyCz.prostateCancerScreening.levelPSA",
        "short" : "A.3.7.1.2 - Screening PSA level",
        "definition" : "Screening PSA value in  UG/L (initial PSA test value as part of the screening episode).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupUrologicalExamination",
        "path" : "UrologyCz.followupUrologicalExamination",
        "short" : "A.3.7.2 - Result of follow-up urological examinations as part of early detection of prostate cancer",
        "definition" : "A.3.7.2 - Result of follow-up urological examinations as part of early detection of prostate cancer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupUrologicalExamination.resultDate",
        "path" : "UrologyCz.followupUrologicalExamination.resultDate",
        "short" : "A.3.7.2.1 - Date of examination result",
        "definition" : "Date on which the examination was performed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupUrologicalExamination.examinationResult",
        "path" : "UrologyCz.followupUrologicalExamination.examinationResult",
        "short" : "A.3.7.2.2 - Result of clinical examination",
        "definition" : "Result of the clinical examination performed (per rectum and any other examinations).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupUrologicalExamination.levelPSA",
        "path" : "UrologyCz.followupUrologicalExamination.levelPSA",
        "short" : "A.3.7.2.3 - PSA level",
        "definition" : "The value of the follow-up PSA in  UG/L (PSA sample value).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupUrologicalExamination.prostateVolume",
        "path" : "UrologyCz.followupUrologicalExamination.prostateVolume",
        "short" : "A.3.7.2.4 - Prostate volume",
        "definition" : "Prostate volume from imaging examinations.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupUrologicalExamination.densityPSA",
        "path" : "UrologyCz.followupUrologicalExamination.densityPSA",
        "short" : "A.3.7.2.5 - Determination of PSA density (PSAD)",
        "definition" : "PSA density.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupUrologicalExamination.velocityPSA",
        "path" : "UrologyCz.followupUrologicalExamination.velocityPSA",
        "short" : "A.3.7.2.6 - Determination of PSA velocity (PSAV)",
        "definition" : "PSA velocity (ng/mL/year). PSAV is not performed if only one PSA result is available.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Quantity"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupUrologicalExamination.furtherProcedure",
        "path" : "UrologyCz.followupUrologicalExamination.furtherProcedure",
        "short" : "A.3.7.2.7 - Examination result: Further recommended examinations",
        "definition" : "Final evaluation of results by a physician.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupBiopsy",
        "path" : "UrologyCz.followupBiopsy",
        "short" : "A.3.7.3 - Result of follow-up biopsy  as part of early detection of prostate cancer",
        "definition" : "A.3.7.3 - Result of follow-up biopsy  as part of early detection of prostate cancer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupBiopsy.resultDate",
        "path" : "UrologyCz.followupBiopsy.resultDate",
        "short" : "A.3.7.3.1 - Date of biopsy examination result",
        "definition" : "Date of prostate biopsy performed at an accredited facility.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupBiopsy.biopsyType",
        "path" : "UrologyCz.followupBiopsy.biopsyType",
        "short" : "A.3.7.3.2 - Type of biopsy performed",
        "definition" : "Type of prostate biopsy performed.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "UrologyCz.followupBiopsy.examinationResult",
        "path" : "UrologyCz.followupBiopsy.examinationResult",
        "short" : "A.3.7.3.3 - Biopsy examination result",
        "definition" : "Result of the biopsy examination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
