# A - Shared Health Record - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Shared Health Record**

## Logical Model: A - Shared Health Record 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/SzzCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnSzzCz |

 
Logical model of the Shared Health Record according to Czech specifications. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/SzzCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SzzCz.csv), [Excel](StructureDefinition-SzzCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SzzCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/SzzCz",
  "version" : "0.0.1",
  "name" : "LogEnSzzCz",
  "title" : "A - Shared Health Record",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Logical model of the Shared Health Record according to Czech specifications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/SzzCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SzzCz",
        "path" : "SzzCz",
        "short" : "A - Shared Health Record",
        "definition" : "Logical model of the Shared Health Record according to Czech specifications."
      },
      {
        "id" : "SzzCz.header",
        "path" : "SzzCz.header",
        "short" : "A.1 - Document header",
        "definition" : "Header of the shared health record according to Czech specifications",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/HeaderSzzCz"
          }
        ]
      },
      {
        "id" : "SzzCz.body",
        "path" : "SzzCz.body",
        "short" : "Document body",
        "definition" : "The body contains preventive/screening record.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SzzCz.body.emergencyRecord",
        "path" : "SzzCz.body.emergencyRecord",
        "short" : "A.2 - Emergency health record",
        "definition" : "Emergency health record",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/EmergencyRecordCz"
          }
        ]
      },
      {
        "id" : "SzzCz.body.preventiveAndScreeningRecord",
        "path" : "SzzCz.body.preventiveAndScreeningRecord",
        "short" : "A.3 - Preventive and screening health record",
        "definition" : "Preventive and screening health record",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz"
          }
        ]
      }
    ]
  }
}

```
