# A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject**

## Logical Model: A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/SubjectCz | *Version*:0.0.1 | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:LogEnSubjectCz |

 
Shared Health Record - subject data element 

**Usages:**

* Use this Logical Model: [A.1 - Document header](StructureDefinition-HeaderSzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/SubjectCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-SubjectCz.csv), [Excel](StructureDefinition-SubjectCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "SubjectCz",
  "language" : "cs",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/SubjectCz",
  "version" : "0.0.1",
  "name" : "LogEnSubjectCz",
  "title" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - subject data element",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/SubjectCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "SubjectCz",
        "path" : "SubjectCz",
        "short" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "definition" : "Shared Health Record - subject data element"
      },
      {
        "id" : "SubjectCz.subjectIdentification",
        "path" : "SubjectCz.subjectIdentification",
        "short" : "A.1.1 - Identification of the patient/subject",
        "definition" : "Identification of the patient/subject",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectIdentification.given",
        "path" : "SubjectCz.subjectIdentification.given",
        "short" : "A.1.1.1 - Given name",
        "definition" : "The given name/first name of the patient (also known as forename or first name). This field can contain more than one element.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectIdentification.family",
        "path" : "SubjectCz.subjectIdentification.family",
        "short" : "A.1.1.2 - Family name/surname",
        "definition" : "The family name/surname/last name of the patient. This field can contain more than one element or multiple fields could be present.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectIdentification.birthDate",
        "path" : "SubjectCz.subjectIdentification.birthDate",
        "short" : "A.1.1.3 - Date of birth",
        "definition" : "Complete date, following the ISO 8601.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectIdentification.identifier",
        "path" : "SubjectCz.subjectIdentification.identifier",
        "short" : "A.1.1.4 - National healthcare patient ID",
        "definition" : "An identifier of the patient that is unique within a defined scope. Example: National ID (birth number) for a Czech patient. Multiple identifiers could be provided",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectIdentification.nationality",
        "path" : "SubjectCz.subjectIdentification.nationality",
        "short" : "A.1.1.5 - Nationality",
        "definition" : "Nationality of the patient.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectIdentification.gender",
        "path" : "SubjectCz.subjectIdentification.gender",
        "short" : "A.1.1.6 - Gender",
        "definition" : "This field must contain a recognised valid value for administrative gender. If different, physiological gender should be communicated elsewhere in the relevant clinical information section.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectIdentification.communicationLanguage",
        "path" : "SubjectCz.subjectIdentification.communicationLanguage",
        "short" : "A.1.1.7 - Communication language",
        "definition" : "Language(s) in which the patient communicates",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact",
        "path" : "SubjectCz.subjectContact",
        "short" : "A.1.2 - Patient/subject related contact information",
        "definition" : "Patient/subject related contact information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.address",
        "path" : "SubjectCz.subjectContact.address",
        "short" : "A.1.2.1 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.telecom",
        "path" : "SubjectCz.subjectContact.telecom",
        "short" : "A.1.2.2 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.preferredHP",
        "path" : "SubjectCz.subjectContact.preferredHP",
        "short" : "A.1.2.3 - Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).",
        "definition" : "Preferred health professional (HP) - This section can be repeated and linked to any specific information in the document, for example a link between a rare disease problem and the rare disease specialist responsible for the care of the individual patient (this section).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.preferredHP.identifier",
        "path" : "SubjectCz.subjectContact.preferredHP.identifier",
        "short" : "A.1.2.3.1 - Identifier of the HP",
        "definition" : "An identifier of the health professional that is unique within a defined scope. Example: National health professional ID. Multiple identifiers could be provided.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.preferredHP.name",
        "path" : "SubjectCz.subjectContact.preferredHP.name",
        "short" : "A.1.2.3.2 - Name of the HP",
        "definition" : "Name of the health professional that has been treating or taking responsibility for the patient.[the structure of the name will be the same as for the patient (given name, family name / surname)]",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.preferredHP.role",
        "path" : "SubjectCz.subjectContact.preferredHP.role",
        "short" : "A.1.2.3.3 - Role of the HP",
        "definition" : "Health professional role. Multiple roles could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.preferredHP.organization",
        "path" : "SubjectCz.subjectContact.preferredHP.organization",
        "short" : "A.1.2.3.4 - HP Organisation",
        "definition" : "Health professional organisation",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.preferredHP.address",
        "path" : "SubjectCz.subjectContact.preferredHP.address",
        "short" : "A.1.2.3.5 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.preferredHP.telecom",
        "path" : "SubjectCz.subjectContact.preferredHP.telecom",
        "short" : "A.1.2.3.6 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.contactPerson",
        "path" : "SubjectCz.subjectContact.contactPerson",
        "short" : "A.1.2.4 - Contact person/ legal guardian (multiple contacts could be provided)",
        "definition" : "Contact person/ legal guardian (multiple contacts could be provided)",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.contactPerson.type",
        "path" : "SubjectCz.subjectContact.contactPerson.type",
        "short" : "A.1.2.4.1 - Type of contact",
        "definition" : "Type of contact",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.contactPerson.relationship",
        "path" : "SubjectCz.subjectContact.contactPerson.relationship",
        "short" : "A.1.2.4.2 - Relationship level",
        "definition" : "Relationship type with the patient (e.g. father, wife, daughter)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.contactPerson.identifier",
        "path" : "SubjectCz.subjectContact.contactPerson.identifier",
        "short" : "A.1.2.4.3 - Identifier",
        "definition" : "Identifier of the contact person/guardian . This field can contain more than one element.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.contactPerson.given",
        "path" : "SubjectCz.subjectContact.contactPerson.given",
        "short" : "A.1.2.4.4 - Given name",
        "definition" : "Given name of the contact person/guardian . This field can contain more than one element.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.contactPerson.family",
        "path" : "SubjectCz.subjectContact.contactPerson.family",
        "short" : "A.1.2.4.5 - Family name/surname",
        "definition" : "The family name/surname/last name of the contact person/guardian . This field can contain more than one element.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.contactPerson.address",
        "path" : "SubjectCz.subjectContact.contactPerson.address",
        "short" : "A.1.2.4.6 - Address",
        "definition" : "Mailing, home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "SubjectCz.subjectContact.contactPerson.telecom",
        "path" : "SubjectCz.subjectContact.contactPerson.telecom",
        "short" : "A.1.2.4.7 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated with a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      }
    ]
  }
}

```
