# A.3.6 - Pulmonology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.6 - Pulmonology**

## Logical Model: A.3.6 - Pulmonology 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/PulmonologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnPulmonologyCz |

 
Shared Health Record - Screening examination by pulmonologist 

**Usages:**

* Use this Logical Model: [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/PulmonologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-PulmonologyCz.csv), [Excel](StructureDefinition-PulmonologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "PulmonologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/PulmonologyCz",
  "version" : "0.0.1",
  "name" : "LogEnPulmonologyCz",
  "title" : "A.3.6 - Pulmonology",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Screening examination by pulmonologist",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/PulmonologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "PulmonologyCz",
        "path" : "PulmonologyCz",
        "short" : "A.3.6 - Pulmonology",
        "definition" : "Shared Health Record - Screening examination by pulmonologist"
      },
      {
        "id" : "PulmonologyCz.lungExamination",
        "path" : "PulmonologyCz.lungExamination",
        "short" : "A.3.6.1 - Result of examination as part of early detection of lung cancer",
        "definition" : "A.3.6.1 - Result of examination as part of early detection of lung cancer",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.dateOfResult",
        "path" : "PulmonologyCz.lungExamination.dateOfResult",
        "short" : "A.3.6.1.1 - Date of pulmonary examination result",
        "definition" : "Date of pulmonary examination performed as part of the lung cancer early detection program",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.smoker",
        "path" : "PulmonologyCz.lungExamination.smoker",
        "short" : "A.3.6.1.2 - Smoking (medical history)",
        "definition" : "Current smoking history.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.numberOfYearsSinceQuitting",
        "path" : "PulmonologyCz.lungExamination.numberOfYearsSinceQuitting",
        "short" : "A.3.6.1.3 - Number of years since quitting smoking",
        "definition" : "How many years ago did the patient quit smoking.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.numberOfYearsSmoking",
        "path" : "PulmonologyCz.lungExamination.numberOfYearsSmoking",
        "short" : "A.3.6.1.4 - Number of years smoking",
        "definition" : "How many years the patient has been/was smoking.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.numberOfPackYears",
        "path" : "PulmonologyCz.lungExamination.numberOfPackYears",
        "short" : "A.3.6.1.5 - Number of pack-years",
        "definition" : "Pack-years = (Number of cigarettes per day ÷ 20) × number of years smoked. One pack-year means smoking one pack per day for one year (or 2 packs per day for half a year, or half a pack per day for 2 years, etc.)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.physicalExamination",
        "path" : "PulmonologyCz.lungExamination.physicalExamination",
        "short" : "A.3.6.1.6 - Physical examination result",
        "definition" : "Physical examination result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.resultXRay",
        "path" : "PulmonologyCz.lungExamination.resultXRay",
        "short" : "A.3.6.1.7 - Lung X-ray result",
        "definition" : "Lung (chest) X-ray result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.functionalExamination",
        "path" : "PulmonologyCz.lungExamination.functionalExamination",
        "short" : "A.3.6.1.8 - Functional examination result",
        "definition" : "Functional examination result.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "PulmonologyCz.lungExamination.recommendationLDCT",
        "path" : "PulmonologyCz.lungExamination.recommendationLDCT",
        "short" : "A.3.6.1.9 - Examination result: Recommendation for LDCT lung screening",
        "definition" : "Final evaluation of results by physician",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
