# A - Sdílený zdravotní záznam - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A - Sdílený zdravotní záznam**

## Logical Model: A - Sdílený zdravotní záznam 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogSzzCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzSzzCz |

 
Logický model Sdíleného zdravotního záznamu podle české specifikace. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogSzzCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogSzzCz.csv), [Excel](StructureDefinition-LogSzzCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogSzzCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogSzzCz",
  "version" : "0.0.1",
  "name" : "LogCzSzzCz",
  "title" : "A - Sdílený zdravotní záznam",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Logický model Sdíleného zdravotního záznamu podle české specifikace.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogSzzCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogSzzCz",
        "path" : "LogSzzCz",
        "short" : "A - Sdílený zdravotní záznam",
        "definition" : "Logický model Sdíleného zdravotního záznamu podle české specifikace."
      },
      {
        "id" : "LogSzzCz.hlavicka",
        "path" : "LogSzzCz.hlavicka",
        "short" : "A.1 - Hlavička dokumentu",
        "definition" : "Hlavička sdíleného zdravotního záznamu podle české specifikace",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogHeaderSzzCz"
          }
        ]
      },
      {
        "id" : "LogSzzCz.telo",
        "path" : "LogSzzCz.telo",
        "short" : "Tělo dokumentu",
        "definition" : "Tělo obsahuje emergentní záznam a preventivní/screeningový záznam.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogSzzCz.telo.emergentniZZ",
        "path" : "LogSzzCz.telo.emergentniZZ",
        "short" : "A.2 - Emergentní zdravotní záznam",
        "definition" : "Emergentní zdravotní záznam",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogEmergencyRecordCz"
          }
        ]
      },
      {
        "id" : "LogSzzCz.telo.preventivniAscreeningovyZZ",
        "path" : "LogSzzCz.telo.preventivniAscreeningovyZZ",
        "short" : "A.3 - Preventivní a screeningový zdravotní záznam",
        "definition" : "Preventivní a screeningový zdravotní záznam",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogPreventiveAndScreeningRecordCz"
          }
        ]
      }
    ]
  }
}

```
