# A.3.4 - Radiologie - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.4 - Radiologie**

## Logical Model: A.3.4 - Radiologie 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogRadiologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzRadiologyCz |

 
Sdílený zdravotní záznam - Screeningové vyšetření radiologem. 

**Usages:**

* Use this Logical Model: [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogRadiologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogRadiologyCz.csv), [Excel](StructureDefinition-LogRadiologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogRadiologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogRadiologyCz",
  "version" : "0.0.1",
  "name" : "LogCzRadiologyCz",
  "title" : "A.3.4 - Radiologie",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Screeningové vyšetření radiologem.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogRadiologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogRadiologyCz",
        "path" : "LogRadiologyCz",
        "short" : "A.3.4 - Radiologie",
        "definition" : "Sdílený zdravotní záznam - Screeningové vyšetření radiologem."
      },
      {
        "id" : "LogRadiologyCz.mamografickeVysetreni",
        "path" : "LogRadiologyCz.mamografickeVysetreni",
        "short" : "A.3.4.1 - Výsledek mamografického vyšetření v rámci screeningu karcinomu prsu",
        "definition" : "A.3.4.1 - Výsledek mamografického vyšetření v rámci screeningu karcinomu prsu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.mamografickeVysetreni.datumVysledku",
        "path" : "LogRadiologyCz.mamografickeVysetreni.datumVysledku",
        "short" : "A.3.4.1.1 - Datum výsledku mamografického vyšetření",
        "definition" : "Datum provedení mamografie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.mamografickeVysetreni.denzitaTkane",
        "path" : "LogRadiologyCz.mamografickeVysetreni.denzitaTkane",
        "short" : "A.3.4.1.2 - Denzita prsní tkáně dle klasifikace BIRADS/ Tabár",
        "definition" : "Denzita prsní tkáně pacientky.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.mamografickeVysetreni.vysledekVysetreni",
        "path" : "LogRadiologyCz.mamografickeVysetreni.vysledekVysetreni",
        "short" : "A.3.4.1.3 - Výsledek mamografie",
        "definition" : "Výsledek mamografie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysledekBiopsiePrsu",
        "path" : "LogRadiologyCz.vysledekBiopsiePrsu",
        "short" : "A.3.4.2 - Výsledek biopsie v rámci screeningu karcinomu prsu",
        "definition" : "A.3.4.2 - Výsledek biopsie v rámci screeningu karcinomu prsu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysledekBiopsiePrsu.datumVysledku",
        "path" : "LogRadiologyCz.vysledekBiopsiePrsu.datumVysledku",
        "short" : "A.3.4.2.1 - Datum výsledku biopsie",
        "definition" : "Datum provedení biopsie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysledekBiopsiePrsu.typBiopsie",
        "path" : "LogRadiologyCz.vysledekBiopsiePrsu.typBiopsie",
        "short" : "A.3.4.2.2 - Typ biopsie",
        "definition" : "Typ provedené biopsie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysledekBiopsiePrsu.vysledekBiopsie",
        "path" : "LogRadiologyCz.vysledekBiopsiePrsu.vysledekBiopsie",
        "short" : "A.3.4.2.3 - Výsledek biopsie",
        "definition" : "Výsledek provedené biopsie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniPlic",
        "path" : "LogRadiologyCz.vysetreniPlic",
        "short" : "A.3.4.3 - Výsledek vyšetření v rámci časného záchytu karcinomu plic",
        "definition" : "A.3.4.3 - Výsledek vyšetření v rámci časného záchytu karcinomu plic",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniPlic.datumVysledku",
        "path" : "LogRadiologyCz.vysetreniPlic.datumVysledku",
        "short" : "A.3.4.3.1 - Datum výsledku provedeného LDCT",
        "definition" : "Datum provedení LDCT",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniPlic.typVysetreni",
        "path" : "LogRadiologyCz.vysetreniPlic.typVysetreni",
        "short" : "A.3.4.3.2 - Typ LDCT vyšetření",
        "definition" : "Pacientovi je prováděno vstupní vyšetření, kontrolní vyšetření v řádném termínu, nebo kontrolní po neurčitém výsledku.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniPlic.vysledekVysetreni",
        "path" : "LogRadiologyCz.vysetreniPlic.vysledekVysetreni",
        "short" : "A.3.4.3.3 - Výsledek LDCT",
        "definition" : "Výsledek screeningového LDCT.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniPlic.dpoporucenyPostup",
        "path" : "LogRadiologyCz.vysetreniPlic.dpoporucenyPostup",
        "short" : "A.3.4.3.4 - Výsledek vyšetření LDCT: Další doporučené vyšetření",
        "definition" : "Závěrečné zhodnocení výsledků lékařem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniProstaty",
        "path" : "LogRadiologyCz.vysetreniProstaty",
        "short" : "A.3.4.4 - Výsledek vyšetření v rámci časného záchytu karcinomu prostaty",
        "definition" : "A.3.4.4 - Výsledek vyšetření v rámci časného záchytu karcinomu prostaty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniProstaty.datumVysledku",
        "path" : "LogRadiologyCz.vysetreniProstaty.datumVysledku",
        "short" : "A.3.4.4.1 - Datum výsledku MRI",
        "definition" : "Datum provedení MRI",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniProstaty.typVysetreni",
        "path" : "LogRadiologyCz.vysetreniProstaty.typVysetreni",
        "short" : "A.3.4.4.2 - Typ MRI vyšetření",
        "definition" : "Pacientovi je prováděno MRI bez kontrastní látky, nebo MRI s kontrastní látkou.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniProstaty.vysledekVysetreni",
        "path" : "LogRadiologyCz.vysetreniProstaty.vysledekVysetreni",
        "short" : "A.3.4.4.3 - Výsledek provedené MRI (PI-RADS)",
        "definition" : "Výsledek provedené MRI dle systému PI-RADS (hodnotící skóre).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniProstaty.nalezPIRADS3",
        "path" : "LogRadiologyCz.vysetreniProstaty.nalezPIRADS3",
        "short" : "A.3.4.4.4 - Nález v případě PI-RADS 3",
        "definition" : "Zóna nálezu v případě PI-RADS 3.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniAneurismatuAbnormalniAorty",
        "path" : "LogRadiologyCz.vysetreniAneurismatuAbnormalniAorty",
        "short" : "A.3.4.5 - Výsledek vyšetření v rámci screeningu aneurysmatu abdominální aorty",
        "definition" : "A.3.4.5 - Výsledek vyšetření v rámci screeningu aneurysmatu abdominální aorty",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniAneurismatuAbnormalniAorty.datumVysledku",
        "path" : "LogRadiologyCz.vysetreniAneurismatuAbnormalniAorty.datumVysledku",
        "short" : "A.3.4.5.1 - Datum výsledku USG vyšetření",
        "definition" : "Datum, kdy je pacientovi provedeno screeningové ultrasonografické vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogRadiologyCz.vysetreniAneurismatuAbnormalniAorty.vysledekVysetreni",
        "path" : "LogRadiologyCz.vysetreniAneurismatuAbnormalniAorty.vysledekVysetreni",
        "short" : "A.3.4.5.2 - Výsledek USG vyšetření",
        "definition" : "Výsledek screeningového ultrasonografického vyšetření.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
