# A.3 - Preventivní a screeningový zdravotní záznam - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3 - Preventivní a screeningový zdravotní záznam**

## Logical Model: A.3 - Preventivní a screeningový zdravotní záznam 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogPreventiveAndScreeningRecordCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzPreventiveAndScreeningRecordCz |

 
Sdílený zdravotní záznam - Logický model pro Preventivní a screeningový zdravotní záznam 

**Usages:**

* Use this Logical Model: [A - Sdílený zdravotní záznam](StructureDefinition-LogSzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogPreventiveAndScreeningRecordCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogPreventiveAndScreeningRecordCz.csv), [Excel](StructureDefinition-LogPreventiveAndScreeningRecordCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogPreventiveAndScreeningRecordCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogPreventiveAndScreeningRecordCz",
  "version" : "0.0.1",
  "name" : "LogCzPreventiveAndScreeningRecordCz",
  "title" : "A.3 - Preventivní a screeningový zdravotní záznam",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Logický model pro Preventivní a screeningový zdravotní záznam",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogPreventiveAndScreeningRecordCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogPreventiveAndScreeningRecordCz",
        "path" : "LogPreventiveAndScreeningRecordCz",
        "short" : "A.3 - Preventivní a screeningový zdravotní záznam",
        "definition" : "Sdílený zdravotní záznam - Logický model pro Preventivní a screeningový zdravotní záznam"
      },
      {
        "id" : "LogPreventiveAndScreeningRecordCz.praktickyLekar",
        "path" : "LogPreventiveAndScreeningRecordCz.praktickyLekar",
        "short" : "A.3.1 - Praktický lékař",
        "definition" : "A.3.1 - Praktický lékař",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/logGeneralPractitionerCz"
          }
        ]
      },
      {
        "id" : "LogPreventiveAndScreeningRecordCz.gynekologie",
        "path" : "LogPreventiveAndScreeningRecordCz.gynekologie",
        "short" : "A.3.2 - Gynekologie",
        "definition" : "A.3.2 - Gynekologie",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/logGynecologyCz"
          }
        ]
      },
      {
        "id" : "LogPreventiveAndScreeningRecordCz.gastroenterologie",
        "path" : "LogPreventiveAndScreeningRecordCz.gastroenterologie",
        "short" : "A.3.3 - Gatroenterologie",
        "definition" : "A.3.3 - Gatroenterologie",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/logGastroenterologyCz"
          }
        ]
      },
      {
        "id" : "LogPreventiveAndScreeningRecordCz.radiologie",
        "path" : "LogPreventiveAndScreeningRecordCz.radiologie",
        "short" : "A.3.4 - Radiologie",
        "definition" : "A.3.4 - Radiologie",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogRadiologyCz"
          }
        ]
      },
      {
        "id" : "LogPreventiveAndScreeningRecordCz.laboratorBiochemie",
        "path" : "LogPreventiveAndScreeningRecordCz.laboratorBiochemie",
        "short" : "A.3.5 - Laboratoř biochemie",
        "definition" : "A.3.5 - Laboratoř biochemie",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogBiochemistryLabCz"
          }
        ]
      },
      {
        "id" : "LogPreventiveAndScreeningRecordCz.pneumologie",
        "path" : "LogPreventiveAndScreeningRecordCz.pneumologie",
        "short" : "A.3.6 - Pneumologie",
        "definition" : "A.3.6 - Pneumologie",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogPulmonologyCz"
          }
        ]
      },
      {
        "id" : "LogPreventiveAndScreeningRecordCz.urologie",
        "path" : "LogPreventiveAndScreeningRecordCz.urologie",
        "short" : "A.3.7 - Urologie",
        "definition" : "A.3.7 - Urologie",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogUrologyCz"
          }
        ]
      },
      {
        "id" : "LogPreventiveAndScreeningRecordCz.angiologie",
        "path" : "LogPreventiveAndScreeningRecordCz.angiologie",
        "short" : "A.3.8 - Angiologie",
        "definition" : "A.3.8 - Angiologie",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogAngiologyCz"
          }
        ]
      }
    ]
  }
}

```
