# A.1 - Hlavička dokumentu - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 - Hlavička dokumentu**

## Logical Model: A.1 - Hlavička dokumentu 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogHeaderSzzCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzHeaderSzzCz |

 
Hlavička sdíleného zdravotního záznamu podle české specifikace. 

**Usages:**

* Use this Logical Model: [A - Sdílený zdravotní záznam](StructureDefinition-LogSzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogHeaderSzzCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogHeaderSzzCz.csv), [Excel](StructureDefinition-LogHeaderSzzCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogHeaderSzzCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogHeaderSzzCz",
  "version" : "0.0.1",
  "name" : "LogCzHeaderSzzCz",
  "title" : "A.1 - Hlavička dokumentu",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Hlavička sdíleného zdravotního záznamu podle české specifikace.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogHeaderSzzCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogHeaderSzzCz",
        "path" : "LogHeaderSzzCz",
        "short" : "A.1 - Hlavička dokumentu",
        "definition" : "Hlavička sdíleného zdravotního záznamu podle české specifikace."
      },
      {
        "id" : "LogHeaderSzzCz.subjekt",
        "path" : "LogHeaderSzzCz.subjekt",
        "short" : "A.1.1 - Identifikace a A.1.2 - Kontaktní informace pacienta",
        "definition" : "Identifikace pacienta a kontaktní informace pacienta",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/LogSubjectCz"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.pojistovna",
        "path" : "LogHeaderSzzCz.pojistovna",
        "short" : "A.1.3 Zdravotní pojištění",
        "definition" : "Informace o pojištění pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.pojistovna.kodPojistovny",
        "path" : "LogHeaderSzzCz.pojistovna.kodPojistovny",
        "short" : "A.1.3.1 Kód zdravotní pojišťovny",
        "definition" : "Kód zdravotní pojišťovny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.pojistovna.nazev",
        "path" : "LogHeaderSzzCz.pojistovna.nazev",
        "short" : "A.1.3.2 Název zdravotní pojišťovny",
        "definition" : "Oficiální název pojišťovny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.pojistovna.cisloPojistence",
        "path" : "LogHeaderSzzCz.pojistovna.cisloPojistence",
        "short" : "A.1.3.3 Číslo zdravotního pojištění",
        "definition" : "Číslo pojištěnce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.prijemce",
        "path" : "LogHeaderSzzCz.prijemce",
        "short" : "A.1.4 Příjemce dokumentu",
        "definition" : "Zamýšlený příjemce sdíleného zdravotního záznamu.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.prijemce.idPrijemce",
        "path" : "LogHeaderSzzCz.prijemce.idPrijemce",
        "short" : "A.1.4.1 ID příjemce",
        "definition" : "Identifikační číslo zdravotnického pracovníka nebo osobní identifikátor pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.prijemce.jmeno",
        "path" : "LogHeaderSzzCz.prijemce.jmeno",
        "short" : "A.1.4.2 Jméno příjemce",
        "definition" : "Jméno a příjmení osoby příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.prijemce.idOrganizace",
        "path" : "LogHeaderSzzCz.prijemce.idOrganizace",
        "short" : "A.1.4.3 ID organizace příjemce",
        "definition" : "Identifikátor organizace příjemce (např. NRPZS, IČO).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.prijemce.organizace",
        "path" : "LogHeaderSzzCz.prijemce.organizace",
        "short" : "A.1.4.4 Organizace příjemce",
        "definition" : "Název a identifikační údaje zařízení nebo pracoviště příjemce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.autor",
        "path" : "LogHeaderSzzCz.autor",
        "short" : "A.1.5 Autor dokumentu",
        "definition" : "Osoba nebo systém, který dokument vytvořil.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.autor.idAutor",
        "path" : "LogHeaderSzzCz.autor.idAutor",
        "short" : "A.1.5.1 Identifikátor autora",
        "definition" : "Identifikační číslo autora (zdravotnický pracovník nebo IS).",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.autor.jmeno",
        "path" : "LogHeaderSzzCz.autor.jmeno",
        "short" : "A.1.5.2 Jméno autora",
        "definition" : "Jméno osoby nebo systému, který dokument sestavil.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.autor.idOrganizace",
        "path" : "LogHeaderSzzCz.autor.idOrganizace",
        "short" : "A.1.5.3 ID organizace",
        "definition" : "Identifikátor organizace, kterou autor reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.autor.organizace",
        "path" : "LogHeaderSzzCz.autor.organizace",
        "short" : "A.1.5.4 Organizace autora",
        "definition" : "Název organizace, kterou autor reprezentuje.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.autor.datum",
        "path" : "LogHeaderSzzCz.autor.datum",
        "short" : "A.1.5.5 Datum a čas uložení",
        "definition" : "Datum a čas poslední modifikace dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata",
        "path" : "LogHeaderSzzCz.metadata",
        "short" : "A.1.6 Metadata dokumentu",
        "definition" : "Technická metadata dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.dokumentId",
        "path" : "LogHeaderSzzCz.metadata.dokumentId",
        "short" : "A.1.6.1 ID dokumentu",
        "definition" : "Jedinečný identifikátor dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.kategorie",
        "path" : "LogHeaderSzzCz.metadata.kategorie",
        "short" : "A.1.6.2 Kategorie dokumentu",
        "definition" : "Kategorie EHR.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.stav",
        "path" : "LogHeaderSzzCz.metadata.stav",
        "short" : "A.1.6.3 Stav dokumentu",
        "definition" : "Stav dokumentu – předběžný, finální apod.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.vytvoreni",
        "path" : "LogHeaderSzzCz.metadata.vytvoreni",
        "short" : "A.1.6.4 Datum a čas vytvoření",
        "definition" : "Datum a čas vytvoření dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.nazevDokumentu",
        "path" : "LogHeaderSzzCz.metadata.nazevDokumentu",
        "short" : "A.1.6.5 Název dokumentu",
        "definition" : "Název dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.spravce",
        "path" : "LogHeaderSzzCz.metadata.spravce",
        "short" : "A.1.6.6 Správce dokumentu",
        "definition" : "Technický správce dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.duveryhodnost",
        "path" : "LogHeaderSzzCz.metadata.duveryhodnost",
        "short" : "A.1.6.7 Důvěrnost dokumentu",
        "definition" : "Stupeň důvěrnosti dokumentu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.jazyk",
        "path" : "LogHeaderSzzCz.metadata.jazyk",
        "short" : "A.1.6.8 Jazyk dokumentu",
        "definition" : "Jazyk dokumentu dle ISO kódu.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.metadata.verze",
        "path" : "LogHeaderSzzCz.metadata.verze",
        "short" : "A.1.6.9 Verze",
        "definition" : "Verze dokumentu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "LogHeaderSzzCz.podpis",
        "path" : "LogHeaderSzzCz.podpis",
        "short" : "A.1.7 Elektronické podpisy",
        "definition" : "Elektronické podepsání dokumentu dle zákona.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/logDigitalSignatureCz"
          }
        ]
      }
    ]
  }
}

```
