# A.2 - Emergentní zdravotní záznam - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.2 - Emergentní zdravotní záznam**

## Logical Model: A.2 - Emergentní zdravotní záznam 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/LogEmergencyRecordCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzEmergencyRecordCz |

 
Sdílený zdravotní záznam - Logický model pro Emergentní zdravotní záznam. 

**Usages:**

* Use this Logical Model: [A - Sdílený zdravotní záznam](StructureDefinition-LogSzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/LogEmergencyRecordCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-LogEmergencyRecordCz.csv), [Excel](StructureDefinition-LogEmergencyRecordCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "LogEmergencyRecordCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/LogEmergencyRecordCz",
  "version" : "0.0.1",
  "name" : "LogCzEmergencyRecordCz",
  "title" : "A.2 - Emergentní zdravotní záznam",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Logický model pro Emergentní zdravotní záznam.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/LogEmergencyRecordCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "LogEmergencyRecordCz",
        "path" : "LogEmergencyRecordCz",
        "short" : "A.2 - Emergentní zdravotní záznam",
        "definition" : "Sdílený zdravotní záznam - Logický model pro Emergentní zdravotní záznam."
      },
      {
        "id" : "LogEmergencyRecordCz.krevniSkupina",
        "path" : "LogEmergencyRecordCz.krevniSkupina",
        "short" : "A.2.1 - Krevní skupina",
        "definition" : "Informace o krevní skupině pacienta.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.krevniSkupina.typ",
        "path" : "LogEmergencyRecordCz.krevniSkupina.typ",
        "short" : "A.2.1.1 - Typ krevní skupiny",
        "definition" : "Záznam krevní skupiny pacienta dle systému AB0 (A, B, AB, 0).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.krevniSkupina.rhFaktor",
        "path" : "LogEmergencyRecordCz.krevniSkupina.rhFaktor",
        "short" : "A.2.1.2 - Rh faktor",
        "definition" : "Záznam Rh(D) faktoru.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.krevniSkupina.kodVysetreni",
        "path" : "LogEmergencyRecordCz.krevniSkupina.kodVysetreni",
        "short" : "A.2.1.3 - Kód vyšetření krevní skupiny",
        "definition" : "Kód identifikující typ provedeného vyšetření krevní skupiny.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.krevniSkupina.datumZjisteni",
        "path" : "LogEmergencyRecordCz.krevniSkupina.datumZjisteni",
        "short" : "A.2.1.4 - Datum zjištění krevní skupiny",
        "definition" : "Datum a čas, kdy byl výsledek stanoven.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie",
        "path" : "LogEmergencyRecordCz.alergie",
        "short" : "A.2.2 - Alergie a nežádoucí reakce",
        "definition" : "Záznam alergie či jiné významné nežádoucí reakce na látku nebo léčivý přípravek.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie.latka",
        "path" : "LogEmergencyRecordCz.alergie.latka",
        "short" : "A.2.2.1 - Látka - alergen",
        "definition" : "Identifikace látky, léčivého přípravku nebo jiné substance vyvolávající reakci.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie.kategorieAlergenu",
        "path" : "LogEmergencyRecordCz.alergie.kategorieAlergenu",
        "short" : "A.2.2.2 - Kategorie alergenu",
        "definition" : "Typ alergenu z hlediska původu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie.kryticnost",
        "path" : "LogEmergencyRecordCz.alergie.kryticnost",
        "short" : "A.2.2.3 - Původce",
        "definition" : "Látka, skupina látek nebo faktor prostředí, na které je pacient alergický nebo přecitlivělý. Původce je možné vyjádřit pomocí kódu substance, ATC skupiny nebo kódu produktu SÚKL (v případě léčivých přípravků).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie.typReakce",
        "path" : "LogEmergencyRecordCz.alergie.typReakce",
        "short" : "A.2.2.4 - Typ reakce",
        "definition" : "Informace zda jde o alergii nebo intoleranci.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie.manifestace",
        "path" : "LogEmergencyRecordCz.alergie.manifestace",
        "short" : "A.2.2.5 - Manifestace",
        "definition" : "Klinické projevy reakce.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie.zavaznostReakce",
        "path" : "LogEmergencyRecordCz.alergie.zavaznostReakce",
        "short" : "A.2.2.6 - Klinická závažnost projevu",
        "definition" : "Klinická závažnost projevu.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie.datumZjisteni",
        "path" : "LogEmergencyRecordCz.alergie.datumZjisteni",
        "short" : "A.2.2.7 - Datum zjištění",
        "definition" : "Datum, kdy byla alergie/reakce poprvé diagnostikována (nástup/onset).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.alergie.puvodceZaznamu",
        "path" : "LogEmergencyRecordCz.alergie.puvodceZaznamu",
        "short" : "A.2.2.8 - Původce záznamu",
        "definition" : "Poskytovatel zdravotních služeb, který údaj zaznamenal.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.ostatniEmergentniUdaje",
        "path" : "LogEmergencyRecordCz.ostatniEmergentniUdaje",
        "short" : "A.2.3 - Ostatní emergentní údaje",
        "definition" : "Mezi další údaje patří záznamy o významných nežádoucích příhodách. Typicky jde o nežádoucí účinky léčiv, transfuzní reakce, komplikace při podání krevních derivátů apod.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.ostatniEmergentniUdaje.typUdalosti",
        "path" : "LogEmergencyRecordCz.ostatniEmergentniUdaje.typUdalosti",
        "short" : "A.2.3.1 - Typ události",
        "definition" : "Klasifikace události (např. nežádoucí účinek léčiva, reakce po transfuzi).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.ostatniEmergentniUdaje.podezrelaSubstance",
        "path" : "LogEmergencyRecordCz.ostatniEmergentniUdaje.podezrelaSubstance",
        "short" : "A.2.3.2. - Podezřelá substance",
        "definition" : "Látka, léčivo nebo jiný faktor, který je podezřelý ze způsobení příhody.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.ostatniEmergentniUdaje.datumZjisteni",
        "path" : "LogEmergencyRecordCz.ostatniEmergentniUdaje.datumZjisteni",
        "short" : "A.2.3.3 - Datum zjištění",
        "definition" : "Datum a čas, kdy k nežádoucí příhodě došlo.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.ostatniEmergentniUdaje.puvodceZaznamu",
        "path" : "LogEmergencyRecordCz.ostatniEmergentniUdaje.puvodceZaznamu",
        "short" : "A.2.3.4 - Původce záznamu",
        "definition" : "Poskytovatel zdravotních služeb, který údaj zaznamenal.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.pouziteLecivePripravky",
        "path" : "LogEmergencyRecordCz.pouziteLecivePripravky",
        "short" : "A.2.4 - Léčivé přípravky použité při poskytování zdravotních služeb u poskytovatelů lůžkové péče",
        "definition" : "Léčivé přípravy použité u pacienta při poskytování zdravotních služeb u poskytovatelů lůžkové péče za období posledních 12 měsíců.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.pouziteLecivePripravky.identifikace",
        "path" : "LogEmergencyRecordCz.pouziteLecivePripravky.identifikace",
        "short" : "A.3.4.1 - Identifikace léčivého přípravku",
        "definition" : "Kód léčivého přípravku, který byl pacientovi podán během hospitalizace.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.pouziteLecivePripravky.mnozstvi",
        "path" : "LogEmergencyRecordCz.pouziteLecivePripravky.mnozstvi",
        "short" : "A.3.4.2 - Množství",
        "definition" : "Podané množství léčiva.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.pouziteLecivePripravky.datumPodani",
        "path" : "LogEmergencyRecordCz.pouziteLecivePripravky.datumPodani",
        "short" : "A.2.4.3 - Datum podání",
        "definition" : "Datum a čas, kdy byl lék podán pacientovi v lůžkovém zařízení.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "LogEmergencyRecordCz.pouziteLecivePripravky.zdrojZaznamu",
        "path" : "LogEmergencyRecordCz.pouziteLecivePripravky.zdrojZaznamu",
        "short" : "A.2.4.4 - Zdroj záznamu",
        "definition" : "Poskytovatel, který údaj zaznamenal – lůžkové zařízení.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      }
    ]
  }
}

```
