# A.1 - Document header - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.1 - Document header**

## Logical Model: A.1 - Document header 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/HeaderSzzCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnHeaderSzzCz |

 
Header of the shared health record according to Czech specifications. 

**Usages:**

* Use this Logical Model: [A - Shared Health Record](StructureDefinition-SzzCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/HeaderSzzCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-HeaderSzzCz.csv), [Excel](StructureDefinition-HeaderSzzCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "HeaderSzzCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/HeaderSzzCz",
  "version" : "0.0.1",
  "name" : "LogEnHeaderSzzCz",
  "title" : "A.1 - Document header",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Header of the shared health record according to Czech specifications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/HeaderSzzCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "HeaderSzzCz",
        "path" : "HeaderSzzCz",
        "short" : "A.1 - Document header",
        "definition" : "Header of the shared health record according to Czech specifications."
      },
      {
        "id" : "HeaderSzzCz.subject",
        "path" : "HeaderSzzCz.subject",
        "short" : "A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject",
        "definition" : "Identification of the patient/subject and Patient/subject related contact information",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/SubjectCz"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.payer",
        "path" : "HeaderSzzCz.payer",
        "short" : "A.1.3 - Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "definition" : "Health insurance and payment information - Health insurance information is not always required, however, in some jurisdictions, the insurance number is also used as the patient identifier. It is necessary not just for identification but also forms access to funding for care.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.payer.insuranceCode",
        "path" : "HeaderSzzCz.payer.insuranceCode",
        "short" : "A.1.3.1 - Health insurance code",
        "definition" : "Unique health insurance company identification code.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.payer.insuranceName",
        "path" : "HeaderSzzCz.payer.insuranceName",
        "short" : "A.1.3.2 - Health insurance name",
        "definition" : "Full, official name of the healthcare insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.payer.insuranceNumber",
        "path" : "HeaderSzzCz.payer.insuranceNumber",
        "short" : "A.1.3.3 - Health insurance number",
        "definition" : "Number or code under which the insured person is registered at the insurance provider.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.informationRecipient",
        "path" : "HeaderSzzCz.informationRecipient",
        "short" : "A.1.4 - Information recipient - (intended recipient or recipients of the report), if applicable",
        "definition" : "Information recipient - (intended recipient or recipients of the report), if applicable",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.informationRecipient.identifier",
        "path" : "HeaderSzzCz.informationRecipient.identifier",
        "short" : "A.1.4.1 - Recipient identifier",
        "definition" : "The health professional or patient identifier. Either an internal identifier assigned by a healthcare provider institution or (preferably) a national health professional ID such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier could be used.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.informationRecipient.name",
        "path" : "HeaderSzzCz.informationRecipient.name",
        "short" : "A.1.4.2 - Recipient name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.informationRecipient.organizationID",
        "path" : "HeaderSzzCz.informationRecipient.organizationID",
        "short" : "A.1.4.3 - Recipient organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.informationRecipient.organization",
        "path" : "HeaderSzzCz.informationRecipient.organization",
        "short" : "A.1.4.4 - Recipient organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.informationRecipient.address",
        "path" : "HeaderSzzCz.informationRecipient.address",
        "short" : "A.1.4.5 - Address",
        "definition" : "Mailing and home or office addresses. The addresses are always sequences of address parts (e.g. street address line, country, postcode, city) even if postal address formats may vary depending on the country. An address may or may not include a specific use code; if this attribute is not present it is assumed to be the default address useful for any purpose.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Address"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.informationRecipient.country",
        "path" : "HeaderSzzCz.informationRecipient.country",
        "short" : "A.1.4.6 - Country",
        "definition" : "Country of the intended recipient as part of the address.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.informationRecipient.telecom",
        "path" : "HeaderSzzCz.informationRecipient.telecom",
        "short" : "A.1.4.7 - Telecom",
        "definition" : "Telecommunication contact information (addresses) associated to a person, such as phone number, email, or messaging service. Multiple telecommunication addresses might be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "ContactPoint"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.author",
        "path" : "HeaderSzzCz.author",
        "short" : "A.1.5 - Author (by whom the Shared health record was/were authored). Multiple authors could be provided.",
        "definition" : "Author (by whom the Shared health record was/were authored). Multiple authors could be provided.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.author.identifier",
        "path" : "HeaderSzzCz.author.identifier",
        "short" : "A.1.5.1 - Author identifier",
        "definition" : "The health professional identifier that will allow addressing recipients within a national or international data exchange infrastructure, such as the licence or registration number. In case when the recipient is not a health professional, e.g. patient, appropriate personal identifier should be used.",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.author.name",
        "path" : "HeaderSzzCz.author.name",
        "short" : "A.1.5.2 - Author name",
        "definition" : "Person name [the structure of the name will be the same as for the patient (given name, family name / surname)].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "HumanName"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.author.organizationID",
        "path" : "HeaderSzzCz.author.organizationID",
        "short" : "A.1.5.3 - Author organisation ID",
        "definition" : "The healthcare provider organisation identifier. Identifier that is unique within a defined scope. Example: National healthcare provider ID. Multiple identifiers could be provided.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.author.organization",
        "path" : "HeaderSzzCz.author.organization",
        "short" : "A.1.5.4 - Author organisation",
        "definition" : "The healthcare provider organisation information.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.author.dateTime",
        "path" : "HeaderSzzCz.author.dateTime",
        "short" : "A.1.5.5 - Date Time",
        "definition" : "Date and time of the last modification of the document by its Author.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata",
        "path" : "HeaderSzzCz.documentMetadata",
        "short" : "A.1.6 - Document metadata",
        "definition" : "Document metadata",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.identifier",
        "path" : "HeaderSzzCz.documentMetadata.identifier",
        "short" : "A.1.6.1 - Document ID",
        "definition" : "Unique identifier of the document",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.type",
        "path" : "HeaderSzzCz.documentMetadata.type",
        "short" : "A.1.6.2 - Document type",
        "definition" : "Identifies the type of document at hand, e.g. Shared health record.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.status",
        "path" : "HeaderSzzCz.documentMetadata.status",
        "short" : "A.1.6.3 - Document status",
        "definition" : "The status of the Shared health record report. E.g., preliminary, final.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.dateTime",
        "path" : "HeaderSzzCz.documentMetadata.dateTime",
        "short" : "A.1.6.4 - Report date and time",
        "definition" : "Date and time of the Shared health record creation.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.title",
        "path" : "HeaderSzzCz.documentMetadata.title",
        "short" : "A.1.6.5 - Document title",
        "definition" : "Document title, fix value ''Shared health record''.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.custodian",
        "path" : "HeaderSzzCz.documentMetadata.custodian",
        "short" : "A.1.6.6 - Report custodian",
        "definition" : "Organisation that is in charge of maintaining the report [this element will include organisation ID, name, address etc., as other elements describing organisations].",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.confidentiality",
        "path" : "HeaderSzzCz.documentMetadata.confidentiality",
        "short" : "A.1.6.7 - Confidentiality",
        "definition" : "Level of confidentiality of the document. Implicit value is normal.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.language",
        "path" : "HeaderSzzCz.documentMetadata.language",
        "short" : "A.1.6.8 - Language",
        "definition" : "Language in which the document is written. Language is expressed by the ISO language code.",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.documentMetadata.version",
        "path" : "HeaderSzzCz.documentMetadata.version",
        "short" : "A.1.6.9 - Version",
        "definition" : "Version of the document",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "HeaderSzzCz.digitalSignature",
        "path" : "HeaderSzzCz.digitalSignature",
        "short" : "A.1.7 - Digital signature",
        "definition" : "Digital signature",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "https://hl7.cz/fhir/szz/StructureDefinition/DigitalSignatureCz"
          }
        ]
      }
    ]
  }
}

```
