# A.3.8 - Angiology - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.8 - Angiology**

## Logical Model: A.3.8 - Angiology 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/AngiologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogEnAngiologyCz |

 
Shared Health Record - Screening examination by angiologist 

**Usages:**

* Use this Logical Model: [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/AngiologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-AngiologyCz.csv), [Excel](StructureDefinition-AngiologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "AngiologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/AngiologyCz",
  "version" : "0.0.1",
  "name" : "LogEnAngiologyCz",
  "title" : "A.3.8 - Angiology",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Shared Health Record - Screening examination by angiologist",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/AngiologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "AngiologyCz",
        "path" : "AngiologyCz",
        "short" : "A.3.8 - Angiology",
        "definition" : "Shared Health Record - Screening examination by angiologist"
      },
      {
        "id" : "AngiologyCz.abdominalAorticAneurysmAcreening",
        "path" : "AngiologyCz.abdominalAorticAneurysmAcreening",
        "short" : "A.3.8.1 - Result of abdominal aortic aneurysm screening",
        "definition" : "A.3.8.1 - Result of abdominal aortic aneurysm screening",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "AngiologyCz.abdominalAorticAneurysmAcreening.dateOfResult",
        "path" : "AngiologyCz.abdominalAorticAneurysmAcreening.dateOfResult",
        "short" : "A.3.8.1.1 - Date of ultrasound examination result",
        "definition" : "Date on which the patient underwent screening ultrasound examination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "AngiologyCz.abdominalAorticAneurysmAcreening.examinationResult",
        "path" : "AngiologyCz.abdominalAorticAneurysmAcreening.examinationResult",
        "short" : "A.3.8.1.2 - Ultrasound examination result",
        "definition" : "Result of the screening ultrasound examination.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
