# Patient Králík - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Patient Králík**

## Example Patient: Patient Králík

Profile: [Patient (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-patient-core.html)

Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))

-------

| | |
| :--- | :--- |
| Other Id: | `https://ncez.mzcr.cz/fhir/sid/rid`/2066425387 |
| Contact Detail | Pod Hroudou 8, 190 00 Praha 9 - Prosek(home) |
| Language: | Czech(preferred) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "142534ac-0274-4a16-b6a2-d4d4f24ff67b",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-patient-core"
    ]
  },
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/rid",
      "value" : "2066425387"
    },
    {
      "use" : "official",
      "system" : "https://ncez.mzcr.cz/fhir/sid/cpoj",
      "value" : "0551621110"
    }
  ],
  "name" : [
    {
      "use" : "usual",
      "family" : "Pokusný",
      "given" : ["Králík"],
      "prefix" : ["Mudr., Ing., MBA, Ph.D."]
    }
  ],
  "gender" : "male",
  "birthDate" : "1985-01-12",
  "address" : [
    {
      "use" : "home",
      "type" : "physical",
      "text" : "Pod Hroudou 8, 190 00 Praha 9 - Prosek",
      "line" : ["Pod Hroudou 8"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Pod Hroudou"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "8"
            }
          ]
        }
      ],
      "city" : "Praha",
      "postalCode" : "19000",
      "country" : "CZ",
      "_country" : {
        "extension" : [
          {
            "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-SC-coding",
            "valueCoding" : {
              "system" : "urn:iso:std:iso:3166",
              "code" : "CZ",
              "display" : "Czechia"
            }
          }
        ]
      }
    }
  ],
  "communication" : [
    {
      "language" : {
        "coding" : [
          {
            "system" : "urn:ietf:bcp:47",
            "code" : "cs"
          }
        ]
      },
      "preferred" : true
    }
  ]
}

```
