# cz-example-organization3 - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **cz-example-organization3**

## Example Organization: cz-example-organization3

Profile: [Organization (CZ core)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-organization-core.html)

**Organization Logo**: [DocumentReference: status = current](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-2620c461-29d4-44a7-a8d0-599d88fdb60f)

**identifier**: `https://ncez.mzcr.cz/fhir/sid/ico`/456789655

**type**: Fakultní nemocnice

**name**: Fakultní nemocnice Oblackov

**telecom**: [+420257216007](tel:+420257216007), fax: +420257216007(Work)

**address**: Fiktivní 951/125, 100 00 Město(work)



## Resource Content

```json
{
  "resourceType" : "Organization",
  "id" : "08f3f0c5-69ac-45c6-9bec-b8ab940ec721",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-core"
    ]
  },
  "extension" : [
    {
      "url" : "https://hl7.cz/fhir/core/StructureDefinition/cz-organization-logo",
      "valueReference" : {
        "reference" : "urn:uuid:2620c461-29d4-44a7-a8d0-599d88fdb60f"
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://ncez.mzcr.cz/fhir/sid/ico",
      "value" : "456789655"
    }
  ],
  "type" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/cz-drzar",
          "code" : "101",
          "display" : "Fakultní nemocnice"
        }
      ]
    }
  ],
  "name" : "Fakultní nemocnice Oblackov",
  "telecom" : [
    {
      "system" : "phone",
      "value" : "+420257216007",
      "use" : "work"
    },
    {
      "system" : "fax",
      "value" : "+420257216007",
      "use" : "work"
    }
  ],
  "address" : [
    {
      "use" : "work",
      "type" : "both",
      "text" : "Fiktivní 951/125, 100 00 Město",
      "line" : ["Fiktivní 951/125"],
      "_line" : [
        {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-streetName",
              "valueString" : "Fiktivní"
            },
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/iso21090-ADXP-houseNumber",
              "valueString" : "951/125"
            }
          ]
        }
      ],
      "city" : "Město",
      "postalCode" : "10000",
      "country" : "CZ"
    }
  ]
}

```
