# Observation: Abdomina Aortic Aneurysms Example (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Abdomina Aortic Aneurysms Example (CZ)**

## Example Observation: Observation: Abdomina Aortic Aneurysms Example (CZ)

Profile: [Observation: Abdomina aortic aneurysms (SZZ CZ)](StructureDefinition-cz-observation-abdomina-aortic-aneurysms.md)

**status**: Final

**category**: Imaging

**code**: Abdominal aortic aneurysm screening

**subject**: [Mračena Mrakomorová Female, DoB: 1988-02-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621111 (use: official, ))](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec)

**effective**: 2025-05-15 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-2a06ef57-f377-4031-a098-612aa44f54b2)

**value**: bez nálezu aneurysmatu



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "dd8033d4-d1c9-48e8-8edd-c0dda913678d",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-abdomina-aortic-aneurysms"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "imaging"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "698356002",
        "display" : "Abdominal aortic aneurysm screening"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec"
  },
  "effectiveDateTime" : "2025-05-15T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:2a06ef57-f377-4031-a098-612aa44f54b2"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-abdomina-aortic-aneurysms-result-cs",
        "code" : "bez",
        "display" : "bez nálezu aneurysmatu"
      }
    ]
  }
}

```
