# Observation: Urology examination (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Urology examination (CZ)**

## Example Observation: Observation: Urology examination (CZ)

Profile: [Observation: Urology (SZZ CZ)](StructureDefinition-cz-observation-urology.md)

**status**: Final

**category**: Exam

**code**: Prostate finding

**subject**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-fe858e7c-ba5f-4641-9878-7c6c4790634f)

**effective**: 2025-11-13 11:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-38e5929e-afe4-40bc-ba9d-c0a80549791e)

**value**: abnormální

**interpretation**: MRI s kontrastní látkou /biopsie

> **component****code**:Quantitative measurement of mass concentration of prostate specific antigen in serum or plasma**value**: 4 ug/l(Details: UCUM codeug/l = 'ug/l')

> **component****code**:Prostate specific Ag/Prostate volume calculated**value**: 0.2 ng/ml/cm3(Details: UCUM codeng/ml/cm3 = 'ng/ml/cm3')

> **component****code**:Prostate specific antigen measurement**value**: 0.75 ng/ml/a(Details: UCUM codeng/ml/a = 'ng/ml/a')

> **component****code**:Prostate volume**value**: 20 ml(Details: UCUM codeml = 'ml')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "bc143cd8-4638-4823-87d5-6bc16ce68e85",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "exam"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "249604002"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:fe858e7c-ba5f-4641-9878-7c6c4790634f"
  },
  "effectiveDateTime" : "2025-11-13T11:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:38e5929e-afe4-40bc-ba9d-c0a80549791e"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-urology-result-cs",
        "code" : "abnormal",
        "display" : "abnormální"
      }
    ]
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-urology-interpretation-cs",
          "code" : "mriwith",
          "display" : "MRI s kontrastní látkou /biopsie"
        }
      ]
    }
  ],
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "443969004",
            "display" : "Quantitative measurement of mass concentration of prostate specific antigen in serum or plasma"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 4,
        "system" : "http://unitsofmeasure.org",
        "code" : "ug/l"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "15325-4"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 0.2,
        "system" : "http://unitsofmeasure.org",
        "code" : "ng/ml/cm3"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "63476009",
            "display" : "Prostate specific antigen measurement"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 0.75,
        "system" : "http://unitsofmeasure.org",
        "code" : "ng/ml/a"
      }
    },
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "1297142007",
            "display" : "Prostate volume"
          }
        ]
      },
      "valueQuantity" : {
        "value" : 20,
        "system" : "http://unitsofmeasure.org",
        "code" : "ml"
      }
    }
  ]
}

```
