# Observation: Prostate Cancer Screening Example (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Prostate Cancer Screening Example (CZ)**

## Example Observation: Observation: Prostate Cancer Screening Example (CZ)

Profile: [Observation: Prostate Cancer Screening (SZZ CZ)](StructureDefinition-cz-observation-prostate-cancer.md)

**status**: Final

**category**: Laboratory

**code**: Prostatický specifický Ag [Hmotnost/objem] v séru nebo plazmě

**subject**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-fe858e7c-ba5f-4641-9878-7c6c4790634f)

**effective**: 2025-12-13 11:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-38e5929e-afe4-40bc-ba9d-c0a80549791e)

**value**: 4 ug/l(Details: UCUM codeug/l = 'ug/l')

**interpretation**: PSA 3,0 UG/L A VÍCE INFORMACE V PROGRAMU ČASNÉHO ZÁCHYTU KARCINOMU PROSTATY



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "824055fa-6107-49c8-b217-f029aa7b8872",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-prostate-cancer"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "2857-1"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:fe858e7c-ba5f-4641-9878-7c6c4790634f"
  },
  "effectiveDateTime" : "2025-12-13T11:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:38e5929e-afe4-40bc-ba9d-c0a80549791e"
    }
  ],
  "valueQuantity" : {
    "value" : 4,
    "system" : "http://unitsofmeasure.org",
    "code" : "ug/l"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-Prostate-cancer-result-cs",
          "code" : "01133"
        }
      ]
    }
  ]
}

```
