# Observation: Urology biopsy (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Urology biopsy (CZ)**

## Example Observation: Observation: Urology biopsy (CZ)

Profile: [Observation: Urology Biopsy(SZZ CZ)](StructureDefinition-cz-observation-urology-biopsy.md)

**status**: Final

**category**: Laboratory

**code**: Biopsy of prostate

**subject**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-fe858e7c-ba5f-4641-9878-7c6c4790634f)

**effective**: 2025-11-13 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-38e5929e-afe4-40bc-ba9d-c0a80549791e)

**value**: maligní - klinicky signifikatní

### Components

| | | |
| :--- | :--- | :--- |
| - | **Code** | **Value[x]** |
| * | Procedure on prostate | cílená |



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "57838f4e-238c-43e4-9088-42971d8171a6",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology-biopsy"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "code" : "65575008"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:fe858e7c-ba5f-4641-9878-7c6c4790634f"
  },
  "effectiveDateTime" : "2025-11-13T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:38e5929e-afe4-40bc-ba9d-c0a80549791e"
    }
  ],
  "valueCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-biopsy-Prostate-cs",
        "code" : "malsig",
        "display" : "maligní - klinicky signifikatní"
      }
    ]
  },
  "component" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "code" : "118877007",
            "display" : "Procedure on prostate"
          }
        ]
      },
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-type-biopsy-cs",
            "code" : "focused",
            "display" : "cílená"
          }
        ]
      }
    }
  ]
}

```
