# Observation: Body Weight Example (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Body Weight Example (CZ)**

## Example Observation: Observation: Body Weight Example (CZ)

Profile: [Observation: Weight (SZZ CZ)](StructureDefinition-cz-bodyweight.md)

**status**: Final

**category**: Vital Signs

**code**: Body weight

**subject**: [Mračena Mrakomorová Female, DoB: 1988-02-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621111 (use: official, ))](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec)

**effective**: 2025-05-15 10:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord-2.md#urn-uuid-2a06ef57-f377-4031-a098-612aa44f54b2)

**value**: 60 kg(Details: UCUM codekg = 'kg')



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "31e1de93-1c46-4f9e-849c-c46f8c7f1496",
  "meta" : {
    "profile" : ["https://hl7.cz/fhir/szz/StructureDefinition/cz-bodyweight"]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "vital-signs"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "29463-7"
      },
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "code" : "20042"
      },
      {
        "system" : "http://snomed.info/sct",
        "code" : "27113001"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec"
  },
  "effectiveDateTime" : "2025-05-15T10:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:2a06ef57-f377-4031-a098-612aa44f54b2"
    }
  ],
  "valueQuantity" : {
    "value" : 60,
    "unit" : "kg",
    "system" : "http://unitsofmeasure.org",
    "code" : "kg"
  }
}

```
