# Observation: Colorectal Cancer Screening Example (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Observation: Colorectal Cancer Screening Example (CZ)**

## Example Observation: Observation: Colorectal Cancer Screening Example (CZ)

Profile: [Observation: Colorectal Cancer Screening (SZZ CZ)](StructureDefinition-cz-observation-colorectal-cancer.md)

**status**: Final

**category**: Laboratory

**code**: Occult blood panel - Stool by Immunoassay

**subject**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-fe858e7c-ba5f-4641-9878-7c6c4790634f)

**effective**: 2025-12-10 11:30:00+0100

**performer**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-screeningrecord.md#urn-uuid-38e5929e-afe4-40bc-ba9d-c0a80549791e)

**value**: 18 ug/g(Details: UCUM codeug/g = 'ug/g')

**interpretation**: Signální výkon – Stanovení okultního krvácení ve stolici speciálním testem v rámci screeningu kolorektálního karcinomu – nález pozitivní



## Resource Content

```json
{
  "resourceType" : "Observation",
  "id" : "02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colorectal-cancer"
    ]
  },
  "status" : "final",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
          "code" : "laboratory"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "57803-9"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:fe858e7c-ba5f-4641-9878-7c6c4790634f"
  },
  "effectiveDateTime" : "2025-12-10T11:30:00+01:00",
  "performer" : [
    {
      "reference" : "urn:uuid:38e5929e-afe4-40bc-ba9d-c0a80549791e"
    }
  ],
  "valueQuantity" : {
    "value" : 18,
    "system" : "http://unitsofmeasure.org",
    "code" : "ug/g"
  },
  "interpretation" : [
    {
      "coding" : [
        {
          "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colorectal-cancer-result-cs",
          "code" : "15121"
        }
      ]
    }
  ]
}

```
