# MedicationStatement: Fludeoxythymidin (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **MedicationStatement: Fludeoxythymidin (CZ)**

## Example MedicationStatement: MedicationStatement: Fludeoxythymidin (CZ)

Profile: [Medication Statement (CZ)](https://build.fhir.org/ig/HL7-cz/cz-core/StructureDefinition-cz-MedicationStatement.html)

**identifier**: `http://example.org/medicationstatements`/MEDSTAT2024

**status**: Active

**medication**: Fludeoxythymidin

**subject**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-emergencyrecord.md#urn-uuid-142534ac-0274-4a16-b6a2-d4d4f24ff67b)

**effective**: 2024-12-01

**informationSource**: [Organization Fakultní nemocnice Oblackov](Bundle-cz-example-bundle-emergencyrecord.md#urn-uuid-f84d821c-ba13-412b-a340-2547a6f36b7f)

> **dosage**

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 260000 ul |




## Resource Content

```json
{
  "resourceType" : "MedicationStatement",
  "id" : "ce0f692f-0461-4ed0-8df3-f8db265f755c",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/medicationstatements",
      "value" : "MEDSTAT2024"
    }
  ],
  "status" : "active",
  "medicationCodeableConcept" : {
    "coding" : [
      {
        "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/dlp-lecive-pripravky-cs",
        "code" : "0226200",
        "display" : "Fludeoxythymidin"
      }
    ]
  },
  "subject" : {
    "reference" : "urn:uuid:142534ac-0274-4a16-b6a2-d4d4f24ff67b"
  },
  "effectiveDateTime" : "2024-12-01",
  "informationSource" : {
    "reference" : "urn:uuid:f84d821c-ba13-412b-a340-2547a6f36b7f"
  },
  "dosage" : [
    {
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 260000,
            "unit" : "ul"
          }
        }
      ]
    }
  ]
}

```
