# CZ Screening record Model to this guide Map - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Screening record Model to this guide Map**

## ConceptMap: CZ Screening record Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/ConceptMap/ScreeningRecord2FHIR-cz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:ScreeningRecord2FHIR |

 
CZ Shared Health Record Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "ScreeningRecord2FHIR-cz",
  "url" : "https://hl7.cz/fhir/szz/ConceptMap/ScreeningRecord2FHIR-cz",
  "version" : "0.0.1",
  "name" : "ScreeningRecord2FHIR",
  "title" : "CZ Screening record Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Shared Health Record Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz",
          "display" : "A.2 - Emergency health record",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner",
          "display" : "A.3.1 - General practitioner record",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord.section:generalPractitioner",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.GynecologyCz",
          "display" : "A.3.2 - Gynecology",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord.section:gynekology",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.GastroenterologyCz",
          "display" : "A.3.3 - Gatroenterology",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord.section:gastroenterology",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.RadiologyCz",
          "display" : "A.3.4 - Radiology",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord.section:radiology",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.BiochemistryLabCz¨",
          "display" : "A.3.5 - Biochemistry Lab",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord.section:biochemistryLab",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.PulmonologyCz",
          "display" : "A.3.6 - Pulmonology",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord.section:pulmonology",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.UrologyCz",
          "display" : "A.3.7 - Urology",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord.section:urology",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.AngiologyCz",
          "display" : "A.3.8 - Angiology",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord.section:angiology",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-height",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.examinationDate",
          "display" : "A.3.1.3.1 - Date of result of preventive check-up performed",
          "target" : [
            {
              "code" : "CZ_BodyHeight.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.height",
          "display" : "A.3.1.3.2 - Height",
          "target" : [
            {
              "code" : "CZ_BodyHeight.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.preventiveCheckUp.examinationDate",
          "display" : "A.3.2.5.1 - Date of result of preventive check-up",
          "target" : [
            {
              "code" : "CZ_BodyHeight.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.preventiveCheckUp.height",
          "display" : "A.3.2.5.2 - Height",
          "target" : [
            {
              "code" : "CZ_BodyHeight.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-weight",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.examinationDate",
          "display" : "A.3.1.3.1 - Date of result of preventive check-up performed",
          "target" : [
            {
              "code" : "CZ_BodyWeight.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.weight",
          "display" : "A.3.1.3.3 - Weight",
          "target" : [
            {
              "code" : "CZ_BodyWeight.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.preventiveCheckUp.examinationDate",
          "display" : "A.3.2.5.1 - Date of result of preventive check-up",
          "target" : [
            {
              "code" : "CZ_BodyHeight.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.preventiveCheckUp.weight",
          "display" : "A.3.2.5.3 - Weight",
          "target" : [
            {
              "code" : "CZ_BodyHeight.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-waistcircumference",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.examinationDate",
          "display" : "A.3.1.3.1 - Date of result of preventive check-up performed",
          "target" : [
            {
              "code" : "CZ_WaistCircumference.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.waistCircumference",
          "display" : "A.3.1.3.6 - Waist circumference",
          "target" : [
            {
              "code" : "CZ_WaistCircumference.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-blood-pressure",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.examinationDate",
          "display" : "A.3.1.3.1 - Date of result of preventive check-up performed",
          "target" : [
            {
              "code" : "CZ_ObservationBloodPressure.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.systolicPressure",
          "display" : "A.3.1.3.4 - Pressure (systolic)",
          "target" : [
            {
              "code" : "CZ_ObservationBloodPressure.component[0].valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitioner.preventiveCheckUp.diastolicPressure",
          "display" : "A.3.1.3.5 - Pressure (diastolic)",
          "target" : [
            {
              "code" : "CZ_ObservationBloodPressure.component[1].valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colorectal-cancer",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitionerCz.colorectalScreening.resultDate",
          "display" : "A.3.1.1.1 - Date of quantitative TOKS result",
          "target" : [
            {
              "code" : "CZ_ObservationColorectalCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitionerCz.colorectalScreening.resultTOKS",
          "display" : "A.3.1.1.2 - Quantitative TOKS result (health service code reported to the health insurance company)",
          "target" : [
            {
              "code" : "CZ_ObservationColorectalCancer.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitionerCz.colorectalScreening.levelTOKS",
          "display" : "A.3.1.1.3 - TOKS level",
          "target" : [
            {
              "code" : "CZ_ObservationColorectalCancer.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.colorectalScreening.resultDate",
          "display" : "A.3.2.1.1 - Date of quantitative TOKS result",
          "target" : [
            {
              "code" : "CZ_ObservationColorectalCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.colorectalScreening.resultTOKS",
          "display" : "A.3.2.1.2 - Quantitative TOKS result",
          "target" : [
            {
              "code" : "CZ_ObservationColorectalCancer.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.colorectalScreening.levelTOKS",
          "display" : "A.3.2.1.3 - TOKS level",
          "target" : [
            {
              "code" : "CZ_ObservationColorectalCancer.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.biochemistry.colorectalScreening.resultDate",
          "display" : "A.3.5.1.1 - Date of quantitative TOKS result",
          "target" : [
            {
              "code" : "CZ_ObservationColorectalCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.biochemistry.colorectalScreening.levelTOKS",
          "display" : "A.3.5.1.2 - TOKS level",
          "target" : [
            {
              "code" : "CZ_ObservationColorectalCancer.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colposcopy-cervical-cancer",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.expertColposcopy.examinationDate",
          "display" : "A.3.2.4.1 - Date of expert colposcopy",
          "target" : [
            {
              "code" : "CZ_ObservationColposcopyCervicalCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.expertColposcopy.examinationResult",
          "display" : "A.3.2.4.2 - Result of expert colposcopy",
          "target" : [
            {
              "code" : "CZ_ObservationColposcopyCervicalCancer.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-cytology-cervical-cancer",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.examinationCytology.examinationDate",
          "display" : "A.3.2.4.1 - Date of cytological examination",
          "target" : [
            {
              "code" : "CZ_ObservationColposcopyCervicalCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.examinationCytology.examinationResult",
          "display" : "A.3.2.4.2 - Result of cytological examination",
          "target" : [
            {
              "code" : "CZ_ObservationColposcopyCervicalCancer.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-hpv-cervical-cancer",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.examinationHPV.examinationDate",
          "display" : "A.3.2.3.1 - Date of high-risk HPV test",
          "target" : [
            {
              "code" : "CZ_ObservationColposcopyCervicalCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.examinationHPV.examinationResult",
          "display" : "A.3.2.3.2 - Result of high-risk HPV test",
          "target" : [
            {
              "code" : "CZ_ObservationColposcopyCervicalCancer.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-immunization-hpv",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.preventiveCheckUp.vaccinationHPV",
          "display" : "A.3.2.5.4 - HPV vaccination",
          "target" : [
            {
              "code" : "CZ_ImmunizationHPV.status",
              "display" : "Immunization status: completed or not done",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.preventiveCheckUp.lastHPVVaccinationDate",
          "display" : "A.3.2.5.5 - HPV vaccination - year of last dose",
          "target" : [
            {
              "code" : "CZ_ImmunizationHPV.occurrenceDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gynecology.preventiveCheckUp.vaccineHPV",
          "display" : "A.3.2.5.6 - HPV vaccination - vaccine",
          "target" : [
            {
              "code" : "CZ_ImmunizationHPV.vaccineCode",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-colonoscopy",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.gastroenterology.colorectalScreening.resultDate",
          "display" : "A.3.3.1.1 - Date of colonoscopy result",
          "target" : [
            {
              "code" : "CZ_ObservationColonoscopy.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gastroenterology.type",
          "display" : "A.3.3.1.2 - Type of colonoscopy performed",
          "target" : [
            {
              "code" : "CZ_ObservationColonoscopy.component:colonoscopyType.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gastroenterology.completeness",
          "display" : "A.3.3.1.3 - Completeness of the colonoscopy performed",
          "target" : [
            {
              "code" : "CZ_ObservationColonoscopy.status",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gastroenterology.resultBBPS",
          "display" : "A.3.3.1.4 - BBPS result",
          "target" : [
            {
              "code" : "CZ_ObservationColonoscopy.component:ColonoscopyBBPS.valueInteger",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gastroenterology.normalFindings",
          "display" : "A.3.3.1.5 - Colonoscopy result - normal findings",
          "target" : [
            {
              "code" : "CZ_ObservationColonoscopy.component:ColonoscopyNormal.valueBoolean",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gastroenterology.mostSeriousFinding",
          "display" : "A.3.3.1.6 - Colonoscopy result - pathology (most serious finding)",
          "target" : [
            {
              "code" : "CZ_ObservationColonoscopy.component:ColonoscopyAbnormal.valueCodeableConcept.coding",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gastroenterology.numberOfAdenomasOrSerratedLesions",
          "display" : "A.3.3.1.7 - Colonoscopy result: pathology (adenomas and serrated lesions)",
          "target" : [
            {
              "code" : "CZ_ObservationColonoscopy.component:ColonoscopyAbnormal.valueInteger",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.gastroenterology.recommendedProcedure",
          "display" : "A.3.3.1.8 - Colonoscopy exam.result: Further recomm.examinations",
          "target" : [
            {
              "code" : "CZ_ObservationColonoscopy.interpretation.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-prostate-cancer",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitionery.prostateCancerScreening.resultDate",
          "display" : "A.3.1.2.1 - Date of PSA result",
          "target" : [
            {
              "code" : "CZ_ObservationProstateCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.generalPractitionery.prostateCancerScreening.resultTOKS",
          "display" : "A.3.1.2.2 - Quantitative PSA result (health service code reported to the health insurance company)",
          "target" : [
            {
              "code" : "CZ_ObservationProstateCancer.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.biochemistry.prostateCancerScreening.analysisDate",
          "display" : "A.3.5.2.1 - Date of PSA analysis",
          "target" : [
            {
              "code" : "CZ_ObservationProstateCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.biochemistry.prostateCancerScreening.levelPSA",
          "display" : "A.3.5.2.2 - PSA level",
          "target" : [
            {
              "code" : "CZ_ObservationProstateCancer.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.prostateCancerScreening.resultDate",
          "display" : "A.3.7.1.1 - Date of PSA screening result",
          "target" : [
            {
              "code" : "CZ_ObservationProstateCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.prostateCancerScreening.levelPSA",
          "display" : "A.3.7.1.2 - Screening PSA level",
          "target" : [
            {
              "code" : "CZ_ObservationProstateCancer.valueQuantity.value",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mammography",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.mammographyExamination.resultDate",
          "display" : "A.3.4.1.1 - Date of mammography examination result",
          "target" : [
            {
              "code" : "CZ_ObservationMammography.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.mammographyExamination.tissueDensity",
          "display" : "A.3.4.1.2 - Breast tissue density according to BIRADS/Tabár classification",
          "target" : [
            {
              "code" : "CZ_ObservationMammography.component:densityTabar.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.mammographyExamination.tissueDensity",
          "display" : "A.3.4.1.2 - Breast tissue density according to BIRADS/Tabár classification",
          "target" : [
            {
              "code" : "CZ_ObservationMammography.component:densityBirads.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.mammographyExamination.examinationResult",
          "display" : "A.3.4.1.3 - Mammography result",
          "target" : [
            {
              "code" : "CZ_ObservationMammography.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mammography-biopsy",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.breastBiopsyResult.resultDate",
          "display" : "A.3.4.2.1 - Biopsy result date",
          "target" : [
            {
              "code" : "CZ_ObservationMammographyBiopsy.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.breastBiopsyResult.biopsyType",
          "display" : "A.3.4.2.2 - Biopsy type",
          "target" : [
            {
              "code" : "CZ_ObservationMammographyBiopsy.component:typeOfBiopsy.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.breastBiopsyResult.biopsyResult",
          "display" : "A.3.4.2.3 - Biopsy result",
          "target" : [
            {
              "code" : "CZ_ObservationMammographyBiopsy.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-lung-cancer",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.lungExamination.resultDate",
          "display" : "A.3.4.3.1 - Date of LDCT result",
          "target" : [
            {
              "code" : "CZ_ObservationLungCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.lungExamination.examinationType",
          "display" : "A.3.4.3.2 - Type of LDCT examination",
          "target" : [
            {
              "code" : "CZ_ObservationLungCancer.component:typeOfObservation.valueCodeableConcept.coding",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.lungExamination.examinationResult",
          "display" : "A.3.4.3.3 - LDCT result",
          "target" : [
            {
              "code" : "CZ_ObservationLungCancer.valueCodeableConcept.coding",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.lungExamination.recommendedProcedure",
          "display" : "A.3.4.3.4 - LDCT examination result",
          "target" : [
            {
              "code" : "CZ_ObservationLungCancer.interpretation.coding",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-mri-prostate-cancer",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.prostateExamination.resultDate",
          "display" : "A.3.4.4.1 - MRI result date",
          "target" : [
            {
              "code" : "CZ_ObservationMRIProstateCancer.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.prostateExamination.examinationType",
          "display" : "A.3.4.4.2 - Type of MRI examination",
          "target" : [
            {
              "code" : "CZ_ObservationMRIProstateCancer.code.coding",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.prostateExamination.examinationResult",
          "display" : "A.3.4.4.3 - MRI result (PI-RADS)",
          "target" : [
            {
              "code" : "CZ_ObservationMRIProstateCancer.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.prostateExamination.findingPIRADS3",
          "display" : "A.3.4.4.4 - Finding in the case of PI-RADS 3",
          "target" : [
            {
              "code" : "CZ_ObservationMRIProstateCancer.component:discoveryZone.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupUrologicalExamination.resultDate",
          "display" : "A.3.7.2.1 - Date of examination result",
          "target" : [
            {
              "code" : "CZ_ObservationUrology.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupUrologicalExamination.examinationResult",
          "display" : "A.3.7.2.2 - Result of clinical examination",
          "target" : [
            {
              "code" : "CZ_ObservationUrology.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupUrologicalExamination.levelPSA",
          "display" : "A.3.7.2.3 - PSA level",
          "target" : [
            {
              "code" : "CZ_ObservationUrology.component:levelPSA.valueQuantity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupUrologicalExamination.prostateVolume",
          "display" : "A.3.7.2.4 - Prostate volume",
          "target" : [
            {
              "code" : "CZ_ObservationUrology.component:prostateVolume.valueQuantity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupUrologicalExamination.densityPSA",
          "display" : "A.3.7.2.5 - Determination of PSA density (PSAD)",
          "target" : [
            {
              "code" : "CZ_ObservationUrology.component:PSAdensity.valueQuantity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupUrologicalExamination.velocityPSA",
          "display" : "A.3.7.2.6 - Determination of PSA velocity (PSAV)",
          "target" : [
            {
              "code" : "CZ_ObservationUrology.component:PSAvelocity.valueQuantity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupUrologicalExamination.furtherProcedure",
          "display" : "A.3.7.2.7 - Examination result",
          "target" : [
            {
              "code" : "CZ_ObservationUrology.interpretation.coding",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-urology-biopsy",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupBiopsy.resultDate",
          "display" : "A.3.7.3.1 - Date of biopsy examination result",
          "target" : [
            {
              "code" : "CZ_ObservationUrologyBiopsy.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupBiopsy.biopsyType",
          "display" : "A.3.7.3.2 - Type of biopsy performed",
          "target" : [
            {
              "code" : "CZ_ObservationUrologyBiopsy.component:typeOfBiopsy.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.urology.followupBiopsy.examinationResult",
          "display" : "A.3.7.3.3 - Biopsy examination result",
          "target" : [
            {
              "code" : "CZ_ObservationUrologyBiopsy.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-abdomina-aortic-aneurysms",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.examinationAneurysmAbnormalAorta.resultDate",
          "display" : "A.3.4.5.1 - Date of USG examination result",
          "target" : [
            {
              "code" : "CZ_ObservationAbdominaAorticAneurysms.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.radiology.examinationAneurysmAbnormalAorta.examinationResult",
          "display" : "A.3.4.5.2 - Ultrasound examination result",
          "target" : [
            {
              "code" : "CZ_ObservationAbdominaAorticAneurysms.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.angiology.abdominalAorticAneurysmAcreening.dateOfResult",
          "display" : "A.3.8.1.1 - Date of ultrasound examination result",
          "target" : [
            {
              "code" : "CZ_ObservationAbdominaAorticAneurysms.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.angiology.abdominalAorticAneurysmAcreening.examinationResult",
          "display" : "A.3.8.1.2 - Ultrasound examination result",
          "target" : [
            {
              "code" : "CZ_ObservationAbdominaAorticAneurysms.valueCodeableConcept.coding.code",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/PreventiveAndScreeningRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-pulmonology",
      "element" : [
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.dateOfResult",
          "display" : "A.3.6.1.1 - Date of pulmonary examination result",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.smoker",
          "display" : "A.3.6.1.2 - Smoking (medical history)",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.component:medicalHistoryOfSmoking.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.numberOfYearsSinceQuitting",
          "display" : "A.3.6.1.3 - Number of years since quitting smoking",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.component:yearsSinceQuittingSmoking.valueInteger",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.numberOfYearsSmoking",
          "display" : "A.3.6.1.4 - Number of years smoking",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.component:yearsOfSmoking.valueInteger",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.numberOfPackYears",
          "display" : "A.3.6.1.5 - Number of pack-years",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.component:packYears.valueInteger",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.physicalExamination",
          "display" : "A.3.6.1.6 - Physical examination result",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.component:physicalExamResult",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.functionalExamination",
          "display" : "A.3.6.1.7 - Lung X-ray result",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.component:functionalExamResult",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.resultXRay",
          "display" : "A.3.6.1.8 - Functional examination result",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.valueCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "PreventiveAndScreeningRecordCz.pulmonology.recommendationLDCT",
          "display" : "A.3.6.1.9 - Examination result",
          "target" : [
            {
              "code" : "CZ_ObservationPulmonology.interpretation",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
