# CZ Emergency record Model to this guide Map - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Emergency record Model to this guide Map**

## ConceptMap: CZ Emergency record Model to this guide Map (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/ConceptMap/EmergencyRecord2FHIR-cz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:EmergencyRecord2FHIR |

 
CZ Shared Health Record Model to this guide mapping 



## Resource Content

```json
{
  "resourceType" : "ConceptMap",
  "id" : "EmergencyRecord2FHIR-cz",
  "url" : "https://hl7.cz/fhir/szz/ConceptMap/EmergencyRecord2FHIR-cz",
  "version" : "0.0.1",
  "name" : "EmergencyRecord2FHIR",
  "title" : "CZ Emergency record Model to this guide Map",
  "status" : "draft",
  "experimental" : true,
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "CZ Shared Health Record Model to this guide mapping",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "group" : [
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/EmergencyRecordCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-composition-sharedhealthrecord",
      "element" : [
        {
          "code" : "EmergencyRecord",
          "display" : "A.2 - Emergency health record",
          "target" : [
            {
              "code" : "Composition.section:emergencyRecord",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.bloodGroup",
          "display" : "A.2.1 - Blood type",
          "target" : [
            {
              "code" : "Composition.section:emergencyRecord.entry:bloodType",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.allergy",
          "display" : "A.2.2 - Allergies and adverse reactions",
          "target" : [
            {
              "code" : "Composition.section:emergencyRecord.entry:allergiesAndAdverseReactions",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.otherEmergencyData",
          "display" : "A.2.3 - Other emergency data",
          "target" : [
            {
              "code" : "Composition.section:emergencyRecord.entry:otherEmergencyInformation",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.usedMedication",
          "display" : "A.2.4 - Medicinal products used in the provision of healthcare services by inpatient care providers",
          "target" : [
            {
              "code" : "Composition.section:emergencyRecord.entry:medicationHistoryDuringHospitalization",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Body.preventiveAndScreeningRecordCz",
          "display" : "A.3 - Preventive and screening health record",
          "target" : [
            {
              "code" : "Composition.section:preventingAndScreeningRecord",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/SzzCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-observation-blood-type",
      "element" : [
        {
          "code" : "EmergencyRecord.bloodGroup.bloodType",
          "display" : "A.2.1.1 - Blood Group Type",
          "target" : [
            {
              "code" : "CZ_ObservationBloodType.valueCodeableableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "bodz.emergencyRecord.bloodGroup.rhesusFactor",
          "display" : "A.2.1.2 - Rhesus Factor",
          "target" : [
            {
              "code" : "CZ_ObservationBloodType.valueCodeableableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.bloodGroup.testCode",
          "display" : "A.2.1.3 - Blood group test code",
          "target" : [
            {
              "code" : "CZ_ObservationBloodType.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.bloodGroup.dateOfDetection",
          "display" : "A.2.1.4 - Date of blood group detection",
          "target" : [
            {
              "code" : "CZ_ObservationBloodType.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "Header.author",
          "display" : "A.1.5 - Author (by whom the SZZ was/were authored)",
          "target" : [
            {
              "code" : "CZ_ObservationBloodType.performer",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/SzzCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-allergyIntolerance-szz",
      "element" : [
        {
          "code" : "EmergencyRecord.allergy.substance",
          "display" : "A.2.2.1 - Substance",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.allergy.allergenCategory",
          "display" : "A.2.2.2 - Allergen category",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.category",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.allergy.criticality",
          "display" : "A.2.2.3 - Criticality",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.criticality",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.allergy.reactionType",
          "display" : "A.2.2.4 - Reaction type",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.type",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.allergy.manifestation",
          "display" : "A.2.2.5 - Manifestation",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.reaction.manifestation",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.allergy.severityReaction",
          "display" : "A.2.2.6 - Clinical severity of manifestation",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.reaction.severity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.allergy.dateOfDetection",
          "display" : "A.2.2.7 - Date of detection",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.onsetDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.allergy.recordOriginator",
          "display" : "A.2.2.8 - Record originator",
          "target" : [
            {
              "code" : "CZ_AllergyIntolerance.recorder",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/SzzCz",
      "target" : "https://hl7.cz/fhir/szz/StructureDefinition/cz-adverse-event",
      "element" : [
        {
          "code" : "EmergencyRecord.otherEmergencyData.eventType",
          "display" : "A.2.3.1 - Event type",
          "target" : [
            {
              "code" : "CZ_AdverseEvent.event",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.otherEmergencyData.suspectedSubstance",
          "display" : "A.2.3.2. - Suspected substance",
          "target" : [
            {
              "code" : "CZ_AdverseEvent.suspectEntity.instance.code",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.otherEmergencyData.suspectedSubstance",
          "display" : "A.2.3.2. - Suspected substance",
          "target" : [
            {
              "code" : "CZ_AdverseEvent.suspectEntity.instance.description",
              "display" : "In case the code is not sufficient to identify the substance, e.g., for a herbal remedy.",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.otherEmergencyData.dateOfDiscovery",
          "display" : "A.2.3.3 - Date of discovery",
          "target" : [
            {
              "code" : "CZ_AdverseEvent.date",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.otherEmergencyData.recordOriginator",
          "display" : "A.2.3.4 - Record originator",
          "target" : [
            {
              "code" : "CZ_AdverseEvent.recorder",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    },
    {
      "source" : "https://hl7.cz/fhir/szz/StructureDefinition/SzzCz",
      "target" : "https://hl7.cz/fhir/core/StructureDefinition/cz-MedicationStatement",
      "element" : [
        {
          "code" : "EmergencyRecord.usedMedication.identification",
          "display" : "A.3.4.1 - Identification of medicinal product",
          "target" : [
            {
              "code" : "CZ_MedicationStatement.medicationCodeableConcept",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.usedMedication.quantity",
          "display" : "A.3.4.2 - Quantity",
          "target" : [
            {
              "code" : "CZ_MedicationStatement.dosage.doseAndRate.doseQuantity",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.usedMedication.dateOfAdministration",
          "display" : "A.2.4.3 - Date of administration",
          "target" : [
            {
              "code" : "CZ_MedicationStatement.effectiveDateTime",
              "equivalence" : "equivalent"
            }
          ]
        },
        {
          "code" : "EmergencyRecord.usedMedication.sourceOfRecord",
          "display" : "A.2.4.4 - Source of record",
          "target" : [
            {
              "code" : "CZ_MedicationStatement.informationSource",
              "equivalence" : "equivalent"
            }
          ]
        }
      ]
    }
  ]
}

```
