# CZ Colonoscopy Type Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Colonoscopy Type Code System**

## CodeSystem: CZ Colonoscopy Type Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-type-cs | *Version*:0.0.1 |
| Active as of 2025-12-09 | *Computable Name*:CZ_ColonoscopyTypeCS |

 
This code system defines the codes for colonoscopy types in the context of the Shared Health Record (SZZ CZ). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CZ_ColonoscopyTypeVS](ValueSet-cz-colonoscopy-type-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-colonoscopy-type-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-type-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CZ_ColonoscopyTypeCS",
  "title" : "CZ Colonoscopy Type Code System",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-12-09",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This code system defines the codes for colonoscopy types in the context of the Shared Health Record (SZZ CZ).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "screening",
      "display" : "Screeningová"
    },
    {
      "code" : "toks",
      "display" : "TOKS+"
    }
  ]
}

```
