# CZ Colonoscopy Abnormal Findings Code System - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ Colonoscopy Abnormal Findings Code System**

## CodeSystem: CZ Colonoscopy Abnormal Findings Code System 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-abnormal-findings-cs | *Version*:0.0.1 |
| Draft as of 2025-12-09 | *Computable Name*:CZ_ColonoscopyAbnormalFindingsCS |

 
This code system defines the codes for abnormal findings observed during a colonoscopy procedure in the context of the Shared Health Record (SZZ CZ). 

 This Code system is referenced in the content logical definition of the following value sets: 

* [CZ_ColonoscopyAbnormalFindingsVS](ValueSet-cz-colonoscopy-abnormal-findings-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-colonoscopy-abnormal-findings-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-colonoscopy-abnormal-findings-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CZ_ColonoscopyAbnormalFindingsCS",
  "title" : "CZ Colonoscopy Abnormal Findings Code System",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-09",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This code system defines the codes for abnormal findings observed during a colonoscopy procedure in the context of the Shared Health Record (SZZ CZ).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "caseSensitive" : true,
  "content" : "complete",
  "count" : 6,
  "concept" : [
    {
      "code" : "adenom",
      "display" : "Adenom"
    },
    {
      "code" : "pleze",
      "display" : "pilovitá léze"
    },
    {
      "code" : "karcinom",
      "display" : "karcinom"
    },
    {
      "code" : "hpolyp",
      "display" : "hyperplastický polyp"
    },
    {
      "code" : "zpolyp",
      "display" : "zánětlivý polyp"
    },
    {
      "code" : "jine",
      "display" : "Jiné"
    }
  ]
}

```
