# Clinical severity of symptoms - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Clinical severity of symptoms**

## CodeSystem: Clinical severity of symptoms 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-clinical-severity-of-symptoms-szz-cs | *Version*:0.0.1 |
| Active as of 2025-03-05 | *Computable Name*:ClinicalSeverityOfSymptomsSzzCs |

 
The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Clinical severity of symptoms. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [ClinicalSeverityOfSymptomsSzzVs](ValueSet-cz-clinical-severity-of-symptoms-szz-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-clinical-severity-of-symptoms-szz-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-clinical-severity-of-symptoms-szz-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "ClinicalSeverityOfSymptomsSzzCs",
  "title" : "Clinical severity of symptoms",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-03-05",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Clinical severity of symptoms.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "content" : "supplement",
  "supplements" : "http://hl7.org/fhir/reaction-event-severity",
  "property" : [
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Not Selectable",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "mild",
      "display" : "mírná",
      "definition" : "mírná",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "definition"
          },
          "value" : "mild"
        }
      ]
    },
    {
      "code" : "moderate",
      "display" : "střední",
      "definition" : "střední",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "definition"
          },
          "value" : "moderate"
        }
      ]
    },
    {
      "code" : "severe",
      "display" : "závažná",
      "definition" : "závažná",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "definition"
          },
          "value" : "severe"
        }
      ]
    }
  ]
}

```
