# Allergy reaction type (CZ supplement) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Allergy reaction type (CZ supplement)**

## CodeSystem: Allergy reaction type (CZ supplement) 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/CodeSystem/cz-allergy-intolerance-type-szz-cs | *Version*:0.0.1 |
| Active as of 2025-03-05 | *Computable Name*:AllergyIntoleranceTypeSzzCs |

 
The Code System is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction type. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [AllergyIntoleranceTypeSzzVs](ValueSet-cz-allergy-intolerance-type-szz-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "cz-allergy-intolerance-type-szz-cs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-allergy-intolerance-type-szz-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "AllergyIntoleranceTypeSzzCs",
  "title" : "Allergy reaction type (CZ supplement)",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-03-05",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "The Code System is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction type.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "content" : "supplement",
  "supplements" : "http://hl7.org/fhir/allergy-intolerance-type",
  "property" : [
    {
      "code" : "notSelectable",
      "uri" : "http://hl7.org/fhir/concept-properties#notSelectable",
      "description" : "Not Selectable",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "allergy",
      "display" : "alergie",
      "definition" : "Alergie",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "definition"
          },
          "value" : "A propensity for hypersensitive reaction(s) to a substance. These reactions are most typically type I hypersensitivity, plus other ''allergy-like'' reactions, including pseudoallergy."
        },
        {
          "language" : "en",
          "use" : {
            "code" : "display"
          },
          "value" : "Allergy"
        }
      ]
    },
    {
      "code" : "intolerance",
      "display" : "intolerance",
      "definition" : "Intolerance",
      "designation" : [
        {
          "language" : "en",
          "use" : {
            "code" : "definition"
          },
          "value" : "A propensity for adverse reactions to a substance that is judged to be not allergic or ''allergy-like''. These reactions are typically (but not necessarily) non-immune. They are to some degree idiosyncratic and/or patient-specific (i.e. are not a reaction that is expected to occur with most or all patients given similar circumstances)."
        },
        {
          "language" : "en",
          "use" : {
            "code" : "display"
          },
          "value" : "Intolerance"
        }
      ]
    }
  ]
}

```
