# AllergyIntolerance: Penicillin Allergy (CZ) - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **AllergyIntolerance: Penicillin Allergy (CZ)**

## Example AllergyIntolerance: AllergyIntolerance: Penicillin Allergy (CZ)

Profile: [Allergy intolerance (SZZ CZ)](StructureDefinition-cz-allergyIntolerance-szz.md)

**identifier**: `http://example.org/allergies`/ALG20200115

**clinicalStatus**: Active

**verificationStatus**: Confirmed

**type**: Allergy

**category**: Medication

**criticality**: High Risk

**code**: V-PENICILIN BBP

**patient**: [Králík Pokusný Male, DoB: 1985-01-12 ( https://ncez.mzcr.cz/fhir/sid/cpoj#0551621110 (use: official, ))](Bundle-cz-example-bundle-emergencyrecord.md#urn-uuid-142534ac-0274-4a16-b6a2-d4d4f24ff67b)

**onset**: 2020-01-15

**recordedDate**: 2020-01-16

**recorder**: [PractitionerRole: specialty = Radiology](Bundle-cz-example-bundle-emergencyrecord.md#urn-uuid-428025b5-e328-4542-8812-dd6a874c44f9)

### Reactions

| | | |
| :--- | :--- | :--- |
| - | **Manifestation** | **Severity** |
| * | Dyspnea | Mild |



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "4b343429-16da-4a5b-be80-17e4122f5956",
  "meta" : {
    "profile" : [
      "https://hl7.cz/fhir/szz/StructureDefinition/cz-allergyIntolerance-szz"
    ]
  },
  "identifier" : [
    {
      "system" : "http://example.org/allergies",
      "value" : "ALG20200115"
    }
  ],
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "confirmed"
      }
    ]
  },
  "type" : "allergy",
  "category" : ["medication"],
  "criticality" : "high",
  "code" : {
    "coding" : [
      {
        "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/dlp-lecive-pripravky-cs",
        "code" : "0233172",
        "display" : "V-PENICILIN BBP"
      }
    ]
  },
  "patient" : {
    "reference" : "urn:uuid:142534ac-0274-4a16-b6a2-d4d4f24ff67b"
  },
  "onsetDateTime" : "2020-01-15",
  "recordedDate" : "2020-01-16",
  "recorder" : {
    "reference" : "urn:uuid:428025b5-e328-4542-8812-dd6a874c44f9"
  },
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "267036007",
              "display" : "Dyspnea"
            }
          ]
        }
      ],
      "severity" : "mild"
    }
  ]
}

```
