# hl7.fhir.cz.szz#0.0.1: HL7 Czech Shared Health Record Implementation Guide

## Pages

* [Home](index.md)
* [Examples](examples.md)
* [Scope and content](scope-and-content.md)
* [Logical models](logical-models.md)
* [Preventive and screening health record Model map](scr-map.md)
* [Background](background-cs.md)
* [Rozsah použití a obsah](scope-and-content-cs.md)
* [Datová sada - logické modely](logical-models-cs.md)
* [Závislosti](dependencies-cs.md)
* [Dependencies](dependencies.md)
* [Mapování logického modelu Preventivních a screeningových zdravotních záznamů](scr-map-cs.md)
* [Copyright](copyright.md)
* [Background](background.md)
* [Příklady](examples-cs.md)
* [Autorská práva](copyright-cs.md)
* [Authors](authors.md)
* [Mapování logického modelu emergentního zdravotního záznamu](ezz-map-cs.md)
* [Download](downloads-cs.md)
* [Mapování logického modelu hlavičky](Header-map-cs.md)
* [Model maps](model-map.md)
* [Emergency Health Record Model map](ezz-map.md)
* [Mapování logického modelu](model-map-cs.md)
* [Workflow](workflow-cs.md)
* [Autoři](authors-cs.md)
* [Artifacts](artifacts.md)
* [Download](downloads.md)
* [Header Model map](Header-map.md)
* [Workflow](workflow.md)
* [Případy užití](use-cases-cs.md)
* [Use cases](use-cases.md)

## Resources

### CodeSystems

* [Prostate Cancer Screening Result Code System](CodeSystem-cz-Prostate-cancer-result-cs.md)
* [Abdomina Aortic Aneurysms Result Code System](CodeSystem-cz-abdomina-aortic-aneurysms-result-cs.md)
* [Allergy reaction type (CZ supplement)](CodeSystem-cz-allergy-intolerance-type-szz-cs.md)
* [Birads Density Result Code System](CodeSystem-cz-birads-density-cs.md)
* [Cervical Cancer Screening Colposcopy Result Code System](CodeSystem-cz-cervical-cancer-colposcopy-result-cs.md)
* [Cervical Cancer Screening Cytology Result Code System](CodeSystem-cz-cervical-cancer-cytology-result-cs.md)
* [Cervical Cancer Screening HPV Result Code System](CodeSystem-cz-cervical-cancer-hpv-result-cs.md)
* [Clinical severity of symptoms](CodeSystem-cz-clinical-severity-of-symptoms-szz-cs.md)
* [CZ Colonoscopy Abnormal Findings Code System](CodeSystem-cz-colonoscopy-abnormal-findings-cs.md)
* [CZ Colonoscopy Interpretation Code System](CodeSystem-cz-colonoscopy-interpretation.md)
* [CZ Colonoscopy Type Code System](CodeSystem-cz-colonoscopy-type-cs.md)
* [Colorectal Cancer Screening Result Code System](CodeSystem-cz-colorectal-cancer-result-cs.md)
* [CZ Type of breast density Code System](CodeSystem-cz-density-type-cs.md)
* [CZ Document Section SZZ Code System](CodeSystem-cz-document-section-szz-cs.md)
* [Functional Examination Pulmonology Result Code System](CodeSystem-cz-functional-examination-pulmonology-result-cs.md)
* [Lung Cancer interpretation Code System](CodeSystem-cz-lung-cancer-interpretation-cs.md)
* [Physical Examination Pulmonology Result Code System](CodeSystem-cz-physical-examination-pulmonology-result-cs.md)
* [Pulmonology interpretation Code System](CodeSystem-cz-pulmonology-interpretation-cs.md)
* [Pulmonology Result Code System](CodeSystem-cz-pulmonology-result-cs.md)
* [Biopsy Prostate Result Code System](CodeSystem-cz-result-biopsy-Prostate-cs.md)
* [Biopsy Breast Result Code System](CodeSystem-cz-result-biopsy-breast-cs.md)
* [Lung Cancer Result Code System](CodeSystem-cz-result-lung-cancer-cs.md)
* [Mammography Result Code System](CodeSystem-cz-result-mammography-cs.md)
* [MRI Prostate Cancer Result Code System](CodeSystem-cz-result-mri-prostate-cancer-cs.md)
* [Tabar Density Result Code System](CodeSystem-cz-tabar-density-cs.md)
* [Tobacco History Code System](CodeSystem-cz-tobacco-history-cs.md)
* [Type of Breast Biopsy Code System](CodeSystem-cz-type-biopsy-breast-cs.md)
* [Type of Prostate Biopsy Code System](CodeSystem-cz-type-biopsy-cs.md)
* [Type of lung cancer observation Code System](CodeSystem-cz-type-lung-cancer-observation-cs.md)
* [Type of adverse event Code System](CodeSystem-cz-type-of-adverse-event-szz-cs.md)
* [Urology interpretation Code System](CodeSystem-cz-urology-interpretation-cs.md)
* [Urology Result Code System](CodeSystem-cz-urology-result-cs.md)

### ValueSets

* [Prostate Cancer Screening Result Value Set](ValueSet-cz-Prostate-cancer-result-vs.md)
* [Abdomina Aortic Aneurysms Result Value set](ValueSet-cz-abdomina-aortic-aneurysms-result-vs.md)
* [Allergy reaction type (CZ)](ValueSet-cz-allergy-intolerance-type-szz-vs.md)
* [Allergy reaction category](ValueSet-cz-allergy-reaction-category-szz-vs.md)
* [Birads Density Result Value set](ValueSet-cz-birads-density-vs.md)
* [Methods for blood pressure determination](ValueSet-cz-blood-pressure-code-szz-vs.md)
* [EHDSI blood type codes](ValueSet-cz-blood-type-ehdsi-vs.md)
* [Laboratory methods for blood type determination](ValueSet-cz-blood-type-laboratory-code-szz-vs.md)
* [Cervical Cancer Screening Colposcopy Result Value Set](ValueSet-cz-cervical-cancer-colposcopy-result-vs.md)
* [Cervical Cancer Screening Cytology Result Value Set](ValueSet-cz-cervical-cancer-cytology-result-vs.md)
* [Cervical Cancer Screening HPV Result Value Set](ValueSet-cz-cervical-cancer-hpv-result-vs.md)
* [Clinical severity of symptoms (CZ)](ValueSet-cz-clinical-severity-of-symptoms-szz-vs.md)
* [CZ Colonoscopy Abnormal Findings Value Set](ValueSet-cz-colonoscopy-abnormal-findings-vs.md)
* [CZ Colonoscopy Interpretation Value Set](ValueSet-cz-colonoscopy-interpretation-vs.md)
* [CZ Colonoscopy Type Valueset](ValueSet-cz-colonoscopy-type-vs.md)
* [Colorectal Cancer Screening Result Alternate Value Set](ValueSet-cz-colorectal-cancer-result-alternate-vs.md)
* [Colorectal Cancer Screening Result Value Set](ValueSet-cz-colorectal-cancer-result-vs.md)
* [Functional Examination Pulmonology Result Value Set](ValueSet-cz-functional-examination-pulmonology-result-vs.md)
* [CZ HPV Vaccine Code Value Set](ValueSet-cz-hpv-vaccine-code-vs.md)
* [Lung Cancer interpretation Value set](ValueSet-cz-lung-cancer-interpretation-vs.md)
* [Method of MRI for prostate cancer determination](ValueSet-cz-mri-prostate-cancer-code-vs.md)
* [ObservationsUnitHeight](ValueSet-cz-observationUnitsHeight-vs.md)
* [ObservationsUnitWeight](ValueSet-cz-observationUnitsWeight-vs.md)
* [Physical Examination Pulmonology Result Value Set](ValueSet-cz-physical-examination-pulmonology-result-vs.md)
* [Pulmonology interpretation Value set](ValueSet-cz-pulmonology-interpretation-vs.md)
* [Pulmonology Result Value set](ValueSet-cz-pulmonology-result-vs.md)
* [Region of prostate for MRI for prostate cancer determination](ValueSet-cz-region-of-prostate-vs.md)
* [Biopsy Prostate Result Valueset](ValueSet-cz-result-biopsy-Prostate-vs.md)
* [Biopsy Breast Result Valueset](ValueSet-cz-result-biopsy-breast-vs.md)
* [Lung Cancer Result Value Set](ValueSet-cz-result-lung-cancer-vs.md)
* [Mammography Result Value Set](ValueSet-cz-result-mammography-vs.md)
* [MRI Prostate Cancer Result Valueset](ValueSet-cz-result-mri-prostate-cancer-vs.md)
* [Tabar Density Result Value set](ValueSet-cz-tabar-density-vs.md)
* [Tobacco History Valueset](ValueSet-cz-tobacco-history-vs.md)
* [Type of Breast Biopsy Valueset](ValueSet-cz-type-biopsy-breast-vs.md)
* [Biopsy Type Prostate Valueset](ValueSet-cz-type-biopsy-prostate-vs.md)
* [Type of lung cancer observation Valueset](ValueSet-cz-type-lung-cancer-observation-vs.md)
* [Type of adverse event Value Set](ValueSet-cz-type-of-adverse-event-szz-vs.md)
* [Urology interpretation Value set](ValueSet-cz-urology-interpretation-vs.md)
* [Urology Result Value Set](ValueSet-cz-urology-result-vs.md)

### Logicals

* [A.3.8 - Angiology](StructureDefinition-AngiologyCz.md)
* [A.3.5 - Biochemistry Lab](StructureDefinition-BiochemistryLabCz.md)
* [A.1.7 - Digital signature](StructureDefinition-DigitalSignatureCz.md)
* [A.2 - Emergency health record](StructureDefinition-EmergencyRecordCz.md)
* [A.3.3 - Gastroenterology](StructureDefinition-GastroenterologyCz.md)
* [A.3.1 - General Practitioner](StructureDefinition-GeneralPractitionerCz.md)
* [A.3.2 - Gynecology](StructureDefinition-GynecologyCz.md)
* [A.1 - Document header](StructureDefinition-HeaderSzzCz.md)
* [A.3.8 - Angiology](StructureDefinition-LogAngiologyCz.md)
* [A.3.5 - Biochemická laboratoř](StructureDefinition-LogBiochemistryLabCz.md)
* [A.2 - Emergentní zdravotní záznam](StructureDefinition-LogEmergencyRecordCz.md)
* [A.1 - Hlavička dokumentu](StructureDefinition-LogHeaderSzzCz.md)
* [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)
* [A.3.6 - Pulmonology](StructureDefinition-LogPulmonologyCz.md)
* [A.3.4 - Radiologie](StructureDefinition-LogRadiologyCz.md)
* [A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu](StructureDefinition-LogSubjectCz.md)
* [A - Sdílený zdravotní záznam](StructureDefinition-LogSzzCz.md)
* [A.3.7 - Urolog](StructureDefinition-LogUrologyCz.md)
* [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md)
* [A.3.6 - Pulmonology](StructureDefinition-PulmonologyCz.md)
* [A.3.4 - Radiology](StructureDefinition-RadiologyCz.md)
* [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md)
* [A - Shared Health Record](StructureDefinition-SzzCz.md)
* [A.3.7 - Urology](StructureDefinition-UrologyCz.md)
* [A.1.7 - Elektronické podpisy](StructureDefinition-logDigitalSignatureCz.md)
* [A.3.3 - Gastroenterologie](StructureDefinition-logGastroenterologyCz.md)
* [A.3.1 - Všeobecný praktický lékař](StructureDefinition-logGeneralPractitionerCz.md)
* [A.3.2 - Gynekologie](StructureDefinition-logGynecologyCz.md)

### Resource Profiles

* [Adverse event (SZZ CZ)](StructureDefinition-cz-adverse-event.md)
* [Allergy intolerance (SZZ CZ)](StructureDefinition-cz-allergyIntolerance-szz.md)
* [Observation: Height (SZZ CZ)](StructureDefinition-cz-bodyheight.md)
* [Observation: Weight (SZZ CZ)](StructureDefinition-cz-bodyweight.md)
* [Bundle (SZZ CZ)](StructureDefinition-cz-bundle-sharedhealthrecord.md)
* [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md)
* [Immunization against HPV Resource Profile (SZZ CZ)](StructureDefinition-cz-immunization-hpv.md)
* [Observation: Abdomina aortic aneurysms (SZZ CZ)](StructureDefinition-cz-observation-abdomina-aortic-aneurysms.md)
* [Observation: Blood Pressure (SZZ CZ)](StructureDefinition-cz-observation-blood-pressure.md)
* [Observation: Blood Type (SZZ CZ)](StructureDefinition-cz-observation-blood-type.md)
* [Observation: Colonoscopy (SZZ CZ)](StructureDefinition-cz-observation-colonoscopy.md)
* [Observation: Colorectal Cancer Screening (SZZ CZ)](StructureDefinition-cz-observation-colorectal-cancer.md)
* [Observation: Cervical Cancer Colposcopy Screening (SZZ CZ)](StructureDefinition-cz-observation-colposcopy-cervical-cancer.md)
* [Observation: Cervical Cancer Cytology Screening (SZZ CZ)](StructureDefinition-cz-observation-cytology-cervical-cancer.md)
* [Observation: Cervical Cancer HPV Screening (SZZ CZ)](StructureDefinition-cz-observation-hpv-cervical-cancer.md)
* [Observation: Lung cancer (SZZ CZ)](StructureDefinition-cz-observation-lung-cancer.md)
* [Observation: Mammography Biopsy(SZZ CZ)](StructureDefinition-cz-observation-mammography-biopsy.md)
* [Observation: Mammography (SZZ CZ)](StructureDefinition-cz-observation-mammography.md)
* [Observation: MRI Prostate Cancer (SZZ CZ)](StructureDefinition-cz-observation-mri-prostate-cancer.md)
* [Observation: Prostate Cancer Screening (SZZ CZ)](StructureDefinition-cz-observation-prostate-cancer.md)
* [Observation: Pulmonology (SZZ CZ)](StructureDefinition-cz-observation-pulmonology.md)
* [Observation: Urology Biopsy(SZZ CZ)](StructureDefinition-cz-observation-urology-biopsy.md)
* [Observation: Urology (SZZ CZ)](StructureDefinition-cz-observation-urology.md)
* [Observation: Waist circumference  (SZZ CZ)](StructureDefinition-cz-waist-circumference.md)

### ConceptMaps

* [CZ Emergency record Model to this guide Map](ConceptMap-EmergencyRecord2FHIR-cz.md)
* [CZ Header Model to this guide Map](ConceptMap-Header2FHIR-cz.md)
* [CZ Screening record Model to this guide Map](ConceptMap-ScreeningRecord2FHIR-cz.md)

### ImplementationGuides

* [HL7 Czech Shared Health Record Implementation Guide](index.md)

### Examples

* [74d87d39-d681-4df4-80a5-975b359e6210 (AdverseEvent)](AdverseEvent-74d87d39-d681-4df4-80a5-975b359e6210.md)
* [4b343429-16da-4a5b-be80-17e4122f5956 (AllergyIntolerance)](AllergyIntolerance-4b343429-16da-4a5b-be80-17e4122f5956.md)
* [cz-example-bundle-emergencyrecord (Bundle)](Bundle-cz-example-bundle-emergencyrecord.md)
* [cz-example-bundle-screeningrecord-2 (Bundle)](Bundle-cz-example-bundle-screeningrecord-2.md)
* [cz-example-bundle-screeningrecord (Bundle)](Bundle-cz-example-bundle-screeningrecord.md)
* [Shared Health Record  - Emergency Report for patient Ing. Králíka (Composition)](Composition-91795ef9-ba97-4712-95b4-177f1d784066.md)
* [Shared Health Record  - Emergency Report for patient Ing. Králíka (Composition)](Composition-930ca243-d3aa-4b38-9737-3c2e48000f74.md)
* [Shared Health Record  - Emergency Report for patient Ing. Králíka (Composition)](Composition-f711d704-df5c-4599-ac80-e8636e0f9931.md)
* [040eb849-a513-4d74-b3f3-d2f246a26877 (DocumentReference)](DocumentReference-040eb849-a513-4d74-b3f3-d2f246a26877.md)
* [2620c461-29d4-44a7-a8d0-599d88fdb60f (DocumentReference)](DocumentReference-2620c461-29d4-44a7-a8d0-599d88fdb60f.md)
* [7248f0f4-a508-4668-acd8-9782ab4e0f98 (DocumentReference)](DocumentReference-7248f0f4-a508-4668-acd8-9782ab4e0f98.md)
* [dd06896e-959b-44ec-b791-19a68ffdc576 (Immunization)](Immunization-dd06896e-959b-44ec-b791-19a68ffdc576.md)
* [d6511f3f-a311-4050-a34a-542f1ffe40bd (Medication)](Medication-d6511f3f-a311-4050-a34a-542f1ffe40bd.md)
* [ce0f692f-0461-4ed0-8df3-f8db265f755c (MedicationStatement)](MedicationStatement-ce0f692f-0461-4ed0-8df3-f8db265f755c.md)
* [02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8 (Observation)](Observation-02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8.md)
* [0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08 (Observation)](Observation-0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08.md)
* [180d74d4-fe14-408c-a3a8-07da4e3b8fcd (Observation)](Observation-180d74d4-fe14-408c-a3a8-07da4e3b8fcd.md)
* [1d79f716-c583-4e42-a68f-bc8c9bb2781d (Observation)](Observation-1d79f716-c583-4e42-a68f-bc8c9bb2781d.md)
* [31e1de93-1c46-4f9e-849c-c46f8c7f1496 (Observation)](Observation-31e1de93-1c46-4f9e-849c-c46f8c7f1496.md)
* [407b583e-4c05-47eb-b0df-6d8166c0d4f1 (Observation)](Observation-407b583e-4c05-47eb-b0df-6d8166c0d4f1.md)
* [40ee0269-0027-4e7b-b061-e039c06cf988 (Observation)](Observation-40ee0269-0027-4e7b-b061-e039c06cf988.md)
* [5031be23-9628-49af-8cac-d23ea87cb8e0 (Observation)](Observation-5031be23-9628-49af-8cac-d23ea87cb8e0.md)
* [504f3628-9a5e-4a1a-83b0-418c4b8dc38b (Observation)](Observation-504f3628-9a5e-4a1a-83b0-418c4b8dc38b.md)
* [57838f4e-238c-43e4-9088-42971d8171a6 (Observation)](Observation-57838f4e-238c-43e4-9088-42971d8171a6.md)
* [5da80cc6-b699-42dc-aeba-86e229063975 (Observation)](Observation-5da80cc6-b699-42dc-aeba-86e229063975.md)
* [76879fde-d561-4435-b119-6bb579bea0f5 (Observation)](Observation-76879fde-d561-4435-b119-6bb579bea0f5.md)
* [824055fa-6107-49c8-b217-f029aa7b8872 (Observation)](Observation-824055fa-6107-49c8-b217-f029aa7b8872.md)
* [82451f85-ee50-4367-b809-0511ea469269 (Observation)](Observation-82451f85-ee50-4367-b809-0511ea469269.md)
* [8a6733be-e107-44b6-99a8-77869faea42a (Observation)](Observation-8a6733be-e107-44b6-99a8-77869faea42a.md)
* [bc143cd8-4638-4823-87d5-6bc16ce68e85 (Observation)](Observation-bc143cd8-4638-4823-87d5-6bc16ce68e85.md)
* [cd2b65ad-9926-4589-98c9-7e581e21602a (Observation)](Observation-cd2b65ad-9926-4589-98c9-7e581e21602a.md)
* [d87b5700-f89c-444b-8360-29c9f7673bf1 (Observation)](Observation-d87b5700-f89c-444b-8360-29c9f7673bf1.md)
* [dd8033d4-d1c9-48e8-8edd-c0dda913678d (Observation)](Observation-dd8033d4-d1c9-48e8-8edd-c0dda913678d.md)
* [f564cd9a-422f-439b-ae17-b2c0a1311ead (Observation)](Observation-f564cd9a-422f-439b-ae17-b2c0a1311ead.md)
* [fa768d55-f16c-457b-8bdc-1d0b1c9e24fa (Observation)](Observation-fa768d55-f16c-457b-8bdc-1d0b1c9e24fa.md)
* [Fakultní nemocnice Oblackov (Organization)](Organization-08f3f0c5-69ac-45c6-9bec-b8ab940ec721.md)
* [Fakultní nemocnice Oblackov (Organization)](Organization-2ef3f712-d586-4b3e-92eb-6a5bddc58a68.md)
* [Fakultní nemocnice Oblackov (Organization)](Organization-f84d821c-ba13-412b-a340-2547a6f36b7f.md)
* [142534ac-0274-4a16-b6a2-d4d4f24ff67b (Patient)](Patient-142534ac-0274-4a16-b6a2-d4d4f24ff67b.md)
* [cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec (Patient)](Patient-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec.md)
* [fe858e7c-ba5f-4641-9878-7c6c4790634f (Patient)](Patient-fe858e7c-ba5f-4641-9878-7c6c4790634f.md)
* [575c3fb2-e037-4415-95da-283679927aba (Practitioner)](Practitioner-575c3fb2-e037-4415-95da-283679927aba.md)
* [c3830e95-5f0a-46e8-a9e4-403f299ab2c5 (Practitioner)](Practitioner-c3830e95-5f0a-46e8-a9e4-403f299ab2c5.md)
* [e031c581-1616-4f9c-a0fe-3d7b5094bf1a (Practitioner)](Practitioner-e031c581-1616-4f9c-a0fe-3d7b5094bf1a.md)
* [2a06ef57-f377-4031-a098-612aa44f54b2 (PractitionerRole)](PractitionerRole-2a06ef57-f377-4031-a098-612aa44f54b2.md)
* [38e5929e-afe4-40bc-ba9d-c0a80549791e (PractitionerRole)](PractitionerRole-38e5929e-afe4-40bc-ba9d-c0a80549791e.md)
* [428025b5-e328-4542-8812-dd6a874c44f9 (PractitionerRole)](PractitionerRole-428025b5-e328-4542-8812-dd6a874c44f9.md)
