# Artifacts - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* **Artifacts**

## Artifacts

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Czech logical model (Informative) 

Logical model in czech language. Informative for this version of the guide.

| | |
| :--- | :--- |
| [A - Sdílený zdravotní záznam](StructureDefinition-LogSzzCz.md) | Logický model Sdíleného zdravotního záznamu podle české specifikace. |
| [A.1 - Hlavička dokumentu](StructureDefinition-LogHeaderSzzCz.md) | Hlavička sdíleného zdravotního záznamu podle české specifikace. |
| [A.1.1 - Identifikace a A.1.2 - Kontaktní informace Pacienta/subjektu](StructureDefinition-LogSubjectCz.md) | Sdílený zdravotní záznam - Identifikace pacienta a kontaktní informace pacienta |
| [A.1.7 - Elektronické podpisy](StructureDefinition-logDigitalSignatureCz.md) | Sdílený zdravotní záznam - Elektronické podpisy nebo pečetě dle zákona 327/2011 §54a |
| [A.2 - Emergentní zdravotní záznam](StructureDefinition-LogEmergencyRecordCz.md) | Sdílený zdravotní záznam - Logický model pro Emergentní zdravotní záznam. |
| [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md) | Sdílený zdravotní záznam - Logický model pro Preventivní a screeningový zdravotní záznam |
| [A.3.1 - Všeobecný praktický lékař](StructureDefinition-logGeneralPractitionerCz.md) | Sdílený zdravotní záznam - Preventivní a screeningové vyšetření všeobecným praktickým lékařem. |
| [A.3.2 - Gynekologie](StructureDefinition-logGynecologyCz.md) | Sdílený zdravotní záznam - Preventivní a screeningové vyšetření Gynekologem. |
| [A.3.3 - Gastroenterologie](StructureDefinition-logGastroenterologyCz.md) | Sdílený zdravotní záznam - Screeningové vyšedtření gastroenterologem. |
| [A.3.4 - Radiologie](StructureDefinition-LogRadiologyCz.md) | Sdílený zdravotní záznam - Screeningové vyšetření radiologem. |
| [A.3.5 - Biochemická laboratoř](StructureDefinition-LogBiochemistryLabCz.md) | Sdílený zdravotní záznam - Screeningy provedené Biochemickou laboratoří. |
| [A.3.6 - Pulmonology](StructureDefinition-LogPulmonologyCz.md) | Sdílený zdravotní záznam - Screeningové vyšetření pneumologem. |
| [A.3.7 - Urolog](StructureDefinition-LogUrologyCz.md) | Sdílený zdravotní záznam - Screeningové vyšetření urologem. |
| [A.3.8 - Angiology](StructureDefinition-LogAngiologyCz.md) | Sdílený zdravotní záznam - Screeningové vyšetření angiologem. |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [A - Shared Health Record](StructureDefinition-SzzCz.md) | Logical model of the Shared Health Record according to Czech specifications. |
| [A.1 - Document header](StructureDefinition-HeaderSzzCz.md) | Header of the shared health record according to Czech specifications. |
| [A.1.1 - Identification and A.1.2 - related contact information of the Patient/subject](StructureDefinition-SubjectCz.md) | Shared Health Record - subject data element |
| [A.1.7 - Digital signature](StructureDefinition-DigitalSignatureCz.md) | Shared Health Record - Electronic signature or seal of a document according to Act 327/2011 §54a |
| [A.2 - Emergency health record](StructureDefinition-EmergencyRecordCz.md) | Shared Health Record - Logical model of Emergency Health Record. |
| [A.3 - Preventive and screening health record](StructureDefinition-PreventiveAndScreeningRecordCz.md) | Shared Health Record - Logical model of Preventive and screening health record |
| [A.3.1 - General Practitioner](StructureDefinition-GeneralPractitionerCz.md) | Shared Health Record - Preventive and screening examinations by a general practitioner. |
| [A.3.2 - Gynecology](StructureDefinition-GynecologyCz.md) | Shared Health Record - Preventive and screening examinations by a gynecologist. |
| [A.3.3 - Gastroenterology](StructureDefinition-GastroenterologyCz.md) | Shared Health Record - Screening examination by gastroenterologist. |
| [A.3.4 - Radiology](StructureDefinition-RadiologyCz.md) | Shared Health Record - Screening examination by radiologist. |
| [A.3.5 - Biochemistry Lab](StructureDefinition-BiochemistryLabCz.md) | Shared Health Record - Screenings performed by the Biochemical Laboratory. |
| [A.3.6 - Pulmonology](StructureDefinition-PulmonologyCz.md) | Shared Health Record - Screening examination by pulmonologist |
| [A.3.7 - Urology](StructureDefinition-UrologyCz.md) | Shared Health Record - Screening examination by urologist. |
| [A.3.8 - Angiology](StructureDefinition-AngiologyCz.md) | Shared Health Record - Screening examination by angiologist |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Adverse event (SZZ CZ)](StructureDefinition-cz-adverse-event.md) | Czech profile for adverse event. |
| [Allergy intolerance (SZZ CZ)](StructureDefinition-cz-allergyIntolerance-szz.md) | Czech profile for allergy intolerance. |
| [Bundle (SZZ CZ)](StructureDefinition-cz-bundle-sharedhealthrecord.md) | Clinical document used to represent a Shared Health Record for the scope of this guide. |
| [Composition (SZZ CZ)](StructureDefinition-cz-composition-sharedhealthrecord.md) | This profile defines how to represent Composition resource in HL7 FHIR for the scope of this guide. |
| [Immunization against HPV Resource Profile (SZZ CZ)](StructureDefinition-cz-immunization-hpv.md) | This profile defines how to represent Immunization against HPV resource in HL7 FHIR for the scope of this guide. |
| [Observation: Abdomina aortic aneurysms (SZZ CZ)](StructureDefinition-cz-observation-abdomina-aortic-aneurysms.md) | This profile defines how to represent Abodmina Aortic Aneurysms Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Blood Pressure (SZZ CZ)](StructureDefinition-cz-observation-blood-pressure.md) | This profile defines how to represent Blood Pressure Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Blood Type (SZZ CZ)](StructureDefinition-cz-observation-blood-type.md) | This profile defines how to represent Blood Type Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Cervical Cancer Colposcopy Screening (SZZ CZ)](StructureDefinition-cz-observation-colposcopy-cervical-cancer.md) | This profile defines how to represent Cervical Cancer Colposcopy Screening Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Cervical Cancer Cytology Screening (SZZ CZ)](StructureDefinition-cz-observation-cytology-cervical-cancer.md) | This profile defines how to represent Cervical Cancer Cytology Screening Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Cervical Cancer HPV Screening (SZZ CZ)](StructureDefinition-cz-observation-hpv-cervical-cancer.md) | This profile defines how to represent Cervical Cancer HPV Screening Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Colonoscopy (SZZ CZ)](StructureDefinition-cz-observation-colonoscopy.md) | This profile defines how to represent Colonoscopy Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Colorectal Cancer Screening (SZZ CZ)](StructureDefinition-cz-observation-colorectal-cancer.md) | This profile defines how to represent Colorectal Cancer Screening Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Height (SZZ CZ)](StructureDefinition-cz-bodyheight.md) | Profile of body height for the scope of the Czech national interoperability project. |
| [Observation: Lung cancer (SZZ CZ)](StructureDefinition-cz-observation-lung-cancer.md) | This profile defines how to represent Lung cancer Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: MRI Prostate Cancer (SZZ CZ)](StructureDefinition-cz-observation-mri-prostate-cancer.md) | This profile defines how to represent MRI prostate cancer Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Mammography (SZZ CZ)](StructureDefinition-cz-observation-mammography.md) | This profile defines how to represent Mammography Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Mammography Biopsy(SZZ CZ)](StructureDefinition-cz-observation-mammography-biopsy.md) | This profile defines how to represent Mammography Biopsy Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Prostate Cancer Screening (SZZ CZ)](StructureDefinition-cz-observation-prostate-cancer.md) | This profile defines how to represent Prostate Cancer Screening Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Pulmonology (SZZ CZ)](StructureDefinition-cz-observation-pulmonology.md) | This profile defines how to represent Pulmonology Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Urology (SZZ CZ)](StructureDefinition-cz-observation-urology.md) | This profile defines how to represent Urology Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Urology Biopsy(SZZ CZ)](StructureDefinition-cz-observation-urology-biopsy.md) | This profile defines how to represent Urology Biopsy Observation resource in HL7 FHIR for the scope of this guide. |
| [Observation: Waist circumference (SZZ CZ)](StructureDefinition-cz-waist-circumference.md) | Profile of waist circumference for the scope of the Czech national interoperability project. |
| [Observation: Weight (SZZ CZ)](StructureDefinition-cz-bodyweight.md) | Profile of body weight for the scope of the Czech national interoperability project. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Abdomina Aortic Aneurysms Result Value set](ValueSet-cz-abdomina-aortic-aneurysms-result-vs.md) | Abdomina Aortic Aneurysms result value set |
| [Allergy reaction category](ValueSet-cz-allergy-reaction-category-szz-vs.md) | The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction category. |
| [Allergy reaction type (CZ)](ValueSet-cz-allergy-intolerance-type-szz-vs.md) | The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction type. |
| [Biopsy Breast Result Valueset](ValueSet-cz-result-biopsy-breast-vs.md) | Biopsy Breast Result value set |
| [Biopsy Prostate Result Valueset](ValueSet-cz-result-biopsy-Prostate-vs.md) | Biopsy Prostate Result value set |
| [Biopsy Type Prostate Valueset](ValueSet-cz-type-biopsy-prostate-vs.md) | Biopsy type prostate value set |
| [Birads Density Result Value set](ValueSet-cz-birads-density-vs.md) | Birads density result value set |
| [CZ Colonoscopy Abnormal Findings Value Set](ValueSet-cz-colonoscopy-abnormal-findings-vs.md) | This value set includes selected codes from the CZ Colonoscopy Abnormal Findings Code System. |
| [CZ Colonoscopy Interpretation Value Set](ValueSet-cz-colonoscopy-interpretation-vs.md) | This value set includes selected codes from the CZ Colonoscopy Interpretation Code System. |
| [CZ Colonoscopy Type Valueset](ValueSet-cz-colonoscopy-type-vs.md) | This valueset includes selected codes from the CZ Colonoscopy Type Code System. |
| [CZ HPV Vaccine Code Value Set](ValueSet-cz-hpv-vaccine-code-vs.md) | This value set includes codes for HPV vaccines used in the Czech Republic. |
| [Cervical Cancer Screening Colposcopy Result Value Set](ValueSet-cz-cervical-cancer-colposcopy-result-vs.md) | Cervical cancer screening colposcopy result value set includes selected codes from Cervical Cancer Screening Colscopy Result Code System. |
| [Cervical Cancer Screening Cytology Result Value Set](ValueSet-cz-cervical-cancer-cytology-result-vs.md) | Cervical cancer screening cytology result value set includes selected codes from Colorectal Cancer Screening Result Code System. |
| [Cervical Cancer Screening HPV Result Value Set](ValueSet-cz-cervical-cancer-hpv-result-vs.md) | Cervical cancer screening HPV result value set includes selected codes from Colorectal Cancer Screening Result Code System. |
| [Clinical severity of symptoms (CZ)](ValueSet-cz-clinical-severity-of-symptoms-szz-vs.md) | The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Clinical severity of symptoms. |
| [Colorectal Cancer Screening Result Alternate Value Set](ValueSet-cz-colorectal-cancer-result-alternate-vs.md) | Alternate Colorectal cancer screening result value set includes selected codes from Colorectal Cancer Screening Result Code System. |
| [Colorectal Cancer Screening Result Value Set](ValueSet-cz-colorectal-cancer-result-vs.md) | Colorectal cancer screening result value set includes selected codes from Colorectal Cancer Screening Result Code System. |
| [EHDSI blood type codes](ValueSet-cz-blood-type-ehdsi-vs.md) | The Value Set is used for Blood Type representation in the Shared Health Record according to EHDSI specifications. |
| [Functional Examination Pulmonology Result Value Set](ValueSet-cz-functional-examination-pulmonology-result-vs.md) | Functional Examination Pulmonology Result value set |
| [Laboratory methods for blood type determination](ValueSet-cz-blood-type-laboratory-code-szz-vs.md) | The Value Set is used for Laboratory methods for blood type determination in the Shared Health Record. |
| [Lung Cancer Result Value Set](ValueSet-cz-result-lung-cancer-vs.md) | Lung cancer result value set |
| [Lung Cancer interpretation Value set](ValueSet-cz-lung-cancer-interpretation-vs.md) | Lung Cancer interpretation value set |
| [MRI Prostate Cancer Result Valueset](ValueSet-cz-result-mri-prostate-cancer-vs.md) | MRI Prostate Cancer Result value set |
| [Mammography Result Value Set](ValueSet-cz-result-mammography-vs.md) | Mammography result value set |
| [Method of MRI for prostate cancer determination](ValueSet-cz-mri-prostate-cancer-code-vs.md) | The Value Set is used for screening methods for prostate cancer determination in the Shared Health Record. |
| [Methods for blood pressure determination](ValueSet-cz-blood-pressure-code-szz-vs.md) | The Value Set is used for methods for blood pressure determination in the Shared Health Record. |
| [ObservationsUnitHeight](ValueSet-cz-observationUnitsHeight-vs.md) | UCUM units for height |
| [ObservationsUnitWeight](ValueSet-cz-observationUnitsWeight-vs.md) | UCUM units for weight |
| [Physical Examination Pulmonology Result Value Set](ValueSet-cz-physical-examination-pulmonology-result-vs.md) | Physical Examination Pulmonology Result value set |
| [Prostate Cancer Screening Result Value Set](ValueSet-cz-Prostate-cancer-result-vs.md) | Prostate cancer screening result value set includes selected codes from Prostate Cancer Screening Result Code System. |
| [Pulmonology Result Value set](ValueSet-cz-pulmonology-result-vs.md) | Pulmonology Result value set |
| [Pulmonology interpretation Value set](ValueSet-cz-pulmonology-interpretation-vs.md) | Pulmonology interpretation value set |
| [Region of prostate for MRI for prostate cancer determination](ValueSet-cz-region-of-prostate-vs.md) | The Value Set is used for region of prostate for cancer determination in the Shared Health Record. |
| [Tabar Density Result Value set](ValueSet-cz-tabar-density-vs.md) | Tabar density result value set |
| [Tobacco History Valueset](ValueSet-cz-tobacco-history-vs.md) | Tobacco History value set |
| [Type of Breast Biopsy Valueset](ValueSet-cz-type-biopsy-breast-vs.md) | Type of Breast Biopsy value set |
| [Type of adverse event Value Set](ValueSet-cz-type-of-adverse-event-szz-vs.md) | Type of adverse event value set includes selected codes from Type of adverse event Code System. |
| [Type of lung cancer observation Valueset](ValueSet-cz-type-lung-cancer-observation-vs.md) | Type of lung cancer observation value set |
| [Urology Result Value Set](ValueSet-cz-urology-result-vs.md) | Urology result value set |
| [Urology interpretation Value set](ValueSet-cz-urology-interpretation-vs.md) | Urology interpretation value set |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Abdomina Aortic Aneurysms Result Code System](CodeSystem-cz-abdomina-aortic-aneurysms-result-cs.md) | Abdomina Aortic Aneurysms result code system |
| [Allergy reaction type (CZ supplement)](CodeSystem-cz-allergy-intolerance-type-szz-cs.md) | The Code System is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Allergy reaction type. |
| [Biopsy Breast Result Code System](CodeSystem-cz-result-biopsy-breast-cs.md) | Biopsy Breast result code system |
| [Biopsy Prostate Result Code System](CodeSystem-cz-result-biopsy-Prostate-cs.md) | Biopsy Prostate result code system |
| [Birads Density Result Code System](CodeSystem-cz-birads-density-cs.md) | Birads density result code system |
| [CZ Colonoscopy Abnormal Findings Code System](CodeSystem-cz-colonoscopy-abnormal-findings-cs.md) | This code system defines the codes for abnormal findings observed during a colonoscopy procedure in the context of the Shared Health Record (SZZ CZ). |
| [CZ Colonoscopy Interpretation Code System](CodeSystem-cz-colonoscopy-interpretation.md) | This code system defines the codes for interpreting colonoscopy findings in the context of the Shared Health Record (SZZ CZ). |
| [CZ Colonoscopy Type Code System](CodeSystem-cz-colonoscopy-type-cs.md) | This code system defines the codes for colonoscopy types in the context of the Shared Health Record (SZZ CZ). |
| [CZ Document Section SZZ Code System](CodeSystem-cz-document-section-szz-cs.md) | This Code System defines codes for sections used in the Shared Health Record (SZZ) in Czechia. |
| [CZ Type of breast density Code System](CodeSystem-cz-density-type-cs.md) | This Code System defines codes for type breast density in Czechia. |
| [Cervical Cancer Screening Colposcopy Result Code System](CodeSystem-cz-cervical-cancer-colposcopy-result-cs.md) | Cervical cancer screening colposcopy result code system |
| [Cervical Cancer Screening Cytology Result Code System](CodeSystem-cz-cervical-cancer-cytology-result-cs.md) | Cervical cancer screening cytology result code system |
| [Cervical Cancer Screening HPV Result Code System](CodeSystem-cz-cervical-cancer-hpv-result-cs.md) | Cervical cancer screening HPV result code system |
| [Clinical severity of symptoms](CodeSystem-cz-clinical-severity-of-symptoms-szz-cs.md) | The Value Set is used for Record of allergy or other significant adverse reaction to a substance or medicinal product in the Shared Health Record to indicate the Clinical severity of symptoms. |
| [Colorectal Cancer Screening Result Code System](CodeSystem-cz-colorectal-cancer-result-cs.md) | Colorectal cancer screening result code system |
| [Functional Examination Pulmonology Result Code System](CodeSystem-cz-functional-examination-pulmonology-result-cs.md) | Functional Examination Pulmonology Result code system |
| [Lung Cancer Result Code System](CodeSystem-cz-result-lung-cancer-cs.md) | Lung cancer result code system |
| [Lung Cancer interpretation Code System](CodeSystem-cz-lung-cancer-interpretation-cs.md) | Lung Cancer interpretation code system |
| [MRI Prostate Cancer Result Code System](CodeSystem-cz-result-mri-prostate-cancer-cs.md) | MRI Prostate Cancer result code system |
| [Mammography Result Code System](CodeSystem-cz-result-mammography-cs.md) | Mammography result code system |
| [Physical Examination Pulmonology Result Code System](CodeSystem-cz-physical-examination-pulmonology-result-cs.md) | Physical Examination Pulmonology Result code system |
| [Prostate Cancer Screening Result Code System](CodeSystem-cz-Prostate-cancer-result-cs.md) | Prostate cancer screening result code system |
| [Pulmonology Result Code System](CodeSystem-cz-pulmonology-result-cs.md) | Pulmonology Result code system |
| [Pulmonology interpretation Code System](CodeSystem-cz-pulmonology-interpretation-cs.md) | Pulmonology interpretation code system |
| [Tabar Density Result Code System](CodeSystem-cz-tabar-density-cs.md) | Tabar density result code system |
| [Tobacco History Code System](CodeSystem-cz-tobacco-history-cs.md) | Tobacco history code system |
| [Type of Breast Biopsy Code System](CodeSystem-cz-type-biopsy-breast-cs.md) | Type of Breast Biopsy code system |
| [Type of Prostate Biopsy Code System](CodeSystem-cz-type-biopsy-cs.md) | Type of Prostate Biopsy code system |
| [Type of adverse event Code System](CodeSystem-cz-type-of-adverse-event-szz-cs.md) | Type of adverse event code system according to act $34a para 2 of Act No. 325/2021 Coll., on health services, as amended. |
| [Type of lung cancer observation Code System](CodeSystem-cz-type-lung-cancer-observation-cs.md) | Type of lung cancer observation code system |
| [Urology Result Code System](CodeSystem-cz-urology-result-cs.md) | Urology result code system |
| [Urology interpretation Code System](CodeSystem-cz-urology-interpretation-cs.md) | Urology interpretation code system |

### Terminology: Concept Maps 

These define transformations to convert between codes by systems conforming with this implementation guide.

| | |
| :--- | :--- |
| [CZ Emergency record Model to this guide Map](ConceptMap-EmergencyRecord2FHIR-cz.md) | CZ Shared Health Record Model to this guide mapping |
| [CZ Header Model to this guide Map](ConceptMap-Header2FHIR-cz.md) | CZ Shared Health Record Model to this guide mapping |
| [CZ Screening record Model to this guide Map](ConceptMap-ScreeningRecord2FHIR-cz.md) | CZ Shared Health Record Model to this guide mapping |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| | |
| :--- | :--- |
| [AdverseEvent: Rash due to Penicillin (CZ)](AdverseEvent-74d87d39-d681-4df4-80a5-975b359e6210.md) | Example of AdverseEvent resource representing rash due to Penicillin. |
| [AllergyIntolerance: Penicillin Allergy (CZ)](AllergyIntolerance-4b343429-16da-4a5b-be80-17e4122f5956.md) | Example of AllergyIntolerance resource representing allergy to Penicillin. |
| [Bundle: Emergency Report (CZ)](Bundle-cz-example-bundle-emergencyrecord.md) | Example of Shared Health Record Bundle containing Emergency Report. |
| [Bundle: Female Preventive and screening Report (CZ)](Bundle-cz-example-bundle-screeningrecord-2.md) | Example of Shared Health Record Bundle containing Screening Report for female patient. |
| [Bundle: Male Preventive and screening Report (CZ)](Bundle-cz-example-bundle-screeningrecord.md) | Example of Shared Health Record Bundle containing Screening Report for male patient. |
| [Composition: Emergency Report (CZ)](Composition-f711d704-df5c-4599-ac80-e8636e0f9931.md) | Composition example for Shared Health Record containing Emergency Report. |
| [Composition: Screening Report (CZ)](Composition-91795ef9-ba97-4712-95b4-177f1d784066.md) | Composition example for Shared Health Record containing Screening Report. |
| [Composition: Screening Report 2 (CZ)](Composition-930ca243-d3aa-4b38-9737-3c2e48000f74.md) | Composition example for Shared Health Record containing Screening Report. |
| [Medication: Fludeoxythymidin (CZ)](Medication-d6511f3f-a311-4050-a34a-542f1ffe40bd.md) | Example of Medication resource representing Fludeoxythymidin medication. |
| [MedicationStatement: Fludeoxythymidin (CZ)](MedicationStatement-ce0f692f-0461-4ed0-8df3-f8db265f755c.md) | Example of MedicationStatement resource representing Fludeoxythymidin medication. |
| [Observation Blood Type for Patient Králík](Observation-5da80cc6-b699-42dc-aeba-86e229063975.md) | Blood type observation for Patient Králík in SZZ |
| [Observation: Abdomina Aortic Aneurysms Example (CZ)](Observation-dd8033d4-d1c9-48e8-8edd-c0dda913678d.md) | Example of Abdomina Aortic Aneurysms for Shared Health Record. |
| [Observation: Blood Pressure Example (CZ)](Observation-d87b5700-f89c-444b-8360-29c9f7673bf1.md) | Example of Blood Pressure Observation for Shared Health Record. |
| [Observation: Body Height Example (CZ)](Observation-5031be23-9628-49af-8cac-d23ea87cb8e0.md) | Example of Body Height Observation for Shared Health Record. |
| [Observation: Body Height Example (CZ)](Observation-504f3628-9a5e-4a1a-83b0-418c4b8dc38b.md) | Example of Body Height Observation for Shared Health Record. |
| [Observation: Body Weight Example (CZ)](Observation-31e1de93-1c46-4f9e-849c-c46f8c7f1496.md) | Example of Body Weight Observation for Shared Health Record. |
| [Observation: Body Weight Example (CZ)](Observation-8a6733be-e107-44b6-99a8-77869faea42a.md) | Example of Body Weight Observation for Shared Health Record. |
| [Observation: Colonoscopy Example (CZ)](Observation-cd2b65ad-9926-4589-98c9-7e581e21602a.md) | Example of Colonoscopy Observation for Shared Health Record. |
| [Observation: Colorectal Cancer Screening Example (CZ)](Observation-02f3d1a4-4a5c-42ae-9f68-ba2f7dfe88a8.md) | Example of Colorectal Cancer Observation for Shared Health Record. |
| [Observation: Colposcopy cervical cancer](Observation-180d74d4-fe14-408c-a3a8-07da4e3b8fcd.md) | Example of Colposcopy cervical cancer for Shared Health Record. |
| [Observation: Cytology cervical cancer](Observation-40ee0269-0027-4e7b-b061-e039c06cf988.md) | Example of Cytology cervical cancer for Shared Health Record |
| [Observation: HPV cervical cancer](Observation-1d79f716-c583-4e42-a68f-bc8c9bb2781d.md) | Example of HPV cervical cancer for Shared Health Record |
| [Observation: Immunization HPV Example (CZ)](Immunization-dd06896e-959b-44ec-b791-19a68ffdc576.md) | Example of Immunization HPV for Shared Health Record. |
| [Observation: Lung cancer](Observation-f564cd9a-422f-439b-ae17-b2c0a1311ead.md) | Example of Lung cancer for Shared Health Record |
| [Observation: Mammography](Observation-0a3b5d6a-e9a8-4aa2-bcff-7c916540bf08.md) | Example of Mammography for Shared Health Record |
| [Observation: Mammography biopsy](Observation-fa768d55-f16c-457b-8bdc-1d0b1c9e24fa.md) | Example of Mammography biopsy for Shared Health Record |
| [Observation: Prostate Cancer Screening Example (CZ)](Observation-824055fa-6107-49c8-b217-f029aa7b8872.md) | Example of Prostate Cancer Observation for Shared Health Record. |
| [Observation: Pulmonology](Observation-407b583e-4c05-47eb-b0df-6d8166c0d4f1.md) | Example of Pulmonology for Shared Health Record |
| [Observation: Urology biopsy (CZ)](Observation-57838f4e-238c-43e4-9088-42971d8171a6.md) | Urology biopsy example for Shared Health Record containing Screening Report. |
| [Observation: Urology examination (CZ)](Observation-bc143cd8-4638-4823-87d5-6bc16ce68e85.md) | Urology examination example for Shared Health Record containing Screening Report. |
| [Observation: Waist circumference Example (CZ)](Observation-82451f85-ee50-4367-b809-0511ea469269.md) | Example of Waist circumference Observation for Shared Health Record. |
| [Patient Králík](Patient-142534ac-0274-4a16-b6a2-d4d4f24ff67b.md) | Patient in SZZ |
| [Patient Králík](Patient-fe858e7c-ba5f-4641-9878-7c6c4790634f.md) | Male patient in SZZ |
| [Patient Mrakomorová](Patient-cb1344a1-ee6e-45b3-a6b4-c3eacae4ddec.md) | Female patient in SZZ |
| [Practitioner Testovací](Practitioner-575c3fb2-e037-4415-95da-283679927aba.md) | Author of SZZ report |
| [Practitioner Testovací](Practitioner-c3830e95-5f0a-46e8-a9e4-403f299ab2c5.md) | Author of SZZ report |
| [Practitioner Testovací](Practitioner-e031c581-1616-4f9c-a0fe-3d7b5094bf1a.md) | Author of SZZ report |
| [PractitionerRole Testovací](PractitionerRole-2a06ef57-f377-4031-a098-612aa44f54b2.md) | Author of SZZ report |
| [PractitionerRole Testovací](PractitionerRole-38e5929e-afe4-40bc-ba9d-c0a80549791e.md) | Author of SZZ report |
| [PractitionerRole Testovací](PractitionerRole-428025b5-e328-4542-8812-dd6a874c44f9.md) | Author of SZZ report |
| [cz-example-observation-mri-prostate-cancer](Observation-76879fde-d561-4435-b119-6bb579bea0f5.md) |  |
| [cz-example-organization](Organization-f84d821c-ba13-412b-a340-2547a6f36b7f.md) | An example of the organization with logo extension |
| [cz-example-organization2](Organization-2ef3f712-d586-4b3e-92eb-6a5bddc58a68.md) | An example of the organization with logo extension |
| [cz-example-organization3](Organization-08f3f0c5-69ac-45c6-9bec-b8ab940ec721.md) | An example of the organization with logo extension |
| [cz-logo-example](DocumentReference-040eb849-a513-4d74-b3f3-d2f246a26877.md) | Example of logo as document reference for FN Obláčkov. |
| [cz-logo-example2](DocumentReference-7248f0f4-a508-4668-acd8-9782ab4e0f98.md) | Example of logo as document reference for FN Obláčkov. |
| [cz-logo-example3](DocumentReference-2620c461-29d4-44a7-a8d0-599d88fdb60f.md) | Example of logo as document reference for FN Obláčkov. |

