# Biopsy Breast Result Valueset - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Biopsy Breast Result Valueset**

## ValueSet: Biopsy Breast Result Valueset 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/ValueSet/cz-result-biopsy-breast-vs | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:ResultBiopsyBreastVS |

 
Biopsy Breast Result value set 

 **References** 

* [Observation: Mammography Biopsy(SZZ CZ)](StructureDefinition-cz-observation-mammography-biopsy.md)

### Logical Definition (CLD)

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-result-biopsy-breast-vs",
  "url" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-result-biopsy-breast-vs",
  "version" : "0.0.1",
  "name" : "ResultBiopsyBreastVS",
  "title" : "Biopsy Breast Result Valueset",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Biopsy Breast Result value set",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://ncez.mzcr.cz/terminology/CodeSystem/cz-result-biopsy-breast-cs"
      }
    ]
  }
}

```
