# CZ HPV Vaccine Code Value Set - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **CZ HPV Vaccine Code Value Set**

## ValueSet: CZ HPV Vaccine Code Value Set 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/terminology/ValueSet/cz-hpv-vaccine-code-vs | *Version*:0.0.1 |
| Active as of 2025-06-10 | *Computable Name*:CZ_HpvVaccineCodeVs |

 
This value set includes codes for HPV vaccines used in the Czech Republic. 

 **References** 

* [Immunization against HPV Resource Profile (SZZ CZ)](StructureDefinition-cz-immunization-hpv.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-hpv-vaccine-code-vs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/terminology/ValueSet/cz-hpv-vaccine-code-vs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "CZ_HpvVaccineCodeVs",
  "title" : "CZ HPV Vaccine Code Value Set",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-06-10",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "This value set includes codes for HPV vaccines used in the Czech Republic.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://ncez.mzcr.cz/fhir/CodeSystem/dlp-lecive-pripravky-cs",
        "concept" : [
          {
            "code" : "0029160",
            "display" : "CERVARIX"
          },
          {
            "code" : "0029161",
            "display" : "CERVARIX"
          },
          {
            "code" : "0029162",
            "display" : "CERVARIX"
          },
          {
            "code" : "0029163",
            "display" : "CERVARIX"
          },
          {
            "code" : "0029164",
            "display" : "CERVARIX"
          },
          {
            "code" : "0029165",
            "display" : "CERVARIX"
          },
          {
            "code" : "0029166",
            "display" : "CERVARIX"
          },
          {
            "code" : "0029167",
            "display" : "CERVARIX"
          },
          {
            "code" : "0029168",
            "display" : "CERVARIX"
          },
          {
            "code" : "0500876",
            "display" : "CERVARIX"
          },
          {
            "code" : "0500877",
            "display" : "CERVARIX"
          },
          {
            "code" : "0500878",
            "display" : "CERVARIX"
          },
          {
            "code" : "0027879",
            "display" : "GARDASIL"
          },
          {
            "code" : "0027880",
            "display" : "GARDASIL"
          },
          {
            "code" : "0027881",
            "display" : "GARDASIL"
          },
          {
            "code" : "0027882",
            "display" : "GARDASIL"
          },
          {
            "code" : "0027883",
            "display" : "GARDASIL"
          },
          {
            "code" : "0027884",
            "display" : "GARDASIL"
          },
          {
            "code" : "0027885",
            "display" : "GARDASIL"
          },
          {
            "code" : "0027886",
            "display" : "GARDASIL"
          },
          {
            "code" : "0029370",
            "display" : "GARDASIL"
          },
          {
            "code" : "0029372",
            "display" : "GARDASIL"
          },
          {
            "code" : "0029373",
            "display" : "GARDASIL"
          },
          {
            "code" : "0029374",
            "display" : "GARDASIL"
          },
          {
            "code" : "0210635",
            "display" : "GARDASIL 9"
          },
          {
            "code" : "0210636",
            "display" : "GARDASIL 9"
          },
          {
            "code" : "0210637",
            "display" : "GARDASIL 9"
          },
          {
            "code" : "0238503",
            "display" : "GARDASIL 9"
          }
        ]
      }
    ]
  }
}

```
