# Laboratory methods for blood type determination - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **Laboratory methods for blood type determination**

## ValueSet: Laboratory methods for blood type determination 

| | |
| :--- | :--- |
| *Official URL*:https://ncez.mzcr.cz/nclp/ValueSet/nclp-blood-group-panel | *Version*:0.0.1 |
| Active as of 2025-03-05 | *Computable Name*:BloodTypeLaboratoryCodeSzzVs |

 
The Value Set is used for Laboratory methods for blood type determination in the Shared Health Record. 

 **References** 

* [Observation: Blood Type (SZZ CZ)](StructureDefinition-cz-observation-blood-type.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "cz-blood-type-laboratory-code-szz-vs",
  "language" : "cs",
  "url" : "https://ncez.mzcr.cz/nclp/ValueSet/nclp-blood-group-panel",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986"
    }
  ],
  "version" : "0.0.1",
  "name" : "BloodTypeLaboratoryCodeSzzVs",
  "title" : "Laboratory methods for blood type determination",
  "status" : "active",
  "experimental" : false,
  "date" : "2025-03-05",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "The Value Set is used for Laboratory methods for blood type determination in the Shared Health Record.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://nclp.ncez.mzcr.cz/CodeSystem/nclppol",
        "concept" : [
          {
            "code" : "05165",
            "display" : "Krevní skupina AB0Rh/D/ novorozenec (B; přítomnost [-] Aglutinace (gel))"
          },
          {
            "code" : "05163",
            "display" : "Krevní skupina AB0 RhD kompletní (B; přítomnost [-] Aglutinace (zkum.))"
          },
          {
            "code" : "05162",
            "display" : "Krevní skupina AB0 RhD kompletní (B; přítomnost [-] Aglutinace (gel))"
          },
          {
            "code" : "05166",
            "display" : "Krevní skupina AB0Rh/D/ novorozenec (B; přítomnost [-] Aglutinace (zkum.))"
          }
        ]
      }
    ]
  }
}

```
