# A.3.3 - Gastroenterologie - HL7 Czech Shared Health Record Implementation Guide v0.0.1

* [**Table of Contents**](toc.md)
* [**Artifacts**](artifacts.md)
* **A.3.3 - Gastroenterologie**

## Logical Model: A.3.3 - Gastroenterologie 

| | |
| :--- | :--- |
| *Official URL*:https://hl7.cz/fhir/szz/StructureDefinition/logGastroenterologyCz | *Version*:0.0.1 |
| Draft as of 2025-12-22 | *Computable Name*:LogCzGastroenterologyCz |

 
Sdílený zdravotní záznam - Screeningové vyšedtření gastroenterologem. 

**Usages:**

* Use this Logical Model: [A.3 - Preventivní a screeningový zdravotní záznam](StructureDefinition-LogPreventiveAndScreeningRecordCz.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.cz.szz|current/StructureDefinition/logGastroenterologyCz)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-logGastroenterologyCz.csv), [Excel](StructureDefinition-logGastroenterologyCz.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "logGastroenterologyCz",
  "url" : "https://hl7.cz/fhir/szz/StructureDefinition/logGastroenterologyCz",
  "version" : "0.0.1",
  "name" : "LogCzGastroenterologyCz",
  "title" : "A.3.3 - Gastroenterologie",
  "status" : "draft",
  "date" : "2025-12-22T12:04:24+00:00",
  "publisher" : "HL7 Czech Republic",
  "contact" : [
    {
      "name" : "HL7 Czech Republic",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.hl7.cz/"
        }
      ]
    }
  ],
  "description" : "Sdílený zdravotní záznam - Screeningové vyšedtření gastroenterologem.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "CZ",
          "display" : "Czechia"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://hl7.cz/fhir/szz/StructureDefinition/logGastroenterologyCz",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Base",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "logGastroenterologyCz",
        "path" : "logGastroenterologyCz",
        "short" : "A.3.3 - Gastroenterologie",
        "definition" : "Sdílený zdravotní záznam - Screeningové vyšedtření gastroenterologem."
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening",
        "path" : "logGastroenterologyCz.kolorektalniScreening",
        "short" : "A.3.3.1 - Výsledek vyšetření v rámci screeningu kolorektálního karcinomu",
        "definition" : "A.3.3.1 - Výsledek vyšetření v rámci screeningu kolorektálního karcinomu",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Base"
          }
        ]
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening.datumVysledku",
        "path" : "logGastroenterologyCz.kolorektalniScreening.datumVysledku",
        "short" : "A.3.3.1.1 - Datum výsledku koloskopie",
        "definition" : "Datum provedení koloskopie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening.typ",
        "path" : "logGastroenterologyCz.kolorektalniScreening.typ",
        "short" : "A.3.3.1.2 - Typ provedené koloskopie",
        "definition" : "Pacientovi byla provedena screeningová koloskopie, TOKS+ koloskopie (tj. koloskopie po pozitivním screeningovém TOKS).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening.kompletnost",
        "path" : "logGastroenterologyCz.kolorektalniScreening.kompletnost",
        "short" : "A.3.3.1.3 - Kompletnost provedené koloskopie",
        "definition" : "Provedená koloskopie byla kompletní (bylo dosaženo céka), nebo nekompletní (nebylo dosaženo céka).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening.vysledekBBPS",
        "path" : "logGastroenterologyCz.kolorektalniScreening.vysledekBBPS",
        "short" : "A.3.3.1.4 - Výsledek BBPS",
        "definition" : "Hodnota 0 až 9 dle Bostonské klasifikace (BBPS – Boston Bowel Preparation Scale).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening.normalniNalez",
        "path" : "logGastroenterologyCz.kolorektalniScreening.normalniNalez",
        "short" : "A.3.3.1.5 - Výsledek koloskopie - normální nález",
        "definition" : "Nález v rámci provedené koloskopie byl normální (bez patologie).",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening.nejzavaznejsiNalez",
        "path" : "logGastroenterologyCz.kolorektalniScreening.nejzavaznejsiNalez",
        "short" : "A.3.3.1.6 - Výsledek koloskopie - patologie (nejzávažnější nález)",
        "definition" : "Nejzávažnější patologie v rámci provedené koloskopie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening.pocetAdenomuNeboPilovitychLezi",
        "path" : "logGastroenterologyCz.kolorektalniScreening.pocetAdenomuNeboPilovitychLezi",
        "short" : "A.3.3.1.7 - Výsledek koloskopie - patologie (adenomy a pilovité léze)",
        "definition" : "Počet adenomů a pilovitých lézí (nehyperplastických) v rámci provedené koloskopie.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "logGastroenterologyCz.kolorektalniScreening.doporucenyPostup",
        "path" : "logGastroenterologyCz.kolorektalniScreening.doporucenyPostup",
        "short" : "A.3.3.1.8 - Výsledek vyšetření koloskopie: Další doporučené vyšetření",
        "definition" : "Závěrečné zhodnocení výsledků lékařem.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
